/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.framework.util;

import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.ICheckContext;
import eu.cqse.check.framework.core.phase.ECodeViewOption;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import java.util.List;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.conqat.lib.commons.utils.UtilsInstantiationNotSupportedException;

public final class SwitchStatementUtils {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Set<String> FALLTHROUGH_ATTRIBUTES = CollectionUtils.asHashSet((Object[])new String[]{"fallthrough", "clang::fallthrough"});

    public static boolean isSwitch(ShallowEntity entity) {
        return entity.getType() == EShallowEntityType.STATEMENT && (entity.getSubtype().equals("switch") || entity.getSubtype().equals("switch expression"));
    }

    public static boolean isCase(ShallowEntity entity) {
        return entity.getType() == EShallowEntityType.META && entity.getSubtype().equals("case");
    }

    public static boolean isDefault(ShallowEntity entity) {
        return entity.getType() == EShallowEntityType.META && entity.getSubtype().equals("default");
    }

    public static boolean isAnonymousBlock(ShallowEntity entity) {
        return entity.getType() == EShallowEntityType.STATEMENT && entity.getSubtype().equals("anonymous block");
    }

    public static boolean isCaseOrDefault(ShallowEntity entity) {
        return entity.getType() == EShallowEntityType.META && (entity.getSubtype().equals("case") || entity.getSubtype().equals("default"));
    }

    public static boolean isFallThroughAttribute(ICheckContext context, ShallowEntity caseEntity, ShallowEntity entityToCheck) {
        if (caseEntity == null || entityToCheck == null) {
            return false;
        }
        return SwitchStatementUtils.isCppFallthroughAttribute(entityToCheck) || SwitchStatementUtils.isGNUFallthroughAttribute(context, caseEntity, entityToCheck);
    }

    private static boolean isCppFallthroughAttribute(ShallowEntity entity) {
        return entity.getType() == EShallowEntityType.META && "attribute annotation".equals(entity.getSubtype()) && FALLTHROUGH_ATTRIBUTES.contains(entity.getName());
    }

    private static boolean isGNUFallthroughAttribute(ICheckContext context, ShallowEntity caseEntity, ShallowEntity entityToCheck) {
        if (!entityToCheck.getSubtype().equals("empty statement")) {
            return false;
        }
        UnmodifiableList<IToken> unprocessedTokens = null;
        try {
            unprocessedTokens = context.getTokens(ECodeViewOption.FILTERED_PREPROCESSED);
        }
        catch (CheckException e) {
            LOGGER.error("An exception occurred while determining if the entity represent a fallthrough attribute.", (Throwable)e);
        }
        if (unprocessedTokens == null || unprocessedTokens.size() <= caseEntity.getAllTokensOfFile().size()) {
            return false;
        }
        List<IToken> preprocessedCaseTokens = TokenStreamUtils.getTokensBetween(unprocessedTokens, caseEntity.getStartOffset(), entityToCheck.getEndOffset());
        return SwitchStatementUtils.hasGNUFallthroughAttribute(preprocessedCaseTokens);
    }

    private static boolean hasGNUFallthroughAttribute(List<IToken> tokens) {
        List<Integer> indices = TokenStreamUtils.firstTokenOfTypeSequences(tokens, 0, ETokenType.ATTRIBUTE, ETokenType.LPAREN, ETokenType.LPAREN, ETokenType.IDENTIFIER, ETokenType.RPAREN, ETokenType.RPAREN);
        if (indices.isEmpty()) {
            return false;
        }
        int index = (Integer)CollectionUtils.getLast(indices);
        return tokens.get(index + 3).getText().equals("fallthrough");
    }

    private SwitchStatementUtils() {
        throw new UtilsInstantiationNotSupportedException();
    }
}

