/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.util.clang;

import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.phase.ECodeViewOption;
import eu.cqse.check.framework.core.phase.ITokenElementContext;
import eu.cqse.clang.CXCursor;
import eu.cqse.clang.CXUnsavedFile;
import eu.cqse.clang.Clang;
import eu.cqse.clang.ClangJniLoader;
import eu.cqse.clang.SWIGTYPE_p_CXTranslationUnitImpl;
import eu.cqse.clang.SWIGTYPE_p_void;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.system.SystemUtils;

public class ClangTranslationUnitWrapper
implements AutoCloseable {
    private static final int PARSE_OPTION_INCOMPLETE = 2;
    private static final int PARSE_OPTION_KEEP_GOING = 512;
    private static final int PARSE_OPTION_SINGLE_FILE_PARSE = 1024;
    private static final String BITNESS_MISMATCH_ERROR_MESSAGE = "Can't load IA 32-bit";
    private static final Logger LOGGER = LogManager.getLogger();
    private SWIGTYPE_p_void clangIndex;
    private SWIGTYPE_p_CXTranslationUnitImpl mainTranslationUnit;

    private ClangTranslationUnitWrapper(SWIGTYPE_p_void clangIndex, SWIGTYPE_p_CXTranslationUnitImpl mainTranslationUnit) {
        this.clangIndex = clangIndex;
        this.mainTranslationUnit = mainTranslationUnit;
    }

    public SWIGTYPE_p_CXTranslationUnitImpl getMainTranslationUnit() {
        return this.mainTranslationUnit;
    }

    public static ClangTranslationUnitWrapper createForContext(ITokenElementContext context) throws ConQATException {
        String text = null;
        try {
            text = context.getTextContent(ECodeViewOption.ETextViewOption.FILTERED_CONTENT);
        }
        catch (CheckException e) {
            throw new ConQATException("Could not retrieve text content for clang initialization.", (Throwable)e);
        }
        return ClangTranslationUnitWrapper.createForText(context.getUniformPath(), text);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ClangTranslationUnitWrapper createForText(String uniformPath, String text) throws ConQATException {
        try {
            ClangJniLoader.ensureLoaded();
            SWIGTYPE_p_void clangIndex = Clang.clang_createIndex((int)0, (int)0);
            if (clangIndex == null) {
                CCSMAssert.fail((String)"Failed to create a clang index");
            }
            CXUnsavedFile file = ClangTranslationUnitWrapper.createUnsavedFile(uniformPath, text);
            try {
                int options = 1538;
                SWIGTYPE_p_CXTranslationUnitImpl translationUnit = Clang.clang_parseTranslationUnit((SWIGTYPE_p_void)clangIndex, (String)uniformPath, null, (int)0, (CXUnsavedFile[])new CXUnsavedFile[]{file}, (long)1L, (long)options);
                if (translationUnit != null) {
                    ClangTranslationUnitWrapper clangTranslationUnitWrapper = new ClangTranslationUnitWrapper(clangIndex, translationUnit);
                    return clangTranslationUnitWrapper;
                }
                Clang.clang_disposeIndex((SWIGTYPE_p_void)clangIndex);
                if (uniformPath.endsWith(".inc") || uniformPath.endsWith(".inl")) {
                    LOGGER.warn("Translation unit could not be created for file " + uniformPath);
                } else {
                    LOGGER.error("Translation unit could not be created for file " + uniformPath);
                }
                ClangTranslationUnitWrapper clangTranslationUnitWrapper = null;
                return clangTranslationUnitWrapper;
            }
            finally {
                file.delete();
            }
        }
        catch (UnsatisfiedLinkError e) {
            Object errorMessage = SystemUtils.getUnsatisfiedLinkageErrorMessage((String)"Clang");
            if (!e.getMessage().contains(BITNESS_MISMATCH_ERROR_MESSAGE)) throw new ConQATException((String)errorMessage, (Throwable)e);
            errorMessage = (String)errorMessage + "\nIn addition, ensure that you have installed a 64-bit version of Java if you're on a 64-bit system.";
            throw new ConQATException((String)errorMessage, (Throwable)e);
        }
    }

    private static CXUnsavedFile createUnsavedFile(String uniformPath, String text) {
        CXUnsavedFile file = new CXUnsavedFile();
        file.setFilename(uniformPath);
        file.setContents(text);
        file.setLength((long)text.length());
        return file;
    }

    @Override
    public void close() {
        this.dispose();
    }

    public void dispose() {
        if (this.mainTranslationUnit != null) {
            Clang.clang_disposeTranslationUnit((SWIGTYPE_p_CXTranslationUnitImpl)this.mainTranslationUnit);
            this.mainTranslationUnit = null;
        }
        if (this.clangIndex != null) {
            Clang.clang_disposeIndex((SWIGTYPE_p_void)this.clangIndex);
            this.clangIndex = null;
        }
    }

    public CXCursor getMainRootCursor() {
        return Clang.clang_getTranslationUnitCursor((SWIGTYPE_p_CXTranslationUnitImpl)this.getMainTranslationUnit());
    }
}

