/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.reportparser.parser;

import com.teamscale.reportparser.CoverageReportParserBase;
import com.teamscale.reportparser.parser.ReportParserException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.conqat.engine.sourcecode.coverage.CoverageInfoRetriever;
import org.conqat.engine.sourcecode.coverage.ELineCoverage;
import org.conqat.engine.sourcecode.coverage.LineCoverageInfo;
import org.conqat.lib.commons.string.StringUtils;

public class SimpleCoverageReportParser
extends CoverageReportParserBase {
    private static final Pattern LINE_PATTERN = Pattern.compile("^[0-9]+$");
    private static final Pattern LINE_RANGE_PATTERN = Pattern.compile("^([0-9]+)-([0-9]+)$");
    private static final Pattern METHOD_ACCURATE_ANNOTATION_PATTERN = Pattern.compile("^# isMethodAccurate\\s*=\\s*true$");
    private boolean isMethodAccurate = false;
    private LineCoverageInfo currentCoverage = null;

    @Override
    public void parseCoverageReport(String report, CoverageInfoRetriever retriever) throws ReportParserException {
        this.resetState();
        String[] lines = StringUtils.splitLines((String)report);
        for (int line = 0; line < lines.length; ++line) {
            String lineContent = lines[line].trim();
            if (StringUtils.isEmpty((String)lineContent)) continue;
            this.parseLine(retriever, line, lineContent);
        }
    }

    private void parseLine(CoverageInfoRetriever retriever, int reportLineNumber, String lineContent) {
        Matcher matcher = LINE_RANGE_PATTERN.matcher(lineContent);
        if (matcher.matches()) {
            int startLine = Integer.parseInt(matcher.group(1));
            int endLine = Integer.parseInt(matcher.group(2));
            this.addLineCoverage(reportLineNumber, lineContent, startLine, endLine);
        } else if (LINE_PATTERN.matcher(lineContent).matches()) {
            int lineNumber = Integer.parseInt(lineContent);
            this.addLineCoverage(reportLineNumber, lineContent, lineNumber, lineNumber);
        } else if (METHOD_ACCURATE_ANNOTATION_PATTERN.matcher(lineContent).matches()) {
            this.isMethodAccurate = true;
            for (LineCoverageInfo oldCoverage : retriever.getAllLineCoverage().values()) {
                oldCoverage.setMethodAccurate(true);
            }
        } else if (!SimpleCoverageReportParser.isComment(lineContent)) {
            this.currentCoverage = retriever.getOrCreateLineCoverageInfo(lineContent);
            this.currentCoverage.setMethodAccurate(this.isMethodAccurate);
        }
    }

    private void addLineCoverage(int reportLineNumber, String lineContent, int startLine, int endLine) {
        if (this.currentCoverage == null) {
            LOGGER.error("Found line number without preceding file path in line {}: {}. Ignoring this line", (Object)(reportLineNumber + 1), (Object)lineContent);
            return;
        }
        this.currentCoverage.addRangeCoverage(startLine, endLine, ELineCoverage.FULLY_COVERED);
    }

    private static boolean isComment(String lineContent) {
        return lineContent.startsWith("#");
    }

    private void resetState() {
        this.isMethodAccurate = false;
        this.currentCoverage = null;
    }
}

