/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.sourcecode.coverage;

import com.fasterxml.jackson.annotation.JsonAlias;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.IntStream;
import org.conqat.engine.sourcecode.coverage.ELineCoverage;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CompactLines;
import org.conqat.lib.commons.region.LineBasedRegion;
import org.conqat.lib.commons.test.IndexValueClass;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@IndexValueClass(containedInBackup=true)
public class LineCoverageInfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final long TIMESTAMP_UNDEFINED = -1L;
    public static final double DEFAULT_COVERAGE_FOR_EMPTY_COVERABLE_LINES = 1.0;
    private static final String IS_METHOD_ACCURATE_PROPERTY = "isMethodAccurate";
    @JsonProperty(value="fullyCoveredLines")
    @JsonAlias(value={"fully-covered-lines"})
    private final CompactLines fullyCoveredLines = new CompactLines();
    @JsonProperty(value="partiallyCoveredLines")
    @JsonAlias(value={"partially-covered-lines"})
    private final CompactLines partiallyCoveredLines = new CompactLines();
    @JsonProperty(value="uncoveredLines")
    @JsonAlias(value={"uncovered-lines"})
    private final CompactLines uncoveredLines = new CompactLines();
    @JsonProperty(value="isMethodAccurate")
    private boolean isMethodAccurate;
    @JsonIgnore
    private long uploadCommitTimestamp;
    @JsonIgnore
    private long codeCommitTimestamp;
    @JsonIgnore
    private @Nullable String branchName;

    public LineCoverageInfo(LineCoverageInfo lineCoverage) {
        this.uploadCommitTimestamp = lineCoverage.uploadCommitTimestamp;
        this.codeCommitTimestamp = lineCoverage.codeCommitTimestamp;
        this.branchName = lineCoverage.branchName;
        this.isMethodAccurate = lineCoverage.isMethodAccurate;
        this.fullyCoveredLines.addAll(lineCoverage.fullyCoveredLines);
        this.partiallyCoveredLines.addAll(lineCoverage.partiallyCoveredLines);
        this.uncoveredLines.addAll(lineCoverage.uncoveredLines);
    }

    @JsonCreator
    public LineCoverageInfo(@JsonProperty(value="isMethodAccurate") boolean isMethodAccurate) {
        this(-1L, -1L, isMethodAccurate);
    }

    public LineCoverageInfo(long uploadCommitTimestamp, long codeCommitTimestamp, boolean isMethodAccurate) {
        this.uploadCommitTimestamp = uploadCommitTimestamp;
        this.codeCommitTimestamp = codeCommitTimestamp;
        this.isMethodAccurate = isMethodAccurate;
    }

    public boolean isMethodAccurate() {
        return this.isMethodAccurate;
    }

    public void setMethodAccurate(boolean isMethodAccurate) {
        this.isMethodAccurate = isMethodAccurate;
    }

    public void addLineCoverage(int line, ELineCoverage coverage) {
        CCSMAssert.isNotNull((Object)((Object)coverage));
        if (!this.fullyCoveredLines.contains(line)) {
            if (this.partiallyCoveredLines.contains(line)) {
                if (coverage == ELineCoverage.FULLY_COVERED) {
                    this.partiallyCoveredLines.remove(line);
                    this.fullyCoveredLines.add(line);
                }
            } else {
                this.uncoveredLines.remove(line);
                this.setLineCoverage(line, coverage);
            }
        }
    }

    public void addLineCoverage(Collection<Integer> lines, ELineCoverage coverage) {
        this.addLineCoverage(new CompactLines(lines), coverage);
    }

    public void addLineCoverage(CompactLines lines, ELineCoverage coverage) {
        if (Objects.requireNonNull(coverage) == ELineCoverage.FULLY_COVERED) {
            this.fullyCoveredLines.addAll(lines);
            this.partiallyCoveredLines.removeAll(lines);
            this.uncoveredLines.removeAll(lines);
        } else if (coverage == ELineCoverage.PARTIALLY_COVERED) {
            this.partiallyCoveredLines.addAll(lines);
            this.partiallyCoveredLines.removeAll(this.fullyCoveredLines);
            this.uncoveredLines.removeAll(lines);
        } else {
            this.uncoveredLines.addAll(lines);
            this.uncoveredLines.removeAll(this.fullyCoveredLines);
            this.uncoveredLines.removeAll(this.partiallyCoveredLines);
        }
    }

    public void addRangeCoverage(int startLine, int endLine, ELineCoverage coverage) {
        for (int i = startLine; i <= endLine; ++i) {
            this.addLineCoverage(i, coverage);
        }
    }

    public void addLineCoverage(IntStream lines, ELineCoverage coverage) {
        lines.forEach(line -> this.addLineCoverage(line, coverage));
    }

    public void removeLineCoverageInfo(int line) {
        this.fullyCoveredLines.remove(line);
        this.partiallyCoveredLines.remove(line);
        this.uncoveredLines.remove(line);
    }

    private void setLineCoverage(int line, ELineCoverage coverage) {
        switch (coverage) {
            case FULLY_COVERED: {
                this.fullyCoveredLines.add(line);
                break;
            }
            case PARTIALLY_COVERED: {
                this.partiallyCoveredLines.add(line);
                break;
            }
            case NOT_COVERED: {
                this.uncoveredLines.add(line);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown line coverage: " + String.valueOf((Object)coverage));
            }
        }
    }

    public void addAll(LineCoverageInfo coverageInfo) {
        this.addLineCoverage(coverageInfo.fullyCoveredLines, ELineCoverage.FULLY_COVERED);
        this.addLineCoverage(coverageInfo.partiallyCoveredLines, ELineCoverage.PARTIALLY_COVERED);
        this.addLineCoverage(coverageInfo.uncoveredLines, ELineCoverage.NOT_COVERED);
    }

    public ELineCoverage getLineCoverage(int line) {
        if (this.fullyCoveredLines.contains(line)) {
            return ELineCoverage.FULLY_COVERED;
        }
        if (this.partiallyCoveredLines.contains(line)) {
            return ELineCoverage.PARTIALLY_COVERED;
        }
        if (this.uncoveredLines.contains(line)) {
            return ELineCoverage.NOT_COVERED;
        }
        return null;
    }

    public CompactLines getFullyCoveredLines() {
        return this.fullyCoveredLines;
    }

    public CompactLines getPartiallyCoveredLines() {
        return this.partiallyCoveredLines;
    }

    public CompactLines getUncoveredLines() {
        return this.uncoveredLines;
    }

    public CompactLines getCoveredLines() {
        CompactLines coveredLines = new CompactLines();
        coveredLines.addAll(this.partiallyCoveredLines);
        coveredLines.addAll(this.fullyCoveredLines);
        return coveredLines;
    }

    private double getCoverageRatio() {
        return LineCoverageInfo.calculateCoverageRatio(this.getCoveredLineCount(), this.getCoverableLines());
    }

    public static double calculateCoverageRatio(int coveredLines, int coverableLines) {
        Preconditions.checkArgument((coveredLines >= 0 ? 1 : 0) != 0, (String)"Negative covered lines: %d", (int)coveredLines);
        Preconditions.checkArgument((coverableLines >= 0 ? 1 : 0) != 0, (String)"Negative coverable lines: %d", (int)coverableLines);
        Preconditions.checkArgument((coverableLines >= coveredLines ? 1 : 0) != 0, (String)"Cannot have more covered lines (%s) than coverable lines (%s)", (int)coveredLines, (int)coverableLines);
        if (coverableLines == 0) {
            return 1.0;
        }
        return (double)coveredLines / (double)coverableLines;
    }

    public int getCoveredLineCount() {
        return this.fullyCoveredLines.size() + this.partiallyCoveredLines.size();
    }

    public int getCoverableLines() {
        return this.fullyCoveredLines.size() + this.partiallyCoveredLines.size() + this.uncoveredLines.size();
    }

    public CompactLines getAllCoverableLines() {
        CompactLines coverableLines = new CompactLines();
        coverableLines.addAll(this.fullyCoveredLines);
        coverableLines.addAll(this.partiallyCoveredLines);
        coverableLines.addAll(this.uncoveredLines);
        return coverableLines;
    }

    public int getHighestLineNumber() {
        return this.getAllCoverableLines().getHighestLineNumber().orElse(0);
    }

    public long getUploadCommitTimestamp() {
        return this.uploadCommitTimestamp;
    }

    public void setUploadCommitTimestamp(long uploadCommitTimestamp) {
        this.uploadCommitTimestamp = uploadCommitTimestamp;
    }

    public void setCodeCommitTimestamp(long codeCommitTimestamp) {
        this.codeCommitTimestamp = codeCommitTimestamp;
    }

    public long getCodeCommitTimestamp() {
        return this.codeCommitTimestamp;
    }

    public void setBranchName(@Nullable String branchName) {
        this.branchName = branchName;
    }

    public String toString() {
        return String.valueOf(this.getCoverageRatio());
    }

    public String toLineString() {
        String result = "Fully covered: " + String.valueOf(this.fullyCoveredLines) + "; partially covered: " + String.valueOf(this.partiallyCoveredLines) + "; uncovered: " + String.valueOf(this.uncoveredLines);
        if (this.uploadCommitTimestamp != this.codeCommitTimestamp && this.codeCommitTimestamp != 0L) {
            result = result + "; upload timestamp: " + this.uploadCommitTimestamp + "; code timestamp: " + this.codeCommitTimestamp;
        }
        return result;
    }

    public void clear() {
        this.fullyCoveredLines.clear();
        this.partiallyCoveredLines.clear();
        this.uncoveredLines.clear();
    }

    public void setCoverableLines(CompactLines lines) {
        this.fullyCoveredLines.retainAll(lines);
        this.partiallyCoveredLines.retainAll(lines);
        this.uncoveredLines.clear();
        this.uncoveredLines.addAll(lines);
        this.uncoveredLines.removeAll(this.fullyCoveredLines);
        this.uncoveredLines.removeAll(this.partiallyCoveredLines);
    }

    public LineCoverageInfo copyWithoutCommitTimestamps() {
        LineCoverageInfo copy = new LineCoverageInfo(this);
        copy.setUploadCommitTimestamp(-1L);
        copy.setCodeCommitTimestamp(-1L);
        return copy;
    }

    public void extendCoverageToStatements(List<LineBasedRegion> multiLineRegions) {
        for (LineBasedRegion region : multiLineRegions) {
            int startLine = region.getStart();
            int endLine = region.getEnd();
            if (IntStream.range(startLine, endLine + 1).anyMatch(arg_0 -> ((CompactLines)this.fullyCoveredLines).contains(arg_0))) {
                IntStream.range(startLine, endLine + 1).forEach(arg_0 -> ((CompactLines)this.fullyCoveredLines).add(arg_0));
                IntStream.range(startLine, endLine + 1).forEach(arg_0 -> ((CompactLines)this.partiallyCoveredLines).remove(arg_0));
                IntStream.range(startLine, endLine + 1).forEach(arg_0 -> ((CompactLines)this.uncoveredLines).remove(arg_0));
                continue;
            }
            if (!IntStream.range(startLine, endLine + 1).anyMatch(arg_0 -> ((CompactLines)this.partiallyCoveredLines).contains(arg_0))) continue;
            IntStream.range(startLine, endLine + 1).forEach(arg_0 -> ((CompactLines)this.partiallyCoveredLines).add(arg_0));
            IntStream.range(startLine, endLine + 1).forEach(arg_0 -> ((CompactLines)this.uncoveredLines).remove(arg_0));
        }
    }

    public long getEstimatedSizeBytes() {
        return 60L + (long)(this.fullyCoveredLines.size() + this.partiallyCoveredLines.size() + this.uncoveredLines.size()) * 32L;
    }

    public static LineCoverageInfo merge(LineCoverageInfo existingInfo, @Nullable LineCoverageInfo infoToAdd) {
        if (infoToAdd == null) {
            return existingInfo;
        }
        if (existingInfo.branchName == null) {
            return infoToAdd;
        }
        CCSMAssert.isTrue((infoToAdd.branchName != null ? 1 : 0) != 0, (String)"The branch name of the info to add must be set.");
        if (!infoToAdd.branchName.equals(existingInfo.branchName)) {
            return infoToAdd;
        }
        CCSMAssert.isTrue((existingInfo.codeCommitTimestamp <= infoToAdd.codeCommitTimestamp ? 1 : 0) != 0, (String)"`infoToAdd` must be more recent that those already processed (`existingInfo`).");
        if (existingInfo.codeCommitTimestamp == -1L ? existingInfo.uploadCommitTimestamp != infoToAdd.uploadCommitTimestamp : existingInfo.codeCommitTimestamp != infoToAdd.codeCommitTimestamp) {
            return infoToAdd;
        }
        return LineCoverageInfo.mergeInfos(existingInfo, infoToAdd);
    }

    public static @NonNull LineCoverageInfo mergeInfos(@NonNull LineCoverageInfo infoA, @NonNull LineCoverageInfo infoB) {
        LineCoverageInfo result = new LineCoverageInfo(infoA);
        result.setUploadCommitTimestamp(Math.max(infoA.uploadCommitTimestamp, infoB.uploadCommitTimestamp));
        result.setMethodAccurate(infoA.isMethodAccurate || infoB.isMethodAccurate);
        result.addLineCoverage(infoB.fullyCoveredLines, ELineCoverage.FULLY_COVERED);
        result.addLineCoverage(infoB.partiallyCoveredLines, ELineCoverage.PARTIALLY_COVERED);
        result.partiallyCoveredLines.removeAll(result.fullyCoveredLines);
        result.addLineCoverage(infoB.uncoveredLines, ELineCoverage.NOT_COVERED);
        result.uncoveredLines.removeAll(result.fullyCoveredLines);
        result.uncoveredLines.removeAll(result.partiallyCoveredLines);
        return result;
    }

    public static boolean isUndefinedTimestamp(long timestamp) {
        return timestamp == -1L;
    }
}

