

System functions should not be used since they allow to execute any command in the operating system.

# What Does This Check Look For?

This check searches for the internal statement `CALL cfunc` which executes a system function.
There are two options for this check in your analysis profile:

If you activate `Suspicious usage of CALL system function - Use as Whitelist`
every system function that is **not** listed in `Suspicious usage of CALL system function - System function names`
will get flagged from this check. 

Or else if you deactivate `Suspicious usage of CALL system function - Use as Whitelist`
every System function that is listed **in** `Suspicious usage of CALL system function - System function names`
will get flagged but every other system function will **not** get flagged.

If left empty, only the `SYSTEM` and `ThWpInfo`function will be in `Suspicious usage of CALL system function - System function names`.

If the function `SYSTEM` is getting flagged by your settings you can deactivate that flag and allow a 
`SYSTEM` call for all **commands** listed in `Suspicious usage of CALL system function - Allowed commands in CALL 'SYSTEM'`.
# Why is This a Problem?
Some system functions, e.g. `SYSTEM` or `ThWpInfo` allow to execute any command of the operating system and shuld be avoided.


# How Can I Resolve This?

Instead of using system functions the [SXPG framework]((https://help.sap.com/abapdocu_750/en/abenabap_system_commands_appl_sxpg.htm)) should be used
instead.



