Class names ending with "Exception" should logically inherit from `Exception` or one of its subclasses to avoid confusion.
Ensure that any class named with an "Exception" suffix extends `Exception` or a subclass of `Exception`.

# What Does This Check Look For?

This check identifies classes whose names end with *Exception* but do not inherit from `Exception` or any of its subclasses. To avoid false positives, no finding will be created if the name of the parent class contains the term *Exception*.

# Why is This a Problem?

Using the suffix *Exception* in a class name implies it is used for error handling and should follow the convention of inheriting from the `Exception` class. When such a class does not inherit from `Exception` or its subclasses, it can lead to confusion and misuse in error handling mechanisms, potentially affecting the comprehensibility and maintainability of the code.

# How Can I Resolve This?

Ensure that any class with a name ending in *Exception* extends `Exception` or a subclass thereof. This alignment with naming conventions aids in the correct usage and expectations surrounding these classes.

# Examples

## Non-Compliant

```java
class SomeException { } // unexpected, not inheriting from java.lang.Exception or subclass
class OtherException extends Foo { } // unexpected, apparently no exception-related parent class
```

## Compliant

```java
class SomeException extends Exception { }
class OtherException extends SomeParentException { } 
```
