This check detects variable assignments to the empty string `''`.

# Why is This a Problem?
The empty string in PL/SQL implicitly refers the `NULL` value.
Hence, handling the assigned character-type variable like a string could result in errors and reduces the understandability and maintainability of the code.

# How Can I Resolve This?
Instead of implicitly assigning `NULL` with an empty string, you should explicitly assign `NULL` to avoid irritations.

## Example (Before)

```oraclesqlplus
someVar CHAR(10) := '';
```

## Example (After)

```oraclesqlplus
someVar CHAR(10) := NULL;
```