# Why is This a Problem?

Literal values embedded directly in the code can make it difficult to understand the purpose or meaning of the value. 
They lack context and can be prone to errors if changes are not consistent throughout the codebase. 

# How Can I Resolve This?

Add a declaration for the literal value. 
This helps improve code comprehensibility and maintainability as the values can be easily referenced and modified in a central location. 

# Examples

## Non-Compliant

```java
int maxRetries = 3;     // non-compliant: literal value embedded in the code
```

## Compliant

```java
int maxRetries = Constants.MAX_RETRIES;     // compliant: literal value referenced from a separate literal-definition file
```

# Where Can I Learn More?

- [Wikipedia: Magic numbers](https://en.wikipedia.org/wiki/Magic_number_(programming))
