Building HTML through string concatenation can lead to security issues, and code that is hard to read and maintain.
Consider using a templating engine or framework with built-in HTML rendering capabilities.

# What Does This Check Look For?

This check flags instances where HTML code is constructed within string literals.

# Why is This a Problem?

Building HTML within Strings compromises code readability and maintainability. It makes the code prone to errors and harder to modify, as HTML structures become intertwined with programming logic. Additionally, this practice increases the risk of introducing security vulnerabilities, such as Cross-Site Scripting (XSS), due to improper handling of user input.

# How Can I Resolve This?

Consider using a template engine or a front-end framework that supports HTML templates. These tools allow for a clean separation of concerns, making the code more readable and maintainable. They also often provide built-in mechanisms for safely handling user input, reducing the risk of security vulnerabilities.

# Examples

## Non-Compliant
```java
String html = "<div id='" + divId + "'>" + "<h1>" + title + "</h1>" + "</div>";
```

## Compliant

Using a template engine, e.g. [Thymeleaf](https://www.thymeleaf.org/)
```thymeleaftemplatesexpressions
<div th:id="#{divId}"><h1 th:text="#{title}">The title</h1></div>
```
See [Thymeleaf documentation](https://www.thymeleaf.org/documentation.html) for how to integrate the template engine.

# Where Can I Learn More?

- [Cross Site Scripting (XSS) - OWASP](https://owasp.org/www-community/attacks/xss/)