# Description
Detects `EXPORTING` statements which can be omitted.

# Extended Information
https://github.com/SAP/styleguides/blob/main/clean-abap/CleanABAP.md#omit-the-optional-keyword-exporting
https://docs.abapopenchecks.org/checks/30/

# Examples
**Bad example**
```abap
call_method( EXPORTING foo = bar ).
```

**Good example**
```abap
call_method( foo = bar ).
```

# Clean ABAP Code Style Guide
```ABAP
modify->update( node           = /clean/my_bo_c=>node-item
                key            = item->key
                data           = item
                changed_fields = changed_fields ).
```

instead of the needlessly longer

```ABAP
" anti-pattern
modify->update(
  EXPORTING
    node           = /dirty/my_bo_c=>node-item
    key            = item->key
    data           = item
    changed_fields = changed_fields ).
```

---
For more information visit the [official ABAPLint rule documentation](https://rules.abaplint.org/exporting) <br>
The contents within section `Clean ABAP Code Style Guide` were copied from the [official SAP Code Style Guides repository](https://github.com/SAP/styleguides/).
