[Accessibility] Ensures that a label element/component is associated with a form element

- Type: suggestion

<br>

## Usage Examples

> The following examples are generated automatically from the actual unit tests within the plugin, so you can be assured that their behavior is accurate based on the current commit.

<br>

<details>
<summary>❌ - Toggle examples of <strong>incorrect</strong> code for this rule</summary>

<br>

#### ❌ Invalid Code

```html
<label>Label</label>
~~~~~~~~~~~~~~~~~~~~
```

<br>

---

<br>

#### ❌ Invalid Code

```html
<app-label anotherAttribute="id"></app-label>
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
```

</details>

<br>

---

<br>

<details>
<summary>✅ - Toggle examples of <strong>correct</strong> code for this rule</summary>

<br>

#### ✅ Valid Code

```html
<ng-container *ngFor="let item of items; index as index">
  <label for="item-{{index}}">Label #{{index}</label>
  <input id="item-{{index}}" [(ngModel)]="item.name">
</ng-container>
<label for="id"></label>
<label for="{{id}}"></label>
<label [attr.for]="id"></label>
<label [htmlFor]="id"></label>
```

<br>

---

<br>

#### ✅ Valid Code

```html
<app-label id="name"></app-label>
<app-label id="{{name}}"></app-label>
<app-label [id]="name"></app-label>
<label [htmlFor]="id"></label>
```

<br>

---

<br>

#### ✅ Valid Code

```html
<label><input type="radio"></label>
<label><meter></meter></label>
<label><output></output></label>
<label><progress></progress></label>
<label><select><option>1</option></select></label>
<label><textarea></textarea></label>
<a-label><input></a-label>
<label>
  Label
  <input>
</label>
<label>
  Label
  <span><input></span>
</label>
<app-label>
  <span>
    <app-input></app-input>
  </span>
</app-label>
```

</details>
