<h2>Why is this an issue?</h2>
<p>This rule applies whenever an <code>if</code> statement is followed by one or more <code>else if</code> statements; the final <code>else if</code>
should be followed by an <code>else</code> statement.</p>
<p>The requirement for a final <code>else</code> statement is defensive programming.</p>
<p>The <code>else</code> statement should either take appropriate action or contain a suitable comment as to why no action is taken. This is
consistent with the requirement to have a final <code>default</code> clause in a <code>switch</code> statement.</p>
<h3>Noncompliant code example</h3>
<pre>
if (x == 0)
{
    DoSomething();
}
else if (x == 1)
{
    DoSomethingElse();
}
</pre>
<h3>Compliant solution</h3>
<pre>
if (x == 0)
{
    DoSomething();
}
else if (x == 1)
{
    DoSomethingElse();
}
else
{
    throw new InvalidOperationException();
}
</pre>
<h3>Exceptions</h3>
<p>None</p>

