<h2>Why is this an issue?</h2>
<p>It is possible in an <code>IDisposable</code> to call <code>Dispose</code> on class members from any method, but the contract of
<code>Dispose</code> is that it will clean up all unmanaged resources. Move disposing of members to some other method, and you risk resource
leaks.</p>
<p>This rule also applies for disposable ref structs.</p>
<h3>Noncompliant code example</h3>
<pre>
public class ResourceHolder : IDisposable
{
  private FileStream fs;
  public void OpenResource(string path)
  {
    this.fs = new FileStream(path, FileMode.Open);
  }
  public void CloseResource()
  {
    this.fs.Close();
  }

  public void CleanUp()
  {
    this.fs.Dispose(); // Noncompliant; Dispose not called in class' Dispose method
  }

  public void Dispose()
  {
    // method added to satisfy demands of interface
  }
}
</pre>
<h3>Compliant solution</h3>
<pre>
public class ResourceHolder : IDisposable
{
  private FileStream fs;
  public void OpenResource(string path)
  {
    this.fs = new FileStream(path, FileMode.Open);
  }
  public void CloseResource()
  {
    this.fs.Close();
  }

  public void Dispose()
  {
    this.fs.Dispose();
  }
}
</pre>
<h2>Resources</h2>
<ul>
  <li> CWE - <a href="https://cwe.mitre.org/data/definitions/459">CWE-459 - Incomplete Cleanup</a> </li>
</ul>

