<h2>Why is this an issue?</h2>
<p>The <a href="https://learn.microsoft.com/en-us/dotnet/csharp/language-reference/statements/iteration-statements#the-foreach-statement">foreach</a>
statement was introduced in the C# language prior to generics to make it easier to work with the non-generic collections available at that time such
as <a href="https://learn.microsoft.com/en-us/dotnet/api/system.collections.arraylist">ArrayList</a>. The <code>foreach</code> statements allow you to
downcast elements of a collection of <a href="https://learn.microsoft.com/en-us/dotnet/api/system.object">Objects</a> to any other type.</p>
<p>The problem is that to achieve the cast, the <code>foreach</code> statements silently perform <a
href="https://learn.microsoft.com/en-us/dotnet/csharp/programming-guide/types/casting-and-type-conversions#explicit-conversions">explicit type
conversion</a>, which at runtime can result in an <a
href="https://learn.microsoft.com/en-us/dotnet/api/system.invalidcastexception">InvalidCastException</a>.</p>
<p>C# code iterating on generic collections or arrays should not rely on <code>foreach</code> statement’s silent <code>explicit</code>
conversions.</p>
<pre data-diff-id="1" data-diff-type="noncompliant">
public class Fruit { }
public class Orange : Fruit { }
public class Apple : Fruit { }

class MyTest
{
  public void Test()
  {
    var fruitBasket = new List&lt;Fruit&gt;();
    fruitBasket.Add(new Orange());
    fruitBasket.Add(new Orange());
    fruitBasket.Add(new Apple());

    foreach (Orange orange in fruitBasket) // Noncompliant
    {
      //...
    }
  }
}
</pre>
<pre data-diff-id="1" data-diff-type="compliant">
public class Fruit { }
public class Orange : Fruit { }
public class Apple : Fruit { }

class MyTest
{
  public void Test()
  {
    var fruitBasket = new List&lt;Fruit&gt;();
    fruitBasket.Add(new Orange());
    fruitBasket.Add(new Orange());
    fruitBasket.Add(new Apple());

    foreach (Orange orange in fruitBasket.OfType&lt;Orange&gt;())
    {
      //...
    }
  }
}
</pre>
<h3>Exceptions</h3>
<p>The rule ignores iterations on collections of <code>objects</code>. This includes legacy code that uses <code>ArrayList</code>. Furthermore, the
rule does not report on cases when user-defined conversions are being called.</p>
<h2>Resources</h2>
<h3>Documentation</h3>
<ul>
  <li> <a href="https://learn.microsoft.com/en-us/dotnet/csharp/language-reference/statements/iteration-statements#the-foreach-statement">Foreach
  statement</a> </li>
  <li> <a href="https://learn.microsoft.com/en-us/dotnet/api/system.collections.arraylist">ArrayList</a> </li>
  <li> <a href="https://learn.microsoft.com/en-us/dotnet/api/system.object">Object class</a> </li>
  <li> <a href="https://learn.microsoft.com/en-us/dotnet/csharp/programming-guide/types/casting-and-type-conversions#explicit-conversions">Explicit
  conversion</a> </li>
  <li> <a href="https://learn.microsoft.com/en-us/dotnet/api/system.invalidcastexception">InvalidCastException</a> </li>
</ul>

