﻿## SA1627

<table>
<tr>
  <td>TypeName</td>
  <td>SA1627DocumentationTextMustNotBeEmpty</td>
</tr>
<tr>
  <td>CheckId</td>
  <td>SA1627</td>
</tr>
<tr>
  <td>Category</td>
  <td>Documentation Rules</td>
</tr>
</table>

## Cause

The Xml header documentation for a C# code element contains an empty tag.

## Rule description

C# syntax provides a mechanism for inserting documentation for classes and elements directly into the code, through the use of Xml documentation headers. For an introduction to these headers and a description of the header syntax, see the following article: [https://docs.microsoft.com/en-us/dotnet/csharp/programming-guide/xmldoc/xml-documentation-comments](https://docs.microsoft.com/en-us/dotnet/csharp/programming-guide/xmldoc/xml-documentation-comments).

A violation of this rule occurs when the documentation header for an element contains an empty tag. For example:

```csharp
/// <summary>
/// Joins a first name and a last name together into a single string.
/// </summary>
/// <remarks></remarks>
/// <param name="firstName">Other part of name.</param>
/// <param name="lastName">Part of the name.</param>
/// <returns>The joined names.</returns>
public string JoinNames(string firstName, string lastName)
{
    ...
}
```

## How to fix violations

To fix a violation of this rule, add documentation text within the empty tag.



## How to suppress violations

```csharp
[SuppressMessage("StyleCop.CSharp.DocumentationRules", "SA1627:DocumentationTextMustNotBeEmpty", Justification = "Reviewed.")]
```

```csharp
#pragma warning disable SA1627 // DocumentationTextMustNotBeEmpty
#pragma warning restore SA1627 // DocumentationTextMustNotBeEmpty
```
