﻿## SA1630

<table>
<tr>
  <td>TypeName</td>
  <td>SA1630DocumentationTextMustContainWhitespace</td>
</tr>
<tr>
  <td>CheckId</td>
  <td>SA1630</td>
</tr>
<tr>
  <td>Category</td>
  <td>Documentation Rules</td>
</tr>
</table>

:warning: This rule has been intentionally omitted from StyleCop Analyzers. See [KnownChanges.md](KnownChanges.md) for
additional information.

## Cause

A section of the Xml header documentation for a C# element does not contain any whitespace between words.

## Rule description

C# syntax provides a mechanism for inserting documentation for classes and elements directly into the code, through the use of Xml documentation headers. For an introduction to these headers and a description of the header syntax, see the following article: [https://docs.microsoft.com/en-us/dotnet/csharp/programming-guide/xmldoc/xml-documentation-comments](https://docs.microsoft.com/en-us/dotnet/csharp/programming-guide/xmldoc/xml-documentation-comments).

A violation of this rule occurs when part of the documentation does contain any whitespace between words. This can indicate poorly written or poorly formatted documentation. For example:

```csharp
/// <summary>
/// Joinsnames
/// </summary>
/// <param name="firstName">First</param>
/// <param name="lastName">Last</param>
/// <returns>Name</returns>
public string JoinNames(string firstName, string lastName)
{
    ...
}
```

## How to fix violations

To fix a violation of this rule, ensure that all sections of the documentation contain at least one instance of whitespace between words.

## How to suppress violations

```csharp
[SuppressMessage("StyleCop.CSharp.DocumentationRules", "SA1630:DocumentationTextMustContainWhitespace", Justification = "Reviewed.")]
```

```csharp
#pragma warning disable SA1630 // DocumentationTextMustContainWhitespace
#pragma warning restore SA1630 // DocumentationTextMustContainWhitespace
```
