<h2>Why is this an issue?</h2>
<p>While you can use either <code>forEach(list::add)</code> or <code>collect</code> with a <code>Stream</code>, <code>collect</code> is by far the
better choice because it’s automatically thread-safe and parallellizable.</p>
<h3>Noncompliant code example</h3>

```java
List<String> bookNames = new ArrayList<>();
books.stream().filter(book -> book.getIsbn().startsWith("0"))
                .map(Book::getTitle)
                .forEach(bookNames::add);  // Noncompliant
```
<h3>Compliant solution</h3>

```java
List<String> bookNames = books.stream().filter(book -> book.getIsbn().startsWith("0"))
                .map(Book::getTitle)
                .collect(Collectors.toList());
```