<h2>Why is this an issue?</h2>
<p>Unreachable code is the code whose statements cannot be executed under any circumstances. Jump statements, like <code>return</code>,
<code>break</code>, <code>continue</code>, and <code>throw</code>, alter the normal flow of control within a program, making it possible to skip
certain parts of the code, terminate loops prematurely, or exit from functions. So any statements that come after a jump are effectively
unreachable.</p>
<p>Unreachable statements can be a sign of a logical error or oversight in the program’s design, leading to unexpected behavior at runtime.</p>

```js
function func(a) {
  let i = 10;
  return i + a;
  i++; // Noncompliant: this is never executed
}
```
<p>Identify and remove unreachable statements from your code.</p>

```js
function func(a) {
  let i = 10;
  return i + a;
}
```
<h2>Resources</h2>
<h3>Documentation</h3>
<ul>
  <li> MDN web docs - <a href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Statements/return"><code>return</code></a> </li>
  <li> MDN web docs - <a href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Statements/break"><code>break</code></a> </li>
  <li> MDN web docs - <a href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Statements/throw"><code>throw</code></a> </li>
  <li> MDN web docs - <a href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Statements/continue"><code>continue</code></a> </li>
  <li> MDN web docs - <a href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Errors/Stmt_after_return">Warning: unreachable code
  after return statement</a> </li>
</ul>