<h2>Why is this an issue?</h2>
<p>A test case without assertions ensures only that no exceptions are thrown. Beyond basic runnability, it ensures nothing about the behavior of the
code under test.</p>
<p>This rule raised an issue when no assertions are found within a PHPUnit test method.</p>
<h3>Noncompliant code example</h3>

```php
public function testDoSomething() {  // Compliant
  $myClass = new MyClass();
  $myClass->getSomething();
}
```
<h3>Compliant solution</h3>

```php
public function testDoSomething() {  // Noncompliant
  $myClass = new MyClass();
  $this->assertEquals("foo", $myClass->getSomething());
}
```