<h2>Why is this an issue?</h2>
<p><code>goto</code> is an unstructured control flow statement. It makes code less readable and maintainable. Structured control flow statements such
as <code>if</code>, <code>for</code>, <code>while</code>, <code>continue</code> or <code>break</code> should be used instead.</p>
<h3>Noncompliant code example</h3>

```php
$i = 0;
loop:
  echo("i = $i");
  $i++;
  if ($i < 10){
    goto loop;
  }
```
<h3>Compliant solution</h3>

```php
for ($i = 0; $i < 10; $i++){
  echo("i = $i");
}
```