<p>Non-interactive HTML elements, such as <code>&lt;div&gt;</code> and <code>&lt;span&gt;</code>, are not designed to have event handlers. When these
elements are given event handlers, it can lead to accessibility issues.</p>
<h2>Why is this an issue?</h2>
<p>Attaching event handlers to non-interactive HTML elements can lead to significant accessibility issues. These elements, such as
<code>&lt;div&gt;</code> and <code>&lt;span&gt;</code>, are not designed to interact with assistive technologies like screen readers, making it
difficult for users with disabilities to navigate and interact with the website. Additionally, these elements may not be focusable or provide visual
feedback when interacted with, resulting in a confusing and potentially frustrating user experience. Therefore, to maintain an accessible and
user-friendly website, event handlers should be used exclusively with interactive elements.</p>
<p>The rule only considers the handlers <code>onClick</code>, <code>onMouseDown</code>, <code>onMouseUp</code>, <code>onKeyPress</code>,
<code>onKeyDown</code>, and <code>onKeyUp</code>.</p>
<h2>How to fix it</h2>
<p>To fix this issue, remove the event handler from the non-interactive element and attach it to an interactive element instead. If the element is not
interactive, it should not have an event handler.</p>
<h3>Code examples</h3>
<h4>Noncompliant code example</h4>

```ts
<li onClick={() => void 0} />
<div onClick={() => void 0} role="listitem" />
```
<h4>Compliant solution</h4>

```ts
<div onClick={() => void 0} role="button" />
<div onClick={() => void 0} role="presentation" />
<input type="text" onClick={() => void 0} /> // Interactive element does not require role.
<button onClick={() => void 0} className="foo" /> // button is interactive.
<div onClick={() => void 0} role="button" aria-hidden /> // This is hidden from the screenreader.
```
<h2>Resources</h2>
<h3>Documentation</h3>
<ul>
  <li> WCAG - <a href="https://www.w3.org/TR/wai-aria-practices-1.1/#aria_ex">WAI-ARIA Authoring Practices Guide - Design Patterns and Widgets</a>
  </li>
  <li> MDN - <a href="https://developer.mozilla.org/en-US/docs/Web/Accessibility/ARIA/ARIA_Techniques/Using_the_button_role#Keyboard_and_focus">ARIA
  Techniques</a> </li>
</ul>