# Prefer Self Type Over Type of Self

Prefer `Self` over `type(of: self)` when accessing properties or calling methods.

* **Identifier:** prefer_self_type_over_type_of_self
* **Supports autocorrection:** Yes
* **Kind:** style
* **Analyzer rule:** No
* **Minimum Swift compiler version:** 5.1.0
* **Default configuration:** warning

## Non Triggering Examples

```swift
class Foo {
    func bar() {
        Self.baz()
    }
}
```

```swift
class Foo {
    func bar() {
        print(Self.baz)
    }
}
```

```swift
class A {
    func foo(param: B) {
        type(of: param).bar()
    }
}
```

```swift
class A {
    func foo() {
        print(type(of: self))
    }
}
```

## Triggering Examples

```swift
class Foo {
    func bar() {
        ↓type(of: self).baz()
    }
}
```

```swift
class Foo {
    func bar() {
        print(↓type(of: self).baz)
    }
}
```

```swift
class Foo {
    func bar() {
        print(↓Swift.type(of: self).baz)
    }
}
```