import{_ as o,c as i,ak as n,o as s}from"./chunks/framework.D4LivsWb.js";const h=JSON.parse('{"title":"Improving Analysis Results for Simulink","description":"","frontmatter":{"title":"Improving Analysis Results for Simulink"},"headers":[],"relativePath":"howto/improving-analysis-results-for-simulink/index.md","filePath":"howto/improving-analysis-results-for-simulink/index.md"}'),a={name:"howto/improving-analysis-results-for-simulink/index.md"};function t(l,e,r,c,d,m){return s(),i("div",null,[...e[0]||(e[0]=[n('<h1 id="how-to-improve-analysis-results-for-simulink" tabindex="-1">How to Improve Analysis Results for Simulink <a class="header-anchor" href="#how-to-improve-analysis-results-for-simulink" aria-label="Permalink to &quot;How to Improve Analysis Results for Simulink&quot;">​</a></h1><p>The storage format of <code>.slx</code> models differs from what users see when they open the models in the Matlab IDE. Also, Simulink models sometimes refer to non-model files which are relevant for the analysis.</p><p>Due to these ideosyncracies, there&#39;s some common pitfalls that new users of Teamscale have to be aware of when configuring a Simulink project. This article describes how you avoid those pitfalls.</p><nav class="table-of-contents"><ul><li><a href="#analyzing-all-relevant-files">Analyzing all Relevant Files</a></li><li><a href="#configuring-block-types-in-simulink-analyses">Configuring Block Types in Simulink Analyses</a><ul><li><a href="#configuring-source-types-of-reference-blocks">Configuring Source Types of Reference Blocks</a></li></ul></li></ul></nav><h2 id="analyzing-all-relevant-files" tabindex="-1">Analyzing all Relevant Files <a class="header-anchor" href="#analyzing-all-relevant-files" aria-label="Permalink to &quot;Analyzing all Relevant Files&quot;">​</a></h2><p>The Simulink analyses implemented in Teamscale mainly focus on Simulink models (<code>.slx</code> files). However, Simulink models can refer to other files like Data Dictionaries (<code>.sldd</code> files). Also, Simulink project often contain MATLAB source-code files (<code>.m</code>).</p><p>To ensure that Teamscale has access to these files, make sure that they are matched by the <code>Included file names</code> option value in your project&#39;s connector configuration. An example option value would be <code>**.mdl, **.slx, **.sldd, *.m</code> (<code>.mdl</code> is an old format for storing Simulink models and was deprecated in 2012).</p><p>If you include MATLAB source files (<code>.m</code>), please also enable the language <code>Matlab</code> in your analysis profile.</p><h2 id="configuring-block-types-in-simulink-analyses" tabindex="-1">Configuring Block Types in Simulink Analyses <a class="header-anchor" href="#configuring-block-types-in-simulink-analyses" aria-label="Permalink to &quot;Configuring Block Types in Simulink Analyses&quot;">​</a></h2><p>The Simulink analysis in Teamscale is exclusively based on the information encoded in the analyzed files (<code>.slx</code>, <code>.sldd</code>). For some Simulink block types, this information deviates from the information shown in the MATLAB UI (e.g., block-type names). To configure Simulink analyses correctly, you have to use the block-type names encoded in the <code>.slx</code> files, not the MATLAB-UI names.</p><p>For example, our analysis <em>Prohibited Simulink standard blocks inside controllers</em> reports blocks of certain types if they are used in Simulink models. The block types that will be reported can be configured with the analysis-profile option <em>prohibited block types</em>, which accepts a list of block-type names and already contains a useful default list. The block-type names that are given in this option are matched against the &quot;internal&quot; block-types given in the <code>.slx</code> files, not against the &quot;UI&quot; block names shown in the MATLAB IDE.</p><p>For example, the block of (internal) type <code>Sum</code> are sometimes shown as <code>Add</code> type in MATLAB. Similarly, the internal type <code>MultiPortSwitch</code> may be shown as <code>Index Vector</code> and <code>DataStoreWrite</code> is shown as <code>Data Store Write</code>. To determine the internal type name for a given block, you can consult the MATLAB documentation consult the <a href="https://de.mathworks.com/help/simulink/slref/block-specific-parameters.html" target="_blank" rel="noreferrer">MATLAB documentation</a>. This documentation page contains the UI names and the corresponding internal names in parentheses (e.g., <code>Zero-Pole (ZeroPole)</code>) for many standard block types.</p><h3 id="configuring-source-types-of-reference-blocks" tabindex="-1">Configuring Source Types of Reference Blocks <a class="header-anchor" href="#configuring-source-types-of-reference-blocks" aria-label="Permalink to &quot;Configuring Source Types of Reference Blocks&quot;">​</a></h3><p>Some block types offered in the Simulink library browser are actually links to Subsystems implemented in the Simulink standard library. For example, the block type <code>Transfer Fcn First Order</code> is implemented in <code>simulink/Discrete/Transfer Fcn First Order</code>. When you instantiate this block in a model, MATLAB actually adds a block of type <code>Reference</code> which has a property <code>SourceType</code> with value <code>First Order Transfer Fcn</code>.</p><p>Several Teamscale analysis options allow to specify such source types in addition to normal block types (this is documented in the corresponding option descriptions). For example, the option <em>Visually clear block types</em> of our check <em>Check the display attributes of block names</em> lists the <code>Compare To Zero</code> source type (in the default configuration). When the analysis encounters a block of type <code>Reference</code> it tries to match the block&#39;s <code>SourceType</code> property against the listed types (instead of the string <code>Reference</code>).</p>',15)])])}const p=o(a,[["render",t]]);export{h as __pageData,p as default};
