import{_ as a,c as i,ak as t,o as s}from"./chunks/framework.D4LivsWb.js";const p=JSON.parse('{"title":"Integrating with Other IDEs","description":"","frontmatter":{"title":"Integrating with Other IDEs"},"headers":[],"relativePath":"howto/integrating-with-your-ide/other-ides/index.md","filePath":"howto/integrating-with-your-ide/other-ides/index.md"}'),o={name:"howto/integrating-with-your-ide/other-ides/index.md"};function l(n,e,r,c,d,h){return s(),i("div",null,[...e[0]||(e[0]=[t(`<h1 id="teamscale-integration-for-other-ides-and-editors" tabindex="-1">Teamscale Integration for Other IDEs and Editors <a class="header-anchor" href="#teamscale-integration-for-other-ides-and-editors" aria-label="Permalink to &quot;Teamscale Integration for Other IDEs and Editors&quot;">​</a></h1><p>By using a small <a href="./../../../reference/cli/teamscale-dev/">command-line client for developers (<code>teamscale-dev</code>)</a> Teamscale can be integrated into other IDEs or editors for which no dedicated plug-in exists. This makes it possible to use Teamscale, for example, from within <a href="./../visual-studio-code/">Visual Studio Code</a> or <a href="#sublime-text">Sublime Text</a>.</p><nav class="table-of-contents"><ul><li><a href="#installing-teamscale-dev">Installing teamscale-dev</a><ul><li><a href="#linux-macos">Linux/macOS</a></li><li><a href="#windows">Windows</a></li></ul></li><li><a href="#configuring-your-projects-using-teamscale-toml-files">Configuring Your Projects Using .teamscale.toml Files</a></li><li><a href="#invoking-teamscale-dev-from-different-ides-or-editors">Invoking teamscale-dev from Different IDEs or Editors</a><ul><li><a href="#sublime-text">Sublime Text</a></li><li><a href="#vim-neovim">Vim/NeoVim</a></li><li><a href="#xcode">XCode</a></li></ul></li></ul></nav><div class="tip custom-block"><p class="custom-block-title">License Information</p><p>The <code>teamscale-dev</code> tool is licensed under the <a href="https://www.apache.org/licenses/LICENSE-2.0" target="_blank" rel="noreferrer">Apache 2.0 License</a>. See the <a href="./../../../reference/cli/teamscale-dev/#license">License section</a> for details on licenses of third-party libraries distributed with it.</p></div><h2 id="installing-teamscale-dev" tabindex="-1">Installing <code>teamscale-dev</code> <a class="header-anchor" href="#installing-teamscale-dev" aria-label="Permalink to &quot;Installing \`teamscale-dev\`&quot;">​</a></h2><p>The CQSE website offers both the <strong>latest version</strong> and <strong>older versions</strong> of the <code>teamscale-dev</code> client for download. Moreover, you can choose between platform-specific (for Windows, Linux, macOS) and platform-independent downloads. While the former downloads are self-contained, the latter requires a Java runtime environment to be installed on your machine.</p><ul><li><strong>Download for Windows (x86):</strong><ul><li><strong>Latest Version:</strong> <a href="https://downloads.teamscale.com/ide/cli/latest/teamscale-dev-windows-x86_64.zip" target="_blank" rel="noreferrer">https://downloads.teamscale.com/ide/cli/latest/teamscale-dev-windows-x86_64.zip</a> (<a href="https://downloads.teamscale.com/ide/cli/latest/teamscale-dev-windows-x86_64.zip.sha256" target="_blank" rel="noreferrer">SHA256 checksum</a>)</li><li><strong>Older Version:</strong> <a href="https://downloads.teamscale.com/ide/cli/vM.N.x/teamscale-dev-windows-x86_64.zip" target="_blank" rel="noreferrer">https://downloads.teamscale.com/ide/cli/vM.N.x/teamscale-dev-windows-x86_64.zip</a> (replacing <code>M.N</code> by the feature version you need but keeping the <code>.x</code>, e.g., <code>7.8.x</code>)</li></ul></li><li><strong>Download for Linux (x86):</strong><ul><li><strong>Latest Version:</strong> <a href="https://downloads.teamscale.com/ide/cli/latest/teamscale-dev-linux-x86_64.zip" target="_blank" rel="noreferrer">https://downloads.teamscale.com/ide/cli/latest/teamscale-dev-linux-x86_64.zip</a> (<a href="https://downloads.teamscale.com/ide/cli/latest/teamscale-dev-linux-x86_64.zip.sha256" target="_blank" rel="noreferrer">SHA256 checksum</a>)</li><li><strong>Older Version:</strong> <a href="https://downloads.teamscale.com/ide/cli/vM.N.x/teamscale-dev-linux-x86_64.zip" target="_blank" rel="noreferrer">https://downloads.teamscale.com/ide/cli/vM.N.x/teamscale-dev-linux-x86_64.zip</a> (replacing <code>M.N</code> by the feature version you need but keeping the <code>.x</code>, e.g., <code>7.8.x</code>)</li></ul></li><li><strong>Download for macOS (x86):</strong><ul><li><strong>Latest Version:</strong> <a href="https://downloads.teamscale.com/ide/cli/latest/teamscale-dev-macos-x86_64.zip" target="_blank" rel="noreferrer">https://downloads.teamscale.com/ide/cli/latest/teamscale-dev-macos-x86_64.zip</a> (<a href="https://downloads.teamscale.com/ide/cli/latest/teamscale-dev-macos-x86_64.zip.sha256" target="_blank" rel="noreferrer">SHA256 checksum</a>)</li><li><strong>Older Version:</strong> <a href="https://downloads.teamscale.com/ide/cli/vM.N.x/teamscale-dev-macos-x86_64.zip" target="_blank" rel="noreferrer">https://downloads.teamscale.com/ide/cli/vM.N.x/teamscale-dev-macos-x86_64.zip</a> (replacing <code>M.N</code> by the feature version you need but keeping the <code>.x</code>, e.g., <code>7.8.x</code>)</li></ul></li><li><strong>Download for macOS (ARM):</strong><ul><li><strong>Latest Version:</strong> <a href="https://downloads.teamscale.com/ide/cli/latest/teamscale-dev-macos-aarch64.zip" target="_blank" rel="noreferrer">https://downloads.teamscale.com/ide/cli/latest/teamscale-dev-macos-aarch64.zip</a> (<a href="https://downloads.teamscale.com/ide/cli/latest/teamscale-dev-macos-aarch64.zip.sha256" target="_blank" rel="noreferrer">SHA256 checksum</a>)</li><li><strong>Older Version:</strong> <a href="https://downloads.teamscale.com/ide/cli/vM.N.x/teamscale-dev-macos-aarch64.zip" target="_blank" rel="noreferrer">https://downloads.teamscale.com/ide/cli/vM.N.x/teamscale-dev-macos-aarch64.zip</a> (replacing <code>M.N</code> by the feature version you need but keeping the <code>.x</code>, e.g., <code>7.8.x</code>)</li></ul></li><li><strong>Platform-independent download (requires a Java Runtime Environment)</strong><ul><li><strong>Latest Version:</strong> <a href="https://downloads.teamscale.com/ide/cli/latest/teamscale-dev.zip" target="_blank" rel="noreferrer">https://downloads.teamscale.com/ide/cli/latest/teamscale-dev.zip</a> (<a href="https://downloads.teamscale.com/ide/cli/latest/teamscale-dev.zip.sha256" target="_blank" rel="noreferrer">SHA256 checksum</a>)</li><li><strong>Older Version:</strong> <a href="https://downloads.teamscale.com/ide/cli/vM.N.x/teamscale-dev.zip" target="_blank" rel="noreferrer">https://downloads.teamscale.com/ide/cli/vM.N.x/teamscale-dev.zip</a> (replacing <code>M.N</code> by the feature version you need but keeping the <code>.x</code>, e.g., <code>7.8.x</code>)<div class="info custom-block"><p class="custom-block-title">Java Runtime Environment (JRE) Requirements</p><p>Starting with version 2024.9, the platform-independent download requires a JRE running Java 21 or later. Earlier versions require Java 17 or later. (See the <a href="./../../../reference/system-requirements/#system-requirements-for-ide-plugins">System Requirements</a>)</p></div></li></ul></li></ul><p>Once you have downloaded the appropriate <code>.zip</code> archive, perform the following installation steps depending on your operating system (<a href="#windows">Windows</a>, <a href="#linux-macos">macOS</a>, <a href="#linux-macos">Linux</a>).</p><h3 id="linux-macos" tabindex="-1">Linux/macOS <a class="header-anchor" href="#linux-macos" aria-label="Permalink to &quot;Linux/macOS&quot;">​</a></h3><p>For macOS and Linux, it&#39;s recommended to install <code>teamscale-dev</code> to the <code>/opt</code> directory and then linking the executable to your <code>/usr/local/bin</code> directory.</p><ol><li>Extract the archive: <code>sudo unzip teamscale-dev*.zip -d /opt/</code></li><li>Link executable: <code>sudo ln -s /opt/teamscale-dev/bin/teamscale-dev /usr/local/bin/</code></li><li>Add the following line to your <code>~/.bashrc</code> or <code>~/.zshrc</code> to enable auto-completion:<div class="language-shell vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">shell</span><pre class="shiki shiki-themes github-light github-dark vp-code" tabindex="0"><code><span class="line"><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;">source</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> &lt;( </span><span style="--shiki-light:#6F42C1;--shiki-dark:#B392F0;">teamscale-dev</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> generate-completion )</span></span></code></pre></div></li></ol><div class="tip custom-block"><p class="custom-block-title">macOS Security</p><p>Note that the startup of <code>teamscale-dev</code> may be blocked on macOS upon the first execution. To allow execution of the executable go to <em>System Settings &gt; Privacy &amp; Security</em> and check the <em>Security</em> section for an application that was blocked from running.</p></div><h3 id="windows" tabindex="-1">Windows <a class="header-anchor" href="#windows" aria-label="Permalink to &quot;Windows&quot;">​</a></h3><p>On Windows, it&#39;s recommended to install <code>teamscale-dev</code> to the <code>C:\\Program Files</code> directory and adding the contained <code>bin</code> directory to your <code>PATH</code> environment variable.</p><ol><li>Extract the archive to <code>C:\\Program Files</code>.</li><li>Add <code>C:\\Program Files\\teamscale-dev\\bin</code> to your <code>PATH</code> via <em>Control Panel &gt; Advanced System Settings &gt; Environment Variables &gt; System Variables</em>.</li></ol><h2 id="configuring-your-projects-using-teamscale-toml-files" tabindex="-1">Configuring Your Projects Using <code>.teamscale.toml</code> Files <a class="header-anchor" href="#configuring-your-projects-using-teamscale-toml-files" aria-label="Permalink to &quot;Configuring Your Projects Using \`.teamscale.toml\` Files&quot;">​</a></h2><p>Before you can use <code>teamscale-dev</code>, your local projects needs to be configured to map to projects on the Teamscale server. This is done using one or more <code>.teamscale.toml</code> configuration files in a simple, uniform <a href="./../../../reference/teamscale-toml/">file format (<code>.teamscale.toml</code>)</a>.</p><p>In the simplest case, place a file like the following in the root directory of your project:</p><div class="language-toml vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">toml</span><pre class="shiki shiki-themes github-light github-dark vp-code" tabindex="0"><code><span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">root = </span><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;">true</span></span>
<span class="line"></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">[</span><span style="--shiki-light:#6F42C1;--shiki-dark:#B392F0;">project</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">]</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">id = </span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">&quot;example&quot;</span></span>
<span class="line"></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">[</span><span style="--shiki-light:#6F42C1;--shiki-dark:#B392F0;">server</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">]</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">url = </span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">&quot;https://example.com/teamscale/&quot;</span></span></code></pre></div><p>For more advanced cases, please refer to the documentation of the <a href="./../../../reference/teamscale-toml/">file format</a>.</p><h2 id="invoking-teamscale-dev-from-different-ides-or-editors" tabindex="-1">Invoking <code>teamscale-dev</code> from Different IDEs or Editors <a class="header-anchor" href="#invoking-teamscale-dev-from-different-ides-or-editors" aria-label="Permalink to &quot;Invoking \`teamscale-dev\` from Different IDEs or Editors&quot;">​</a></h2><h3 id="sublime-text" tabindex="-1">Sublime Text <a class="header-anchor" href="#sublime-text" aria-label="Permalink to &quot;Sublime Text&quot;">​</a></h3><p>To use <code>teamscale-dev</code> conveniently from within <a href="https://www.sublimetext.com/" target="_blank" rel="noreferrer">Sublime Text</a>, perform the following steps:</p><ol><li><p>Add a new build system (<em>Tools</em> &gt; <em>Build System</em> &gt; <em>New Build System...</em>).</p></li><li><p>Copy (or <a href="pre-commit.sublime-build" download>download</a>) and paste the following snippet in Sublime Text&#39;s <a href="https://www.sublimetext.com/docs/build_systems.html" target="_blank" rel="noreferrer">build-system format</a>:</p><div class="language-json vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">json</span><pre class="shiki shiki-themes github-light github-dark vp-code" tabindex="0"><code><span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">{</span></span>
<span class="line"><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;">  &quot;cmd&quot;</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">: [</span></span>
<span class="line"><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">    &quot;teamscale-dev/bin/teamscale-dev&quot;</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">,</span></span>
<span class="line"><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">    &quot;pre-commit&quot;</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">,</span></span>
<span class="line"><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">    &quot;--user&quot;</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">,</span></span>
<span class="line"><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">    &quot;TODO Your username&quot;</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">,</span></span>
<span class="line"><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">    &quot;--accesskey&quot;</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">,</span></span>
<span class="line"><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">    &quot;TODO Your access key&quot;</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">,</span></span>
<span class="line"><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">    &quot;$file&quot;</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">  ],</span></span>
<span class="line"><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;">  &quot;keyfiles&quot;</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">: [</span></span>
<span class="line"><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">    &quot;.teamscale.toml&quot;</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">  ],</span></span>
<span class="line"><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;">  &quot;file_regex&quot;</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">: </span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">&quot;^(.*):(</span><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;">\\\\</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">d+):(</span><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;">\\\\</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">d+):</span><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;">\\\\</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">s+(?:error|warning):</span><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;">\\\\</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">s+(.*)$&quot;</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">}</span></span></code></pre></div></li><li><p>Adapt the <code>cmd</code> property to point to your <code>teamscale-dev</code> executable (<code>bin/teamscale-dev.bat</code> on Windows, <code>bin/teamscale-dev</code> on Linux and macOS).</p></li><li><p>Adapt the <code>cmd</code> property so that the <code>--user</code> and <code>--accesskey</code> options use your credentials, i.e., your <em>username</em> and <a href="./../../../glossary/#access-key"><em>access key</em></a>. (See the documentation of the <a href="./../../../reference/cli/teamscale-dev/#supplying-server-credentials">command-line client</a> for further ways to supply your credentials.)</p></li></ol><p>Executing a build with the <em>pre-commit</em> build system will now show any findings for the current file.</p><h3 id="vim-neovim" tabindex="-1">Vim/NeoVim <a class="header-anchor" href="#vim-neovim" aria-label="Permalink to &quot;Vim/NeoVim&quot;">​</a></h3><p>To use <code>teamscale-dev</code> conveniently from within Vim or NeoVim, we provide <a href="https://github.com/cqse/teamscale-vim" target="_blank" rel="noreferrer">integration via a compiler plug-in</a>.</p><ol><li><p>Copy <a href="https://github.com/cqse/teamscale-vim/blob/master/compiler/teamscale.vim" target="_blank" rel="noreferrer">compiler/teamscale.vim</a> to your <code>$VIMRUNTIME/compiler</code> folder, e.g. <code>~/.config/nvim/compiler</code> for NeoVim.</p></li><li><p>In your <code>.vimrc</code>, you must at least define the variables mentioned in <a href="https://github.com/cqse/teamscale-vim/blob/master/vimrc.vim" target="_blank" rel="noreferrer">vimrc.vim</a> to let the plug-in know your Teamscale credentials and where <code>teamscale-dev</code> is installed. Optionally, you can use the remaining commands in that file to define a convenient command <code>:Precommit</code> to run pre-commit for the current file and a keyboard mapping. Internally, this command selects Teamscale as the compiler, calls <code>:make %</code>, and then reverts to your previously set compiler to not interrupt your existing compiler/make workflow. Any findings are then shown in the quickfix window (<code>:cw</code>).</p></li></ol><p>If you want pre-commit on-save, you can define a <a href="https://vimdoc.sourceforge.net/htmldoc/autocmd.html#BufWritePost" target="_blank" rel="noreferrer"><code>BufWritePost</code></a> autocommand to call <code>:Precommit</code> whenever the current buffer is written.</p><h3 id="xcode" tabindex="-1">XCode <a class="header-anchor" href="#xcode" aria-label="Permalink to &quot;XCode&quot;">​</a></h3><p>To use <code>teamscale-dev</code> conveniently from within <a href="https://developer.apple.com/xcode/" target="_blank" rel="noreferrer">XCode</a>, perform the following steps:</p><ol><li>Configure credentials (This step only needs to be performed once for all your XCode projects.): <ol><li>Create a file called <code>.teamscale-dev.args</code> in your home directory (i.e., <code>/Users/&lt;username&gt;/.teamscale-dev.args</code>).</li><li>Configure an <a href="./../../../reference/cli/teamscale-dev/#supplying-command-line-options-via-an-args-file">args file for supplying credentials</a>.</li></ol></li><li>Configure XCode project: <ol><li>Open your project in XCode.</li><li>Select project in the <em>Project navigator</em>.</li><li>Add new target called <code>Teamscale Pre-Commit</code>: <ol><li>In the <em>TARGETS</em> panel, click the <em>+</em> icon.</li><li>Select <em>Other &gt; Aggregate</em> and go to <em>Next</em>.</li><li>Set the name <em>Product Name</em> to <code>Teamscale Pre-Commit</code>.</li></ol></li><li>Add a new <em>Run Script</em> phase to the build of the new target: <ol><li>Go to the <em>Build Phases</em> tab of the <em>Teamscale Pre-Commit</em> target.</li><li>Add a <em>New Run Script Phase</em> via the <em>+</em> icon in the top left corner.</li><li>Set the <em>Shell</em> command to:<div class="language-shell vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">shell</span><pre class="shiki shiki-themes github-light github-dark vp-code" tabindex="0"><code><span class="line"><span style="--shiki-light:#6F42C1;--shiki-dark:#B392F0;">teamscale-dev</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> pre-commit</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> @&quot;\${</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">HOME</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">}/.teamscale-dev.args&quot;</span><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;"> --only-uncommitted-changes</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> &quot;\${</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">SRCROOT</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">}&quot;</span></span></code></pre></div></li></ol></li></ol></li></ol><p>Once this is configured you can select the <em>Teamscale Pre-Commit</em> target at the top and then run pre-commit by executing the active scheme via the play button at the top. This will execute pre-commit analysis on new or changed files that have not been committed yet.</p>`,33)])])}const u=a(o,[["render",l]]);export{p as __pageData,u as default};
