/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.rest.client.converter;

import com.fasterxml.jackson.databind.ObjectReader;
import com.teamscale.core.rest.client.converter.IBodyConverterProfilingMonitor;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Objects;
import okhttp3.MediaType;
import okhttp3.ResponseBody;
import org.conqat.lib.commons.function.BiConsumerWithException;
import org.jspecify.annotations.NonNull;
import retrofit2.Converter;

public class ResponseBodyConverter<T>
implements Converter<ResponseBody, T> {
    private static final MediaType APPLICATION_TEXT = MediaType.get((String)"application/text");
    private final ObjectReader adapter;
    private final Type type;
    private final List<BiConsumerWithException<ResponseBody, Type, IOException>> customResponseValidators;
    private final IBodyConverterProfilingMonitor profiler;

    ResponseBodyConverter(Type type, ObjectReader adapter, List<BiConsumerWithException<ResponseBody, Type, IOException>> customResponseValidators, IBodyConverterProfilingMonitor profiler) {
        this.type = type;
        this.adapter = adapter;
        this.customResponseValidators = customResponseValidators;
        this.profiler = profiler;
    }

    public T convert(@NonNull ResponseBody value) throws IOException {
        try (ResponseBody responseBody = value;){
            Object result;
            if (Objects.equals(String.class, this.type) && (ResponseBodyConverter.isTextContentType(value.contentType()) || ResponseBodyConverter.isOfContentType(value.contentType(), APPLICATION_TEXT))) {
                String string = value.string();
                return (T)string;
            }
            for (BiConsumerWithException<ResponseBody, Type, IOException> customResponseValidator : this.customResponseValidators) {
                customResponseValidator.accept((Object)value, (Object)this.type);
            }
            this.profiler.startProfiling(this.type, "deserializing response body");
            String bodyContent = value.string();
            try {
                result = this.adapter.readValue(bodyContent);
            }
            catch (IOException e) {
                throw new IOException("Unable to read response body. Content: " + bodyContent.substring(0, Math.min(100, bodyContent.length())), e);
            }
            finally {
                this.profiler.stopProfiling(this.type, "deserializing response body");
            }
            Object object = result;
            return (T)object;
        }
    }

    private static boolean isTextContentType(MediaType mediaType) {
        if (mediaType == null) {
            return false;
        }
        return "text".equals(mediaType.type());
    }

    public static boolean isOfContentType(MediaType mediaType, MediaType mediaTypeToCheck) {
        if (mediaType == null) {
            return false;
        }
        return Objects.equals(mediaType.type(), mediaTypeToCheck.type()) && Objects.equals(mediaType.subtype(), mediaTypeToCheck.subtype());
    }
}

