/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.abap;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.option.CheckOption;
import eu.cqse.check.framework.core.phase.ECodeViewOption;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.conqat.engine.core.pattern.IncludeExcludeAntPatternSupport;

@Check(id="cqse-abap-modifications", languages={ELanguage.ABAP})
public class AbapModificationsCheck
extends CheckImplementationBase {
    @CheckOption(name="Excluded paths", description="Comma separated list of ant patterns holding specific paths in which SAP standard code modifications are allowed.")
    private Set<String> excludedPaths = new HashSet<String>();
    private static final String MODIFICATIONS_UNIFORM_PATH = "**/_MODIFICATIONS/**.abap";
    private static final Pattern OPEN_MODIFICATION_BLOCK_PATTERN = Pattern.compile("\\*\\{ +(INSERT|REPLACE|DELETE) +[A-Z0-9]{10}\\s+\\d+\\s*");
    private static final Pattern CLOSE_MODIFICATION_BLOCK_PATTERN = Pattern.compile("\\*} +(INSERT|REPLACE|DELETE)\\s*");
    private static final int MATCHING_CLOSE_BLOCK_NOT_FOUND = -1;
    private final IncludeExcludeAntPatternSupport includeExclude = new IncludeExcludeAntPatternSupport();

    public void initialize() {
        this.includeExclude.addIncludePattern(MODIFICATIONS_UNIFORM_PATH);
        this.excludedPaths.forEach(arg_0 -> ((IncludeExcludeAntPatternSupport)this.includeExclude).addExcludePattern(arg_0));
    }

    protected ECodeViewOption getCodeViewOption() {
        return ECodeViewOption.UNFILTERED;
    }

    public void execute() throws CheckException {
        if (!this.includeExclude.isIncluded(this.context.getUniformPath())) {
            return;
        }
        List<IToken> comments = this.context.getTokens(this.getCodeViewOption()).stream().filter(token -> token.getType() == ETokenType.TRADITIONAL_COMMENT).toList();
        for (int i = 0; i < comments.size(); ++i) {
            int end;
            int closeModificationBlockIndex;
            if (!OPEN_MODIFICATION_BLOCK_PATTERN.matcher(comments.get(i).getText()).matches() || (closeModificationBlockIndex = AbapModificationsCheck.findCloseModificationBlock(comments, i + 1)) == -1) continue;
            int start = comments.get(i).getLineNumber() + 1;
            if (start <= (end = comments.get(closeModificationBlockIndex).getLineNumber() + 1)) {
                this.buildFinding("Modification of standard code", this.buildLocation().betweenLines(start, end)).createAndStore();
            }
            i = closeModificationBlockIndex;
        }
    }

    private static int findCloseModificationBlock(List<IToken> comments, int startTokenIndex) {
        for (int i = startTokenIndex; i < comments.size(); ++i) {
            if (!CLOSE_MODIFICATION_BLOCK_PATTERN.matcher(comments.get(i).getText()).matches()) continue;
            return i;
        }
        return -1;
    }
}

