/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.abap;

import eu.cqse.check.abap.OpenSqlWriteStatement;
import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.core.phase.ECodeViewOption;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import eu.cqse.check.framework.typetracker.ITypeResolution;
import eu.cqse.check.framework.util.abap.AbapCheckUtils;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.conqat.lib.commons.markup.MarkupUtils;

@Check(id="cqse-no-write-to-standard-table", languages={ELanguage.ABAP}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE, ECheckParameter.TYPE_RESOLUTION})
public class NoWriteToStandardTableCheck
extends CheckImplementationBase {
    private static final Set<String> RELEVANT_STATEMENT_SUBTYPES = Set.of("insert", "modify", "update", "delete");
    private static final String FINDING_MESSAGE = "%s statement should not write to standard table '%s'";
    private static final String ENHANCEMENT_STATEMENT_SUBTYPE = "enhancement";

    protected ECodeViewOption getCodeViewOption() {
        return ECodeViewOption.FILTERED;
    }

    public void execute() throws CheckException {
        List entities = this.context.getAbstractSyntaxTree(this.getCodeViewOption());
        ITypeResolution typeResolution = null;
        for (ShallowEntity statement : ShallowEntityTraversalUtils.listEntitiesOfType((Collection)entities, (EShallowEntityType)EShallowEntityType.STATEMENT)) {
            if (!RELEVANT_STATEMENT_SUBTYPES.contains(statement.getSubtype()) || AbapCheckUtils.isIgnoredForDatabaseChecks((ShallowEntity)statement, (List)entities, (String)this.context.getUniformPath())) continue;
            if (typeResolution == null) {
                typeResolution = this.context.getTypeResolution(this.getCodeViewOption());
            }
            this.processOpenSqlStatement(statement, typeResolution);
        }
    }

    private void processOpenSqlStatement(ShallowEntity currentEntity, ITypeResolution typeResolution) {
        UnmodifiableList tokens = currentEntity.ownStartTokens();
        if (tokens == null || tokens.isEmpty()) {
            return;
        }
        OpenSqlWriteStatement statement = OpenSqlWriteStatement.create((ShallowEntity)currentEntity, (List)tokens, (ITypeResolution)typeResolution);
        if (statement != null && statement.targetsStandardDatabaseTable() && !NoWriteToStandardTableCheck.isDeleteOnLocalVariable((List<IToken>)tokens) && !NoWriteToStandardTableCheck.isInsideEnhancementStatement(currentEntity)) {
            String message = String.format(FINDING_MESSAGE, MarkupUtils.escapeMarkdownRelevantSymbols((String)statement.getStatementStartToken().getText()), MarkupUtils.escapeMarkdownRelevantSymbols((String)statement.getTableName()));
            this.buildFinding(message, this.buildLocation().forToken((IToken)tokens.get(0))).createAndStore();
        }
    }

    private static boolean isDeleteOnLocalVariable(List<IToken> tokens) {
        return tokens.get(0).getType().equals((Object)ETokenType.DELETE) && tokens.stream().noneMatch(token -> token.getType().equals((Object)ETokenType.FROM));
    }

    private static boolean isInsideEnhancementStatement(ShallowEntity statement) {
        return ShallowEntityTraversalUtils.findParentEntity((ShallowEntity)statement, parentEntity -> parentEntity.getType() == EShallowEntityType.STATEMENT && parentEntity.getSubtype().equals(ENHANCEMENT_STATEMENT_SUBTYPE)).isPresent();
    }
}

