/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.abap;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.core.option.CheckOption;
import eu.cqse.check.framework.core.util.CheckUtils;
import eu.cqse.check.framework.matcher.ITokenMatcher;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.conqat.lib.commons.collections.UnmodifiableList;

@Check(id="cqse-open-dataset-with-filter-addition", languages={ELanguage.ABAP}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class OpenDatasetWithFilterAdditionCheck
extends CheckImplementationBase {
    private static final String CHECK_NAME = "Suspicious usage of OPEN DATASET";
    @CheckOption(name="Suspicious usage of OPEN DATASET - Allowed OS commands", description="Comma separated list of operating systemcommands (regular expressions) which are allowed for FILTER addition in OPEN DATASET.")
    private Set<String> osCommandWhitelist = Collections.emptySet();

    public void execute() throws CheckException {
        List statements = ShallowEntityTraversalUtils.listEntitiesOfType((Collection)this.context.getAbstractSyntaxTree(this.getCodeViewOption()), (EShallowEntityType)EShallowEntityType.STATEMENT);
        for (ShallowEntity statement : statements) {
            if (!"open".equals(statement.getSubtype())) continue;
            this.processEntity(statement);
        }
    }

    private void processEntity(ShallowEntity entity) {
        UnmodifiableList tokens = entity.ownStartTokens();
        if (tokens.size() < 2 || ((IToken)tokens.get(1)).getType() != ETokenType.DATASET) {
            return;
        }
        int filterTokenIndex = TokenStreamUtils.firstTokenMatching((List)tokens, (ITokenMatcher)ETokenType.FILTER);
        if (filterTokenIndex == -1 || tokens.size() <= filterTokenIndex + 1) {
            return;
        }
        Object findingsMessage = "Usage of OPEN DATASET with FILTER addition";
        String osCommand = CheckUtils.getUnquotedTextForCharacterLiteral((IToken)((IToken)tokens.get(filterTokenIndex + 1)));
        if (osCommand != null) {
            if (this.osCommandWhitelist.stream().anyMatch(osCommand::matches)) {
                return;
            }
            findingsMessage = (String)findingsMessage + " '" + osCommand + "'";
        }
        this.buildFinding((String)findingsMessage, this.buildLocation().forEntity(entity)).createAndStore();
    }
}

