/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.clike;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.matcher.ITokenMatcher;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import eu.cqse.check.framework.util.CLikeLanguageFeatureParserBase;
import eu.cqse.check.framework.util.tokens.TokenPattern;
import eu.cqse.check.framework.util.tokens.TokenPatternMatch;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.conqat.lib.commons.collections.UnmodifiableList;

@Check(id="cqse-change-loop-var-in-for-loop", languages={ELanguage.CS, ELanguage.JAVA}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class ChangeLoopVarInForLoopCheck
extends CheckImplementationBase {
    public static final String NAME = "Avoid changing the loop variable in a `for` loop";
    private static final int LOOP_VARIABLE_GROUP_INDEX = 0;
    private static final TokenPattern ASSIGNMENTS_IN_FOR_LOOP_PATTERN = new TokenPattern().sequence(new Object[]{ETokenType.IDENTIFIER}).group(0).sequence(new Object[]{ETokenType.EQ});
    private static final int STATEMENT_VARIABLE_GROUP_INDEX = 0;
    private TokenPattern variableChangePattern;

    private static TokenPattern buildVariableChangePattern(CLikeLanguageFeatureParserBase languageFeatureParser) {
        return new TokenPattern().alternative(new Object[]{new TokenPattern().sequence(new Object[]{ETokenType.IDENTIFIER}).group(0).alternative(new Object[]{languageFeatureParser.variableAssignmentTypes(), languageFeatureParser.incrementDecrementUnaryOperators()}), new TokenPattern().sequence(new Object[]{languageFeatureParser.incrementDecrementUnaryOperators()}).sequence(new Object[]{ETokenType.IDENTIFIER}).group(0)});
    }

    public void execute() throws CheckException {
        this.variableChangePattern = ChangeLoopVarInForLoopCheck.buildVariableChangePattern((CLikeLanguageFeatureParserBase)CLikeLanguageFeatureParserBase.getInstance((ELanguage)this.context.getLanguage()).orElseThrow());
        List statements = ShallowEntityTraversalUtils.listEntitiesOfType((Collection)this.context.getAbstractSyntaxTree(this.getCodeViewOption()), (EShallowEntityType)EShallowEntityType.STATEMENT);
        for (ShallowEntity statement : statements) {
            if (!"for".equals(statement.getSubtype())) continue;
            this.processEntity(statement);
        }
    }

    private void processEntity(ShallowEntity entity) {
        UnmodifiableList forTokens = entity.ownStartTokens();
        if (forTokens.isEmpty()) {
            return;
        }
        int semicolonTokenIndex = TokenStreamUtils.firstTokenMatching((List)forTokens, (ITokenMatcher)ETokenType.SEMICOLON);
        if (semicolonTokenIndex == -1) {
            return;
        }
        List<String> loopVariables = ChangeLoopVarInForLoopCheck.getVariablesDefinedInForLoop((List<IToken>)forTokens);
        this.deepSearchForChangedVariablePattern(entity, (List<ShallowEntity>)entity.getChildren(), loopVariables);
    }

    private static List<String> getVariablesDefinedInForLoop(List<IToken> tokens) {
        ArrayList<String> loopVariables = new ArrayList<String>();
        for (TokenPatternMatch match : ASSIGNMENTS_IN_FOR_LOOP_PATTERN.findAll(tokens)) {
            List matchedVariables = match.groupTexts(0);
            if (matchedVariables.isEmpty()) continue;
            loopVariables.add((String)matchedVariables.get(0));
        }
        return loopVariables;
    }

    private void deepSearchForChangedVariablePattern(ShallowEntity sourceForLoop, List<ShallowEntity> children, List<String> variables) {
        for (ShallowEntity child : children) {
            if (child.hasChildren()) {
                this.deepSearchForChangedVariablePattern(sourceForLoop, (List<ShallowEntity>)child.getChildren(), variables);
            }
            this.createFindingsOnVariableChanged(sourceForLoop, child, variables);
        }
    }

    private void createFindingsOnVariableChanged(ShallowEntity sourceForLoop, ShallowEntity child, List<String> variables) {
        List variableChangePatternAll = this.variableChangePattern.findAll(child.ownTokens().stream().flatMap(Collection::stream).toList());
        for (TokenPatternMatch patternMatch : variableChangePatternAll) {
            List statementVariables = patternMatch.groupTexts(0);
            if (statementVariables.isEmpty()) continue;
            for (String variable : variables) {
                if (!((String)statementVariables.get(0)).equals(variable)) continue;
                this.buildFinding("Loop variable `" + variable + "` (at line: " + child.getStartLine() + ") changed in for-loop", this.buildLocation().forEntity(sourceForLoop)).createAndStore();
            }
        }
    }
}

