/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.cpp;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.core.phase.ECodeViewOption;
import eu.cqse.check.framework.matcher.ITokenMatcher;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.UnmodifiableList;

@Check(id="cqse-array-argument", languages={ELanguage.CPP, ELanguage.CPP_MS_CLI, ELanguage.C}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class ArrayArgumentCheck
extends CheckImplementationBase {
    private static final String MAIN_METHOD_NAME = "main";

    public void execute() throws CheckException {
        List methods = ShallowEntityTraversalUtils.listEntitiesOfType((Collection)this.context.getAbstractSyntaxTree(this.getCodeViewOption()), (EShallowEntityType)EShallowEntityType.METHOD);
        for (ShallowEntity method : methods) {
            this.processEntity(method);
        }
    }

    protected ECodeViewOption getCodeViewOption() {
        return ECodeViewOption.FILTERED_PREPROCESSED;
    }

    private void processEntity(ShallowEntity entity) throws CheckException {
        List<IToken> tokens = ArrayArgumentCheck.findArrayIdentifiersInArguments(entity);
        if (!MAIN_METHOD_NAME.equals(entity.getName())) {
            this.createFindingsForArguments(tokens);
        }
        this.createFindingsForSubStatements(entity, tokens);
    }

    private static List<IToken> findArrayIdentifiersInArguments(ShallowEntity entity) {
        UnmodifiableList tokens = entity.ownStartTokens();
        int openingParenIndex = TokenStreamUtils.findFirstTopLevel((List)tokens, (ITokenMatcher)ETokenType.LPAREN, Arrays.asList(ETokenType.LT), Arrays.asList(ETokenType.GT));
        if (openingParenIndex == -1) {
            return CollectionUtils.emptyList();
        }
        int closingParenIndex = TokenStreamUtils.findMatchingClosingToken((List)tokens, (int)(openingParenIndex + 1), (ETokenType)ETokenType.LPAREN, (ETokenType)ETokenType.RPAREN);
        if (closingParenIndex == -1) {
            return CollectionUtils.emptyList();
        }
        List offsets = TokenStreamUtils.firstTokenOfTypeSequences(tokens.subList(0, closingParenIndex), (int)openingParenIndex, (ETokenType[])new ETokenType[]{ETokenType.IDENTIFIER, ETokenType.LBRACK});
        ArrayList<IToken> identifiers = new ArrayList<IToken>();
        for (Integer i : offsets) {
            identifiers.add((IToken)tokens.get(i));
        }
        return identifiers;
    }

    private void createFindingsForArguments(List<IToken> tokens) throws CheckException {
        for (IToken token : tokens) {
            this.buildFinding("Array in argument list", this.buildLocation().forToken(token)).createAndStore();
        }
    }

    private void createFindingsForSubStatements(ShallowEntity entity, List<IToken> tokens) throws CheckException {
        if (!tokens.isEmpty()) {
            List subEntities = ArrayArgumentCheck.select((ShallowEntity)entity, (String)"descendant::STATEMENT");
            List<String> tokenTexts = ArrayArgumentCheck.toText(tokens);
            for (ShallowEntity subEntity : subEntities) {
                this.createFindingsForUseOfSizeof(subEntity, tokenTexts);
            }
        }
    }

    private static List<String> toText(List<IToken> tokens) {
        ArrayList<String> tokenTexts = new ArrayList<String>();
        for (IToken token : tokens) {
            tokenTexts.add(token.getText());
        }
        return tokenTexts;
    }

    private void createFindingsForUseOfSizeof(ShallowEntity entity, List<String> tokenTexts) throws CheckException {
        UnmodifiableList tokens = entity.ownStartTokens();
        List offsets = TokenStreamUtils.firstTokenOfTypeSequences((List)tokens, (int)0, (ETokenType[])new ETokenType[]{ETokenType.SIZEOF, ETokenType.LPAREN, ETokenType.IDENTIFIER});
        for (Integer i : offsets) {
            IToken potentialMatch = (IToken)tokens.get(i + 2);
            if (!tokenTexts.contains(potentialMatch.getText())) continue;
            this.buildFinding("Use of `sizeof` on array from argument list", this.buildLocation().forToken(potentialMatch)).createAndStore();
        }
    }
}

