/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.cpp.misra;

import eu.cqse.check.cpp.misra.CppMethodDeclarationsExtractorPhase;
import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.core.phase.ECodeViewOption;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamTextUtils;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import eu.cqse.check.framework.util.LanguageFeatureParser;
import eu.cqse.check.framework.util.cpp.CppCheckUtils;
import eu.cqse.check.framework.util.tokens.TokenUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.engine.commons.findings.location.TextRegionLocation;
import org.conqat.lib.commons.collections.CollectionUtils;

@Check(id="cqse-all-declarations-shall-use-same-signature", languages={ELanguage.CPP, ELanguage.CPP_MS_CLI, ELanguage.C}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE}, phases={CppMethodDeclarationsExtractorPhase.class})
public class AllDeclarationsShallUseSameSignatureCheck
extends CheckImplementationBase {
    protected ECodeViewOption getCodeViewOption() {
        return ECodeViewOption.FILTERED_PREPROCESSED;
    }

    public void execute() throws CheckException {
        List abstractSyntaxTree = this.context.getAbstractSyntaxTree(this.getCodeViewOption());
        List methods = ShallowEntityTraversalUtils.listEntitiesOfTypes((Collection)abstractSyntaxTree, EnumSet.of(EShallowEntityType.METHOD));
        for (ShallowEntity method : methods) {
            this.processEntity(method);
        }
    }

    private void processEntity(ShallowEntity entity) {
        List<CppMethodDeclarationsExtractorPhase.FunctionDeclaration> declarations = this.getDifferentDeclarationsFrom(entity);
        if (LanguageFeatureParser.CPP.isCppMethod(entity)) {
            return;
        }
        List parameters = LanguageFeatureParser.CPP.getSplitParameterTokens(entity);
        Map<Boolean, List<CppMethodDeclarationsExtractorPhase.FunctionDeclaration>> hasDifferentNumberOfParameters = declarations.stream().collect(Collectors.partitioningBy(declaration -> declaration.getParameters().size() != parameters.size()));
        this.processDeclarationsWithDifferentNumberOfParameters(entity, hasDifferentNumberOfParameters.get(true));
        for (int i = 0; i < parameters.size(); ++i) {
            List implementationParameter = (List)parameters.get(i);
            this.processDeclarationsWithDifferentParameterName(i, implementationParameter, hasDifferentNumberOfParameters.get(false));
            this.processDeclarationsWithDifferentParameterType(i, implementationParameter, hasDifferentNumberOfParameters.get(false));
        }
    }

    private List<CppMethodDeclarationsExtractorPhase.FunctionDeclaration> getDifferentDeclarationsFrom(ShallowEntity entity) {
        if (entity.getName() == null) {
            return Collections.emptyList();
        }
        List uniformPaths = (List)this.context.accessPhaseInvertedResult(CppMethodDeclarationsExtractorPhase.class).apply(entity.getName());
        return CollectionUtils.filter((Collection)uniformPaths, declaration -> ((IToken)entity.ownStartTokens().get(0)).getOffset() != declaration.getLocation().getRawStartOffset());
    }

    private void processDeclarationsWithDifferentNumberOfParameters(ShallowEntity mainDeclaration, List<CppMethodDeclarationsExtractorPhase.FunctionDeclaration> declarationsWithDifferentNumberOfParameters) {
        if (declarationsWithDifferentNumberOfParameters.size() > 0) {
            String message = "Parameter count differs from other declaration(s)";
            this.context.buildFinding(message, (ElementLocation)CppCheckUtils.extractSignatureLocationFrom((String)this.context.getUniformPath(), (ShallowEntity)mainDeclaration)).addSiblingLocations(CollectionUtils.map(declarationsWithDifferentNumberOfParameters, CppMethodDeclarationsExtractorPhase.FunctionDeclaration::getSignatureLocation)).createAndStore();
        }
    }

    private void processDeclarationsWithDifferentParameterName(int parameterIndex, List<IToken> mainParameter, List<CppMethodDeclarationsExtractorPhase.FunctionDeclaration> declarations) {
        IToken implementationParameterName = LanguageFeatureParser.CPP.getVariableNameFromTokens(mainParameter);
        ArrayList<TextRegionLocation> siblingLocations = new ArrayList<TextRegionLocation>();
        for (CppMethodDeclarationsExtractorPhase.FunctionDeclaration declaration : declarations) {
            List declarationParameter = declaration.getParameters().get(parameterIndex);
            IToken declarationParameterName = LanguageFeatureParser.CPP.getVariableNameFromTokens(declarationParameter);
            if (TokenUtils.isEqualTypeAndText((IToken)implementationParameterName, (IToken)declarationParameterName)) continue;
            siblingLocations.add(CppMethodDeclarationsExtractorPhase.getLocationOfParameter(declaration.getUniformPath(), declarationParameter));
        }
        if (siblingLocations.size() > 0) {
            String message = "Parameter name ``" + AllDeclarationsShallUseSameSignatureCheck.getTextOrUndefined(implementationParameterName) + "`` differs from other declaration(s)";
            this.context.buildFinding(message, (ElementLocation)CppMethodDeclarationsExtractorPhase.getLocationOfParameter(this.context.getUniformPath(), mainParameter)).addSiblingLocations(siblingLocations).createAndStore();
        }
    }

    private void processDeclarationsWithDifferentParameterType(int parameterIndex, List<IToken> mainParameter, List<CppMethodDeclarationsExtractorPhase.FunctionDeclaration> declarations) {
        mainParameter = AllDeclarationsShallUseSameSignatureCheck.removeNameIfPresent(mainParameter);
        ArrayList<TextRegionLocation> siblingLocations = new ArrayList<TextRegionLocation>();
        for (CppMethodDeclarationsExtractorPhase.FunctionDeclaration declaration : declarations) {
            List<IToken> declarationParameter = AllDeclarationsShallUseSameSignatureCheck.removeNameIfPresent((List<IToken>)declaration.getParameters().get(parameterIndex));
            if (AllDeclarationsShallUseSameSignatureCheck.removeRedundantTokensAndSort(mainParameter).equals(AllDeclarationsShallUseSameSignatureCheck.removeRedundantTokensAndSort(declarationParameter))) continue;
            siblingLocations.add(CppMethodDeclarationsExtractorPhase.getLocationOfParameter(declaration.getUniformPath(), declarationParameter));
        }
        if (siblingLocations.size() > 0) {
            String message = "Parameter type ``" + TokenStreamTextUtils.concatTokenTexts(mainParameter, (String)" ") + "`` differs from other declaration(s)";
            this.context.buildFinding(message, (ElementLocation)CppMethodDeclarationsExtractorPhase.getLocationOfParameter(this.context.getUniformPath(), mainParameter)).addSiblingLocations(siblingLocations).createAndStore();
        }
    }

    private static List<IToken> removeNameIfPresent(List<IToken> parameters) {
        if (parameters.size() > 1) {
            return TokenStreamUtils.removeAtEnd(parameters, (ETokenType)ETokenType.IDENTIFIER);
        }
        return parameters;
    }

    private static String getTextOrUndefined(IToken token) {
        if (token == null) {
            return "<undefined>";
        }
        return token.getText();
    }

    private static List<String> removeRedundantTokensAndSort(List<IToken> list) {
        List tokenTexts = TokenStreamTextUtils.getTokenTexts(list);
        Collections.sort(tokenTexts);
        if (!tokenTexts.contains("char") && (tokenTexts.contains("short") || tokenTexts.contains("int") || tokenTexts.contains("long"))) {
            tokenTexts.remove("int");
            tokenTexts.remove("signed");
        }
        return tokenTexts;
    }
}

