/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.cross_language;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.core.phase.ECodeViewOption;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import eu.cqse.check.framework.util.tokens.TokenPattern;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import org.conqat.engine.sourcecode.pattern.EnumPatternMatcher;
import org.conqat.engine.sourcecode.pattern.TokenTypePattern;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.UnmodifiableList;

@Check(id="cqse-duplicate-set-elements", languages={ELanguage.CPP, ELanguage.CPP_MS_CLI, ELanguage.JAVA, ELanguage.JAVASCRIPT, ELanguage.KOTLIN, ELanguage.PYTHON, ELanguage.SWIFT, ELanguage.CS}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class DuplicateSetElementCheck
extends CheckImplementationBase {
    private static final String MESSAGE = "Duplicate set element: ";
    private static final TokenTypePattern ELEMENTS_IN_BRACES = new TokenTypePattern("<IDENTIFIER><EQ><LBRACE>.(<COMMA>.)+<RBRACE>");
    private static final TokenTypePattern JAVA_SET_OF_CALL = new TokenTypePattern("(<IDENTIFIER=Set>|<IDENTIFIER=EnumSet>)<DOT><IDENTIFIER=of><LPAREN>(<IDENTIFIER>|.)(<COMMA>(<IDENTIFIER>|.))+<RPAREN>");
    private static final TokenTypePattern PYTHON_SET_CONSTRUCTOR = new TokenTypePattern("(<IDENTIFIER=set>)<LPAREN>(<LBRACK>|<LPAREN>)(<IDENTIFIER>|.)(<COMMA>(<IDENTIFIER>|.))+(<RBRACK>|<RPAREN>)<RPAREN>");
    private static final TokenTypePattern PYTHON_SET_WITH_BRACK_CONSTRUCTOR = new TokenTypePattern("(<IDENTIFIER=set>)<LPAREN>(<LBRACK>)(<IDENTIFIER>|.)(<COMMA>(<IDENTIFIER>|.))+(<RBRACK>)<RPAREN>");
    private static final TokenTypePattern PYTHON_SET_WITH_PAREN_CONSTRUCTOR = new TokenTypePattern("(<IDENTIFIER=set>)<LPAREN>(<LPAREN>)(<IDENTIFIER>|.)(<COMMA>(<IDENTIFIER>|.))+(<RPAREN>)<RPAREN>");
    private static final TokenTypePattern PYTHON_BRACES_CONSTRUCTOR = new TokenTypePattern("<LBRACE>.(<COMMA>.)+<RBRACE>");
    private static final TokenTypePattern JAVASCRIPT_NEW_SET_CONSTRUCTOR = new TokenTypePattern("<NEW><IDENTIFIER=Set><LPAREN><LBRACK>(<IDENTIFIER>|.)(<COMMA>(<IDENTIFIER>|.))+<RBRACK><RPAREN>");
    private static final String POSSIBLE_CSS_SETS = "HashSet|FrozenSet|SortedSet|ImmutableHashSet|ImmutableSortedSet";
    private static final TokenTypePattern CS_SET_CONSTRUCTOR = new TokenTypePattern("<NEW><IDENTIFIER=(HashSet|FrozenSet|SortedSet|ImmutableHashSet|ImmutableSortedSet)><LT>.<GT><LBRACE>(<IDENTIFIER>|.)(<COMMA>(<IDENTIFIER>|.))+<RBRACE>");
    private static final TokenTypePattern CS_SET_CREATE = new TokenTypePattern("<IDENTIFIER=(ImmutableHashSet|ImmutableSortedSet)><DOT><IDENTIFIER=Create><LPAREN>(<IDENTIFIER>|.)(<COMMA>(<IDENTIFIER>|.))+<RPAREN>");
    private static final TokenPattern CPP_SET_VARIABLE = new TokenPattern().alternative(new Object[]{TokenPattern.text((String)"unordered_set"), TokenPattern.text((String)"set")}).skipNested((Object)ETokenType.LT, (Object)ETokenType.GT, false).sequence(new Object[]{ETokenType.IDENTIFIER}).optional(new Object[]{ETokenType.EQ}).sequence(new Object[]{ETokenType.LBRACE});
    private static final String KOTLIN_SET_OF_METHOD = "setOf";
    private static final TokenTypePattern KOTLIN_SET_OF = new TokenTypePattern("<IDENTIFIER=setOf><LPAREN>(<IDENTIFIER>|.)(<COMMA>(<IDENTIFIER>|.))+<RPAREN>");
    private static final TokenPattern SWIFT_SET_VARIABLE = new TokenPattern().sequence(new Object[]{ETokenType.COLON, TokenPattern.text((String)"Set")}).skipNested((Object)ETokenType.LT, (Object)ETokenType.GT, true).sequence(new Object[]{ETokenType.EQ, ETokenType.LBRACK});

    protected ECodeViewOption getCodeViewOption() {
        if (this.context.getLanguage() == ELanguage.CPP || this.context.getLanguage() == ELanguage.CPP_MS_CLI) {
            return ECodeViewOption.FILTERED_PREPROCESSED;
        }
        return super.getCodeViewOption();
    }

    public void execute() throws CheckException {
        List selectedEntities = ShallowEntityTraversalUtils.listEntitiesOfTypes((Collection)this.context.getAbstractSyntaxTree(this.getCodeViewOption()), EnumSet.of(EShallowEntityType.STATEMENT, EShallowEntityType.ATTRIBUTE));
        for (ShallowEntity selectedEntity : selectedEntities) {
            if (selectedEntity.getType() != EShallowEntityType.ATTRIBUTE && !"local variable".equals(selectedEntity.getSubtype()) && !"simple statement".equals(selectedEntity.getSubtype())) continue;
            this.processEntity(selectedEntity);
        }
    }

    private void processEntity(ShallowEntity entity) {
        UnmodifiableList tokens = entity.ownStartTokens();
        if (!this.isSetInitialization((List<IToken>)tokens)) {
            return;
        }
        List<Optional<List<IToken>>> setElements = this.extractSetElements((List<IToken>)tokens);
        if (setElements.isEmpty()) {
            return;
        }
        for (Optional<List<IToken>> element : setElements) {
            if (element.isEmpty()) continue;
            for (IToken duplicateElement : DuplicateSetElementCheck.getDuplicateSetElements(element.get())) {
                this.buildFinding(MESSAGE + duplicateElement.getText(), this.buildLocation().forToken(duplicateElement)).createAndStore();
            }
        }
    }

    private boolean isSetInitialization(List<IToken> tokens) {
        return switch (this.context.getLanguage()) {
            case ELanguage.CPP, ELanguage.CPP_MS_CLI -> {
                if (CPP_SET_VARIABLE.matchesAnywhere(tokens) && ELEMENTS_IN_BRACES.matcher(tokens).find()) {
                    yield true;
                }
                yield false;
            }
            case ELanguage.JAVA -> JAVA_SET_OF_CALL.matcher(tokens).find();
            case ELanguage.JAVASCRIPT -> JAVASCRIPT_NEW_SET_CONSTRUCTOR.matcher(tokens).find();
            case ELanguage.KOTLIN -> KOTLIN_SET_OF.matcher(tokens).find();
            case ELanguage.PYTHON -> {
                if (PYTHON_SET_CONSTRUCTOR.matcher(tokens).find() || PYTHON_BRACES_CONSTRUCTOR.matcher(tokens).find()) {
                    yield true;
                }
                yield false;
            }
            case ELanguage.SWIFT -> SWIFT_SET_VARIABLE.matchesAnywhere(tokens);
            case ELanguage.CS -> {
                if (CS_SET_CONSTRUCTOR.matcher(tokens).find() || CS_SET_CREATE.matcher(tokens).find()) {
                    yield true;
                }
                yield false;
            }
            default -> false;
        };
    }

    private List<Optional<List<IToken>>> extractSetElements(List<IToken> tokens) {
        return DuplicateSetElementCheck.removeCommaFromMultipleSetItems((List<List<IToken>>)(switch (this.context.getLanguage()) {
            case ELanguage.JAVA -> DuplicateSetElementCheck.extractJavaSetElements(tokens);
            case ELanguage.JAVASCRIPT -> DuplicateSetElementCheck.extractJavaScriptSetElements(tokens);
            case ELanguage.KOTLIN -> DuplicateSetElementCheck.extractKotlinSetElement(tokens);
            case ELanguage.PYTHON -> DuplicateSetElementCheck.extractPythonSetElements(tokens);
            case ELanguage.SWIFT -> DuplicateSetElementCheck.extractSwiftSetElements(tokens);
            case ELanguage.CPP, ELanguage.CPP_MS_CLI -> DuplicateSetElementCheck.extractCPPSetElements(tokens);
            case ELanguage.CS -> DuplicateSetElementCheck.extractCSSetElement(tokens);
            default -> CollectionUtils.emptyList();
        }));
    }

    private static Set<IToken> getDuplicateSetElements(List<IToken> tokens) {
        HashSet<IToken> duplicateElements = new HashSet<IToken>();
        HashSet<Integer> duplicateElementIndices = new HashSet<Integer>();
        for (int i = 0; i < tokens.size() - 1; ++i) {
            if (duplicateElementIndices.contains(i)) continue;
            IToken token = tokens.get(i);
            String tokenText = token.getText();
            for (int j = i + 1; j < tokens.size(); ++j) {
                if (tokenText == null || !tokenText.equals(tokens.get(j).getText())) continue;
                duplicateElements.add(token);
                duplicateElementIndices.add(j);
            }
        }
        return duplicateElements;
    }

    private static List<List<IToken>> extractSetsOfElements(List<IToken> tokens, TokenTypePattern matchRegex, int offsetStart, int offsetEnd, ETokenType leftBracket, ETokenType rightBracket) {
        Optional<List<IToken>> output;
        ArrayList<List<IToken>> multipleMatches = new ArrayList<List<IToken>>();
        EnumPatternMatcher setMatcher = matchRegex.matcher(tokens);
        while (setMatcher.find() && !(output = DuplicateSetElementCheck.getSetsBetweenBrackets(tokens, setMatcher.start(), offsetStart, offsetEnd, leftBracket, rightBracket)).isEmpty()) {
            multipleMatches.add(output.get());
        }
        return multipleMatches;
    }

    private static List<List<IToken>> extractSingleLineSetElements(List<IToken> tokens, ETokenType opening, ETokenType closing) {
        Optional<List<IToken>> resultOfExtraction = DuplicateSetElementCheck.getSetsBetweenBrackets(tokens, TokenStreamUtils.firstTokenOfTypeSequence(tokens, (int)0, (ETokenType[])new ETokenType[]{ETokenType.EQ, opening}), 2, 0, opening, closing);
        return resultOfExtraction.map(Collections::singletonList).orElseGet(CollectionUtils::emptyList);
    }

    private static Optional<List<IToken>> getSetsBetweenBrackets(List<IToken> tokens, int matchingIndex, int offsetStart, int offsetEnd, ETokenType leftBracket, ETokenType rightBracket) {
        int foundIndex = matchingIndex + offsetStart;
        int closingParenthesesIndex = TokenStreamUtils.findMatchingClosingToken(tokens, (int)foundIndex, (ETokenType)leftBracket, (ETokenType)rightBracket) + offsetEnd;
        if (closingParenthesesIndex == -1) {
            return Optional.empty();
        }
        return Optional.of(tokens.subList(foundIndex, closingParenthesesIndex));
    }

    private static List<List<IToken>> extractJavaSetElements(List<IToken> tokens) {
        return DuplicateSetElementCheck.extractSetsOfElements(tokens, JAVA_SET_OF_CALL, 4, 0, ETokenType.LPAREN, ETokenType.RPAREN);
    }

    private static List<List<IToken>> extractJavaScriptSetElements(List<IToken> tokens) {
        return DuplicateSetElementCheck.extractSetsOfElements(tokens, JAVASCRIPT_NEW_SET_CONSTRUCTOR, 4, -1, ETokenType.LPAREN, ETokenType.RPAREN);
    }

    private static List<List<IToken>> extractCSSetElement(List<IToken> tokens) {
        List<List<IToken>> parenOutput = DuplicateSetElementCheck.extractSetsOfElements(tokens, CS_SET_CREATE, 4, 0, ETokenType.LPAREN, ETokenType.RPAREN);
        List<List<IToken>> brackOutput = DuplicateSetElementCheck.extractSetsOfElements(tokens, CS_SET_CONSTRUCTOR, 6, 0, ETokenType.LBRACE, ETokenType.RBRACE);
        return Stream.concat(brackOutput.stream(), parenOutput.stream()).toList();
    }

    private static List<List<IToken>> extractKotlinSetElement(List<IToken> tokens) {
        return DuplicateSetElementCheck.extractSetsOfElements(tokens, KOTLIN_SET_OF, 2, 0, ETokenType.LPAREN, ETokenType.RPAREN);
    }

    private static List<List<IToken>> extractPythonSetElements(List<IToken> tokens) {
        List<List<IToken>> brackOutput = DuplicateSetElementCheck.extractSetsOfElements(tokens, PYTHON_SET_WITH_BRACK_CONSTRUCTOR, 3, 0, ETokenType.LBRACK, ETokenType.RBRACK);
        List<List<IToken>> parenOutput = DuplicateSetElementCheck.extractSetsOfElements(tokens, PYTHON_SET_WITH_PAREN_CONSTRUCTOR, 3, 0, ETokenType.LPAREN, ETokenType.RPAREN);
        List<List<IToken>> bracesOutput = DuplicateSetElementCheck.extractSetsOfElements(tokens, PYTHON_BRACES_CONSTRUCTOR, 1, 0, ETokenType.LBRACE, ETokenType.RBRACE);
        return Stream.concat(brackOutput.stream(), Stream.concat(parenOutput.stream(), bracesOutput.stream())).toList();
    }

    private static List<List<IToken>> extractCPPSetElements(List<IToken> tokens) {
        return DuplicateSetElementCheck.extractSingleLineSetElements(tokens, ETokenType.LBRACE, ETokenType.RBRACE);
    }

    private static List<List<IToken>> extractSwiftSetElements(List<IToken> tokens) {
        return DuplicateSetElementCheck.extractSingleLineSetElements(tokens, ETokenType.LBRACK, ETokenType.RBRACK);
    }

    private static Optional<List<IToken>> removeCommaFromSetItems(List<IToken> setElements) {
        if (setElements.isEmpty()) {
            return Optional.empty();
        }
        int lengthWithComma = setElements.size();
        setElements = setElements.stream().filter(token -> token.getType() != ETokenType.COMMA).toList();
        ETokenType setElementTypes = setElements.get(0).getType();
        if (setElements.size() == lengthWithComma / 2 + 1 && setElements.stream().allMatch(token -> token.getType() == setElementTypes || token.getLanguage() == ELanguage.KOTLIN)) {
            return Optional.of(setElements);
        }
        return Optional.empty();
    }

    private static List<Optional<List<IToken>>> removeCommaFromMultipleSetItems(List<List<IToken>> listOfSetElements) {
        if (listOfSetElements.isEmpty()) {
            return CollectionUtils.emptyList();
        }
        ArrayList<Optional<List<IToken>>> output = new ArrayList<Optional<List<IToken>>>();
        for (List<IToken> element : listOfSetElements) {
            output.add(DuplicateSetElementCheck.removeCommaFromSetItems(element));
        }
        return output;
    }
}

