/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.hana_views;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.option.CheckOption;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.xml.AttributeRegexCheckBase;
import java.util.regex.Pattern;

@Check(id="cqse-restricted-measures-prefix", languages={ELanguage.HANA_VIEW})
public class RestrictedMeasuresPrefixCheck
extends AttributeRegexCheckBase {
    private static final String CHECK_NAME = "Prefix for restricted measures";
    @CheckOption(name="Prefix for restricted measures - required prefix", description="Prefix required for restricted measures.")
    private String prefix = "RM_";

    public RestrictedMeasuresPrefixCheck() {
        super("restrictedMeasures", "measure", "id");
    }

    @Override
    protected String getFindingsMessage() {
        return "Restricted measure names must start with '" + this.prefix + "'";
    }

    @Override
    protected Pattern getPattern() {
        return RestrictedMeasuresPrefixCheck.getPrefixPattern(this.prefix);
    }

    @Override
    protected boolean showPatternInFindingsMessage() {
        return false;
    }
}

