/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.java;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.core.phase.ECodeViewOption;
import eu.cqse.check.framework.matcher.ITokenMatcher;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import eu.cqse.check.framework.typetracker.ScopedTypeLookup;
import eu.cqse.check.framework.typetracker.TypedVariable;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.UnmodifiableList;

@Check(id="cqse-avoid-calling-equals-or-to-string-on-array", languages={ELanguage.JAVA}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE, ECheckParameter.TYPE_RESOLUTION})
public class AvoidCallingEqualsOrToStringOnArrayCheck
extends CheckImplementationBase {
    private static final Set<String> INVALID_METHOD_CALLS_ON_ARRAY = CollectionUtils.asUnmodifiableHashSet((Object[])new String[]{"equals", "toString"});
    private static final Set<String> VALID_METHOD_CALLS_ON_ARRAY = CollectionUtils.asUnmodifiableHashSet((Object[])new String[]{"length", "getClass", "hashCode", "iterator"});
    private static final Set<String> METHODS_WITH_RETURNTYPE_ARRAY = CollectionUtils.asUnmodifiableHashSet((Object[])new String[]{"copyOf", "copyOfRange", "getStackTrace", "values"});
    private static final Set<String> TYPE_NAMES = CollectionUtils.asUnmodifiableHashSet((Object[])new String[]{"Throwable", "Exception", "Error"});
    private static final String ARRAYS_CLASS_REFERENCE = "Arrays";
    private static final Set<ETokenType> EQUALITY_AND_RELATIONAL_OPERATORS = CollectionUtils.asUnmodifiableHashSet((Object[])new ETokenType[]{ETokenType.EQEQ, ETokenType.NOTEQ, ETokenType.GT, ETokenType.LT, ETokenType.GTEQ, ETokenType.LTEQ});

    public void execute() throws CheckException {
        List statements = ShallowEntityTraversalUtils.listEntitiesOfType((Collection)this.context.getAbstractSyntaxTree(this.getCodeViewOption()), (EShallowEntityType)EShallowEntityType.STATEMENT);
        for (ShallowEntity statement : statements) {
            this.processEntity(statement);
        }
    }

    private void processEntity(ShallowEntity entity) throws CheckException {
        ScopedTypeLookup typeLookup = this.context.getTypeResolution(ECodeViewOption.FILTERED).getTypeLookup(entity);
        UnmodifiableList tokens = entity.ownStartTokens();
        this.checkForDirectCallOnVariableNameOrMember(typeLookup, (List<IToken>)tokens);
        this.checkForDirectCallOnMethod((List<IToken>)tokens);
        if (AvoidCallingEqualsOrToStringOnArrayCheck.isImplicitCallOfToString((List<IToken>)tokens)) {
            this.processImplicitCallOfToString(typeLookup, (List<IToken>)tokens);
        }
    }

    private void checkForDirectCallOnVariableNameOrMember(ScopedTypeLookup typeLookup, List<IToken> tokens) throws CheckException {
        List indices = TokenStreamUtils.firstTokenOfTypeSequences(tokens, (int)0, (ETokenType[])new ETokenType[]{ETokenType.IDENTIFIER, ETokenType.DOT, ETokenType.IDENTIFIER, ETokenType.LPAREN});
        Iterator iterator = indices.iterator();
        while (iterator.hasNext()) {
            int index = (Integer)iterator.next();
            IToken variableNameOrMember = tokens.get(index);
            IToken methodInvocationToken = tokens.get(index + 2);
            if (!INVALID_METHOD_CALLS_ON_ARRAY.contains(methodInvocationToken.getText())) continue;
            this.processVariableNameOrMemberForDirectCall(typeLookup, variableNameOrMember, methodInvocationToken);
        }
    }

    private void processVariableNameOrMemberForDirectCall(ScopedTypeLookup typeLookup, IToken variableNameOrMember, IToken methodInvocationToken) throws CheckException {
        TypedVariable typedVariable = typeLookup.getTypeInfo(variableNameOrMember.getText());
        if (typedVariable != null && typedVariable.getTypeNameWithoutGenericTypeParameter().endsWith("[]")) {
            this.buildFinding("Direct call of `" + methodInvocationToken.getText() + "()` on array is likely a bug", this.buildLocation().forToken(methodInvocationToken)).createAndStore();
        }
    }

    private void checkForDirectCallOnMethod(List<IToken> tokens) throws CheckException {
        List indices = TokenStreamUtils.firstTokenOfTypeSequences(tokens, (int)1, (ETokenType[])new ETokenType[]{ETokenType.DOT, ETokenType.IDENTIFIER, ETokenType.LPAREN});
        Iterator iterator = indices.iterator();
        while (iterator.hasNext()) {
            int index = (Integer)iterator.next();
            IToken methodInvocationToken = tokens.get(index + 1);
            if (!METHODS_WITH_RETURNTYPE_ARRAY.contains(methodInvocationToken.getText()) || AvoidCallingEqualsOrToStringOnArrayCheck.isSurroundedWithToStringOrModified(tokens, index - 1)) continue;
            IToken classReferenceOrTypeName = tokens.get(index - 1);
            int indexOfSucceedingMethodCall = TokenStreamUtils.firstTokenOfTypeSequence(tokens, (int)(index + 1), (ETokenType[])new ETokenType[]{ETokenType.DOT, ETokenType.IDENTIFIER, ETokenType.LPAREN});
            IToken succeedingMethodInvocationToken = tokens.get(indexOfSucceedingMethodCall + 1);
            if (!INVALID_METHOD_CALLS_ON_ARRAY.contains(succeedingMethodInvocationToken.getText())) continue;
            this.processMethodCallForDirectCall(methodInvocationToken, succeedingMethodInvocationToken, classReferenceOrTypeName);
        }
    }

    private static boolean isSurroundedWithToStringOrModified(List<IToken> tokens, int arrayTokenIndex) {
        return arrayTokenIndex > 1 && (TokenStreamUtils.containsSequence(tokens, (int)(arrayTokenIndex - 2), (int)arrayTokenIndex, (ITokenMatcher[])new ITokenMatcher[]{ETokenType.IDENTIFIER, ETokenType.LPAREN}) || METHODS_WITH_RETURNTYPE_ARRAY.contains(tokens.get(arrayTokenIndex - 2).getText()));
    }

    private void processMethodCallForDirectCall(IToken methodInvocationToken, IToken succeedingMethodInvocationToken, IToken classReferenceOrTypeName) throws CheckException {
        if (AvoidCallingEqualsOrToStringOnArrayCheck.isOfTypeThrowableOrSubclass(classReferenceOrTypeName.getText()) || AvoidCallingEqualsOrToStringOnArrayCheck.isStaticArraysCall(classReferenceOrTypeName.getText()) || AvoidCallingEqualsOrToStringOnArrayCheck.isEnum(classReferenceOrTypeName.getText())) {
            this.buildFinding("Direct call of `" + succeedingMethodInvocationToken.getText() + "()` on array returned by call to '" + classReferenceOrTypeName.getText() + methodInvocationToken.getText() + "()' is likely a bug", this.buildLocation().forToken(succeedingMethodInvocationToken)).createAndStore();
        }
    }

    private static boolean isOfTypeThrowableOrSubclass(String typeName) {
        for (String keyword : TYPE_NAMES) {
            if (!typeName.endsWith(keyword)) continue;
            return true;
        }
        return false;
    }

    private static boolean isStaticArraysCall(String typeName) {
        return typeName.equals(ARRAYS_CLASS_REFERENCE);
    }

    private static boolean isEnum(String typeName) {
        return typeName.length() > 1 && Character.isUpperCase(typeName.charAt(1));
    }

    private void processImplicitCallOfToString(ScopedTypeLookup typeLookup, List<IToken> tokens) throws CheckException {
        if (TokenStreamUtils.contains(tokens, (ETokenType)ETokenType.EQ)) {
            List tokensAfterEq = TokenStreamUtils.tokensBetween(tokens, (ETokenType)ETokenType.EQ, (ETokenType)ETokenType.SEMICOLON);
            this.checksForUseOfMethod(typeLookup, tokensAfterEq);
        } else if (TokenStreamUtils.contains(tokens, (ETokenType)ETokenType.RETURN)) {
            List tokensAfterReturn = TokenStreamUtils.tokensBetween(tokens, (ETokenType)ETokenType.RETURN, (ETokenType)ETokenType.SEMICOLON);
            this.checksForUseOfMethod(typeLookup, tokensAfterReturn);
        } else {
            int end;
            int start = TokenStreamUtils.firstTokenMatching(tokens, (ITokenMatcher)ETokenType.LPAREN);
            while (start != -1 && (end = TokenStreamUtils.findMatchingClosingToken(tokens, (int)(start + 1), (ETokenType)ETokenType.LPAREN, (ETokenType)ETokenType.RPAREN)) != -1) {
                List<IToken> methodParameterTokens = tokens.subList(start + 1, end);
                if (!methodParameterTokens.isEmpty()) {
                    this.checkParametersOfMethod(typeLookup, methodParameterTokens);
                }
                start = TokenStreamUtils.firstTokenMatching(tokens, (int)(end + 1), (ITokenMatcher)ETokenType.LPAREN);
            }
        }
    }

    private void checksForUseOfMethod(ScopedTypeLookup typeLookup, List<IToken> tokensAfterEqualsOrReturn) throws CheckException {
        List indices = TokenStreamUtils.firstTokenOfTypeSequences(tokensAfterEqualsOrReturn, (int)0, (ETokenType[])new ETokenType[]{ETokenType.IDENTIFIER, ETokenType.LPAREN});
        boolean isNoMethodCall = false;
        int lastIndex = 0;
        for (int i = 0; i < indices.size(); ++i) {
            int matchingClosingToken = TokenStreamUtils.findMatchingClosingToken(tokensAfterEqualsOrReturn, (int)((Integer)indices.get(i) + 2), (ETokenType)ETokenType.LPAREN, (ETokenType)ETokenType.RPAREN);
            if (matchingClosingToken == -1) continue;
            if (TokenStreamUtils.containsSequence(tokensAfterEqualsOrReturn, (int)lastIndex, (int)((Integer)indices.get(i)), (ITokenMatcher[])new ITokenMatcher[]{ETokenType.STRING_LITERAL, ETokenType.PLUS}) || i < indices.size() - 1 && i != 0 && TokenStreamUtils.containsSequence(tokensAfterEqualsOrReturn, (int)matchingClosingToken, (int)((Integer)indices.get(i + 1)), (ITokenMatcher[])new ITokenMatcher[]{ETokenType.PLUS, ETokenType.STRING_LITERAL})) {
                isNoMethodCall = true;
                break;
            }
            List<IToken> methodParameterTokens = tokensAfterEqualsOrReturn.subList((Integer)indices.get(i) + 2, matchingClosingToken);
            this.checkParametersOfMethod(typeLookup, methodParameterTokens);
            lastIndex = matchingClosingToken;
        }
        if (isNoMethodCall || indices.isEmpty()) {
            this.processVariableNameOrMemberForImplicitCall(typeLookup, tokensAfterEqualsOrReturn);
            this.processMethodCallForImplicitCall(typeLookup, tokensAfterEqualsOrReturn);
        }
    }

    private void checkParametersOfMethod(ScopedTypeLookup typeLookup, List<IToken> tokens) throws CheckException {
        List splittedTokensWithinMethod = TokenStreamUtils.splitWithNesting(tokens, (ETokenType)ETokenType.COMMA, (ETokenType)ETokenType.LPAREN, (ETokenType)ETokenType.RPAREN);
        for (List currentList : splittedTokensWithinMethod) {
            if (!AvoidCallingEqualsOrToStringOnArrayCheck.isImplicitCallOfToString(currentList)) continue;
            this.processVariableNameOrMemberForImplicitCall(typeLookup, currentList);
            this.processMethodCallForImplicitCall(typeLookup, currentList);
        }
    }

    private void processVariableNameOrMemberForImplicitCall(ScopedTypeLookup typeLookup, List<IToken> tokens) throws CheckException {
        for (int tokenIndex = 0; tokenIndex < tokens.size(); ++tokenIndex) {
            TypedVariable typedVariable = typeLookup.getTypeInfo(tokens.get(tokenIndex).getText());
            if (typedVariable == null || !typedVariable.getTypeNameWithoutGenericTypeParameter().endsWith("[]")) continue;
            int nedOfNestedMethodCallIndex = this.checkNestedMethodCall(typeLookup, tokens, tokenIndex);
            if (nedOfNestedMethodCallIndex != tokenIndex) {
                tokenIndex = nedOfNestedMethodCallIndex;
                continue;
            }
            if (AvoidCallingEqualsOrToStringOnArrayCheck.isSingleElement(tokens, tokenIndex) && tokenIndex != tokens.size() - 1) continue;
            this.buildFinding("Implicit call to `toString()` on array `" + typedVariable.getVariableName() + "` is likely a bug", this.buildLocation().forToken(tokens.get(tokenIndex))).createAndStore();
        }
    }

    private int checkNestedMethodCall(ScopedTypeLookup typeLookup, List<IToken> tokens, int arrayTokenIndex) throws CheckException {
        Pair<Integer, Integer> methodCallParentheses = AvoidCallingEqualsOrToStringOnArrayCheck.getSurroundingMethodCall(tokens, arrayTokenIndex);
        if ((Integer)methodCallParentheses.getSecond() > 0) {
            this.checkParametersOfMethod(typeLookup, tokens.subList((Integer)methodCallParentheses.getFirst() + 1, (Integer)methodCallParentheses.getSecond()));
            return (Integer)methodCallParentheses.getSecond();
        }
        return arrayTokenIndex;
    }

    private static Pair<Integer, Integer> getSurroundingMethodCall(List<IToken> tokens, int arrayTokenIndex) {
        int openBracketIndex = 0;
        int closingBracketIndex = 0;
        List openings = TokenStreamUtils.firstTokenOfTypeSequences(tokens, (int)0, (ETokenType[])new ETokenType[]{ETokenType.IDENTIFIER, ETokenType.LPAREN});
        Iterator iterator = openings.iterator();
        while (iterator.hasNext()) {
            int opening = (Integer)iterator.next();
            int closing = TokenStreamUtils.findMatchingClosingToken(tokens, (int)(opening + 2), (ETokenType)ETokenType.LPAREN, (ETokenType)ETokenType.RPAREN);
            if (opening >= arrayTokenIndex || closing <= arrayTokenIndex) continue;
            openBracketIndex = opening + 1;
            closingBracketIndex = closing;
        }
        return new Pair((Object)openBracketIndex, (Object)closingBracketIndex);
    }

    private static boolean isSingleElement(List<IToken> tokens, int arrayTokenIndex) {
        if (arrayTokenIndex + 5 < tokens.size() && tokens.get(arrayTokenIndex + 3).getType() == ETokenType.LPAREN) {
            arrayTokenIndex = TokenStreamUtils.findMatchingClosingToken(tokens, (int)(arrayTokenIndex + 4), (ETokenType)ETokenType.LPAREN, (ETokenType)ETokenType.RPAREN);
        }
        if (arrayTokenIndex < tokens.size() - 2 && (VALID_METHOD_CALLS_ON_ARRAY.contains(tokens.get(arrayTokenIndex + 2).getText()) || tokens.get(arrayTokenIndex + 2).getText().equals("toString") || EQUALITY_AND_RELATIONAL_OPERATORS.contains(tokens.get(arrayTokenIndex + 1).getType()))) {
            return true;
        }
        return arrayTokenIndex < tokens.size() - 1 && tokens.get(arrayTokenIndex + 1).getType() == ETokenType.LBRACK;
    }

    private void processMethodCallForImplicitCall(ScopedTypeLookup typeLookup, List<IToken> tokens) throws CheckException {
        for (int tokenIndex = 0; tokenIndex < tokens.size() - 2; ++tokenIndex) {
            IToken variableNameOrMember = tokens.get(tokenIndex);
            IToken methodInvocationToken = tokens.get(tokenIndex + 2);
            TypedVariable typedVariable = typeLookup.getTypeInfo(variableNameOrMember.getText());
            String typeName = AvoidCallingEqualsOrToStringOnArrayCheck.deriveTypeName(typedVariable, variableNameOrMember);
            if (AvoidCallingEqualsOrToStringOnArrayCheck.isArrayAccessor(tokenIndex, tokens).booleanValue() || (!AvoidCallingEqualsOrToStringOnArrayCheck.isOfTypeThrowableOrSubclass(typeName) || !AvoidCallingEqualsOrToStringOnArrayCheck.isStaticArraysCall(typeName) || !AvoidCallingEqualsOrToStringOnArrayCheck.isEnum(typeName)) && (typedVariable == null && !typeName.equals(ARRAYS_CLASS_REFERENCE) || !METHODS_WITH_RETURNTYPE_ARRAY.contains(methodInvocationToken.getText()) || !AvoidCallingEqualsOrToStringOnArrayCheck.isMethod(typeLookup, methodInvocationToken))) continue;
            int endOfNestedMethodCallIndex = this.checkNestedMethodCall(typeLookup, tokens, tokenIndex);
            if (endOfNestedMethodCallIndex != tokenIndex) {
                tokenIndex = endOfNestedMethodCallIndex;
                continue;
            }
            if (AvoidCallingEqualsOrToStringOnArrayCheck.isSingleElement(tokens, tokenIndex) && tokenIndex != tokens.size() - 1) continue;
            this.buildFinding("Implicit call to `toString()` on array returned by call to '" + variableNameOrMember.getText() + "." + methodInvocationToken.getText() + "()' is likely a bug", this.buildLocation().forToken(methodInvocationToken)).createAndStore();
        }
    }

    private static String deriveTypeName(TypedVariable typedVariable, IToken variableNameOrMember) {
        if (typedVariable != null) {
            return typedVariable.getTypeNameWithoutGenericTypeParameter();
        }
        return variableNameOrMember.getText();
    }

    private static Boolean isArrayAccessor(int tokenIndex, List<IToken> tokens) {
        return tokenIndex < tokens.size() - 3 && tokens.get(tokenIndex + 3).getType() == ETokenType.LBRACK;
    }

    private static boolean isMethod(ScopedTypeLookup typeLookup, IToken methodInvocationTokenText) {
        return typeLookup.getTypeInfo(methodInvocationTokenText.getText()) == null;
    }

    private static boolean isImplicitCallOfToString(List<IToken> tokens) {
        return TokenStreamUtils.containsAll(tokens, (ETokenType[])new ETokenType[]{ETokenType.STRING_LITERAL, ETokenType.PLUS});
    }
}

