/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.java;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import eu.cqse.check.framework.util.LanguageFeatureParser;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.conqat.lib.commons.string.StringUtils;

@Check(id="cqse-collections-return-null", languages={ELanguage.JAVA}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class CollectionsReturnNullCheck
extends CheckImplementationBase {
    private static final String[] COLLECTION_CLASS_NAMES = new String[]{"AbstractCollection", "AbstractList", "AbstractQueue", "AbstractSequentialList", "AbstractSet", "ArrayBlockingQueue", "ArrayDeque", "ArrayList", "AttributeList", "BeanContextServicesSupport", "BeanContextSupport", "ConcurrentLinkedDeque", "ConcurrentLinkedQueue", "ConcurrentSkipListSet", "CopyOnWriteArrayList", "CopyOnWriteArraySet", "DelayQueue", "EnumSet", "HashSet", "JobStateReasons", "LinkedBlockingDeque", "LinkedBlockingQueue", "LinkedHashSet", "LinkedList", "LinkedTransferQueue", "PriorityBlockingQueue", "PriorityQueue", "RoleList", "RoleUnresolvedList", "Stack", "SynchronousQueue", "TreeSet", "Vector", "BeanContext", "BeanContextServices", "BlockingDeque", "BlockingQueue", "Deque", "List", "NavigableSet", "Queue", "Set", "SortedSet", "TransferQueue", "Collection"};
    private static final Set<String> EXCLUDED_SUBTYPES = Set.of("constructor", "static initializer", "non-static initializer", "lambda");

    public void execute() throws CheckException {
        List methods = ShallowEntityTraversalUtils.listEntitiesOfType((Collection)this.context.getAbstractSyntaxTree(this.getCodeViewOption()), (EShallowEntityType)EShallowEntityType.METHOD);
        for (ShallowEntity method : methods) {
            if (EXCLUDED_SUBTYPES.contains(method.getSubtype())) continue;
            this.processEntity(method);
        }
    }

    private void processEntity(ShallowEntity entity) throws CheckException {
        String returnType = LanguageFeatureParser.JAVA.getDetailedReturnType(entity);
        if (!returnType.contains("[") && !StringUtils.startsWithOneOf((String)returnType, (String[])COLLECTION_CLASS_NAMES)) {
            return;
        }
        List returnStatements = CollectionsReturnNullCheck.select((ShallowEntity)entity, (String)"STATEMENT[name-matches('return')]");
        for (ShallowEntity statement : returnStatements) {
            UnmodifiableList statementTokens = statement.includedTokens();
            if (statementTokens.size() != 3 || !((IToken)statementTokens.get(1)).getText().equals("null")) continue;
            this.buildFinding("Method '" + entity.getName() + "' returns null instead of empty collection", this.buildLocation().forEntity(statement)).createAndStore();
        }
    }
}

