/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.java;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import java.util.HashMap;
import java.util.List;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.conqat.lib.commons.markup.MarkupUtils;

@Check(id="cqse-static-variables-init", languages={ELanguage.JAVA}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class StaticVariablesInitCheck
extends CheckImplementationBase {
    public void execute() throws CheckException {
        List attributes = this.select("//ATTRIBUTE[modifiers('static') and not(anymodifier('protected', 'private') or tokens('eq'))]");
        HashMap<String, ShallowEntity> missingInit = new HashMap<String, ShallowEntity>();
        for (ShallowEntity attribute : attributes) {
            missingInit.put(attribute.getName(), attribute);
        }
        List sinitStatements = this.select("//METHOD[subtype('static initializer')]//*");
        for (ShallowEntity statement : sinitStatements) {
            if (!missingInit.containsKey(statement.getName())) continue;
            UnmodifiableList tokens = statement.ownStartTokens();
            if (!TokenStreamUtils.containsAny((List)tokens, (ETokenType[])new ETokenType[]{ETokenType.EQ})) continue;
            missingInit.remove(statement.getName());
        }
        for (ShallowEntity entity : missingInit.values()) {
            this.buildFinding("Static variable " + MarkupUtils.formatAsSourceCode((String)entity.getName()) + " is not initialized", this.buildLocation().forEntity(entity)).createAndStore();
        }
    }
}

