/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.simulink.matlab;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.FindingPropertyList;
import eu.cqse.check.framework.core.option.CheckOption;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import eu.cqse.check.simulink.LocalCodeSnippetParser;
import eu.cqse.check.simulink.matlab.SimulinkMatlabCheckUtils;
import java.util.HashSet;
import java.util.List;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.engine.commons.findings.location.QualifiedNameLocation;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.conqat.lib.simulink.model.SimulinkBlock;
import org.conqat.lib.simulink.model.SimulinkModel;
import org.conqat.lib.simulink.model.stateflow.StateflowNodeBase;
import org.conqat.lib.simulink.model.stateflow.StateflowState;
import org.conqat.lib.simulink.util.StateflowUtils;

@Check(id="cqse.maab.na_0016", languages={ELanguage.SIMULINK})
public class SimulinkMatlabFunctionBlockLengthCheck
extends CheckImplementationBase {
    private static final FindingPropertyList RECOMMENDED_ACTION = FindingPropertyList.singleton((String)"Recommended Action", (String)"Further divide the MATLAB Function into sub functions.");
    @CheckOption(name="Maximum source lines of code per function", description="The maximum number of lines per function in a Matlab Function block. This does not include empty lines, comment lines, or lines with a function end keyword.")
    private int maximumFunctionLength = 60;
    private final LocalCodeSnippetParser matlabParser = new LocalCodeSnippetParser(ELanguage.MATLAB);

    public void execute() throws CheckException {
        SimulinkModel model = this.context.getSimulinkContext().getSimulinkModelForModelFile().orElse(null);
        if (model == null) {
            return;
        }
        for (SimulinkBlock block : SimulinkMatlabCheckUtils.listMatlabFunctionBlocks(model)) {
            for (String script : StateflowUtils.extractMatlabScriptsFromBlock((SimulinkBlock)block)) {
                this.checkMatlabScriptSLOC(script, this.context.buildLocation().forSimulinkBlock(block));
            }
        }
        for (StateflowState stateflowMatlabFunctionState : StateflowUtils.getStateflowMatlabFunctions((SimulinkModel)model)) {
            String script = StateflowUtils.extractMatlabScriptFromStateflowState((StateflowState)stateflowMatlabFunctionState);
            this.checkMatlabScriptSLOC(script, this.context.buildLocation().forStateflowNode((StateflowNodeBase)stateflowMatlabFunctionState));
        }
    }

    private void checkMatlabScriptSLOC(String script, QualifiedNameLocation findingLocation) {
        List<ShallowEntity> entities = this.matlabParser.parseTopLevel(script, this.context.getUniformPath());
        for (ShallowEntity method : ShallowEntityTraversalUtils.listEntitiesOfType(entities, (EShallowEntityType)EShallowEntityType.METHOD)) {
            int methodLength = SimulinkMatlabFunctionBlockLengthCheck.countMatlabSLOC(method);
            if (methodLength <= this.maximumFunctionLength) continue;
            this.buildFinding("Function " + method.getName() + " is too long (" + methodLength + " source lines)", (ElementLocation)findingLocation).addFindingProperties(RECOMMENDED_ACTION).createAndStore();
        }
    }

    private static int countMatlabSLOC(ShallowEntity method) {
        UnmodifiableList methodTokens = method.includedTokens();
        HashSet<Integer> codeLines = new HashSet<Integer>();
        for (IToken token : methodTokens) {
            int lineNumber = token.getLineNumber();
            ETokenType type = token.getType();
            if (type == ETokenType.COMMENT || type == ETokenType.END || type == ETokenType.EOL) continue;
            codeLines.add(lineNumber);
        }
        return codeLines.size();
    }
}

