/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.simulink.simulink;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.FindingPropertyList;
import eu.cqse.check.framework.core.option.CheckOption;
import eu.cqse.check.framework.scanner.ELanguage;
import java.util.Set;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.lib.simulink.model.SimulinkBlock;
import org.conqat.lib.simulink.model.SimulinkModel;
import org.conqat.lib.simulink.model.datahandler.simulink.SimulinkBlockNameUtils;
import org.conqat.lib.simulink.model.stateflow.StateflowBlock;
import org.conqat.lib.simulink.model.stateflow.StateflowChart;
import org.conqat.lib.simulink.util.SimulinkUtils;
import org.conqat.lib.simulink.util.StateflowUtils;

@Check(id="cqse.jmaab.db_0112", languages={ELanguage.SIMULINK})
public class SimulinkConsistentIndexingCheck
extends CheckImplementationBase {
    private static final String FINDING_MESSAGE_USE_ZERO_BASED_INDEXING = "This block shall use zero-based indexing, but uses one-based indexing";
    private static final String FINDING_MESSAGE_USE_ONE_BASED_INDEXING = "This block shall use one-based indexing, but uses zero-based indexing";
    private static final FindingPropertyList RECOMMENDED_ACTION_USE_ONE_BASED_INDEXING = FindingPropertyList.singleton((String)"Recommended Action", (String)"Configure this block to use one-based indexing.");
    private static final FindingPropertyList RECOMMENDED_ACTION_USE_ZERO_BASED_INDEXING = FindingPropertyList.singleton((String)"Recommended Action", (String)"Configure this block to use zero-based indexing.");
    @CheckOption(name="Check zero-based indexing", description="If this option is set, all blocks that use one-based indexing will be reported. Otherwise, all blocks using zero-based indexing will be reported.")
    private boolean checkZeroBasedIndexing = true;
    @CheckOption(name="Blocks enforcing one based indexing", description="These blocks enforce one based indexing by default.")
    private Set<String> blocksWithOneBasedIndexing = Set.of("MATLAB Function", "Fcn", "MATLABSystem", "Truth Table", "State Transition Table", "Test Sequence");
    @CheckOption(name="Blocks excluded from indexing check", description="These blocks are excluded from this check.")
    private Set<String> blocksExcludedFromIndexCheck = Set.of("ForEach");

    public void execute() {
        SimulinkModel model = this.context.getSimulinkContext().getSimulinkModelForModelFile().orElse(null);
        if (model == null) {
            return;
        }
        for (SimulinkBlock block : SimulinkUtils.listBlocksDepthFirst((SimulinkBlock)model, (boolean)false, (boolean)false)) {
            this.check(block);
        }
    }

    private void check(SimulinkBlock block) {
        if (this.isExcluded(block)) {
            return;
        }
        String indexMode = this.getIndexMode(block);
        if (indexMode == null) {
            return;
        }
        if (this.checkZeroBasedIndexing) {
            if (!SimulinkConsistentIndexingCheck.isZeroBased(indexMode)) {
                this.buildFinding(FINDING_MESSAGE_USE_ZERO_BASED_INDEXING, (ElementLocation)this.buildLocation().forSimulinkBlock(block)).addFindingProperties(RECOMMENDED_ACTION_USE_ZERO_BASED_INDEXING).createAndStore();
            }
        } else if (SimulinkConsistentIndexingCheck.isZeroBased(indexMode)) {
            this.buildFinding(FINDING_MESSAGE_USE_ONE_BASED_INDEXING, (ElementLocation)this.buildLocation().forSimulinkBlock(block)).addFindingProperties(RECOMMENDED_ACTION_USE_ONE_BASED_INDEXING).createAndStore();
        }
    }

    private boolean isExcluded(SimulinkBlock block) {
        if (this.blocksExcludedFromIndexCheck.contains(block.getType())) {
            return true;
        }
        String sourceType = block.getSourceType();
        return sourceType != null && this.blocksExcludedFromIndexCheck.contains(sourceType);
    }

    private static boolean isZeroBased(String indexMode) {
        return "Zero-based".equals(indexMode) || "Zero-based contiguous".equals(indexMode);
    }

    private boolean blockNeedsOneBasedIndexing(SimulinkBlock block) {
        String blockTypeOrSourceTypeOrStateflowType = SimulinkBlockNameUtils.getTypeOrSourceTypeOrStateflowType((SimulinkBlock)block);
        if (blockTypeOrSourceTypeOrStateflowType == null) {
            return false;
        }
        if (this.blocksWithOneBasedIndexing.contains(blockTypeOrSourceTypeOrStateflowType)) {
            return true;
        }
        if (!(block instanceof StateflowBlock)) {
            return false;
        }
        StateflowBlock stateflowBlock = (StateflowBlock)block;
        return !StateflowUtils.hasActionLanguageC((StateflowChart)stateflowBlock.getChart());
    }

    private String getIndexMode(SimulinkBlock block) {
        String indexMode = block.getParameter("IndexMode");
        if (indexMode != null) {
            return indexMode;
        }
        String dataPortOrder = block.getParameter("DataPortOrder");
        if (dataPortOrder != null) {
            return dataPortOrder;
        }
        if (this.blockNeedsOneBasedIndexing(block)) {
            return "One-based contiguous";
        }
        if (SimulinkConsistentIndexingCheck.blockNeedsZeroBasedIndexing(block)) {
            return "Zero-based";
        }
        return null;
    }

    private static boolean blockNeedsZeroBasedIndexing(SimulinkBlock block) {
        if (StateflowUtils.isStateflowChart((SimulinkBlock)block)) {
            StateflowChart chart = ((StateflowBlock)block).getChart();
            return StateflowUtils.hasActionLanguageC((StateflowChart)chart);
        }
        return false;
    }
}

