/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.simulink.stateflow;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.FindingPropertyList;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.scanner.ScannerUtils;
import eu.cqse.check.framework.shallowparser.TokenStreamTextUtils;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.matlab.MatlabActionAstNode;
import eu.cqse.check.matlab.MatlabActionAstUtils;
import eu.cqse.check.matlab.MatlabActionParserException;
import eu.cqse.check.matlab.MatlabActionTypeResolver;
import eu.cqse.check.simulink.simulink.phases.SimulinkCheckFileReferencesResolver;
import eu.cqse.check.simulink.simulink.phases.SimulinkDataDictionaryLoadingPhase;
import eu.cqse.check.simulink.simulink.phases.SimulinkFileReferencesPhase;
import eu.cqse.check.simulink.simulink.phases.SimulinkModelBlockIdListingPhase;
import eu.cqse.check.util.simulink.StateflowCheckUtils;
import eu.cqse.check.util.simulink.StateflowStateAction;
import eu.cqse.check.util.simulink.StateflowTransitionParts;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.engine.commons.findings.location.QualifiedNameLocation;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.markup.MarkupUtils;
import org.conqat.lib.simulink.builder.SimulinkDataDictionary;
import org.conqat.lib.simulink.model.SimulinkBlock;
import org.conqat.lib.simulink.model.SimulinkModel;
import org.conqat.lib.simulink.model.SimulinkResolvedDataTypes;
import org.conqat.lib.simulink.model.stateflow.StateflowBlock;
import org.conqat.lib.simulink.model.stateflow.StateflowChart;
import org.conqat.lib.simulink.model.stateflow.StateflowNodeBase;
import org.conqat.lib.simulink.model.stateflow.StateflowState;
import org.conqat.lib.simulink.model.stateflow.StateflowTransition;
import org.conqat.lib.simulink.types.SimulinkDataTypeUtils;
import org.conqat.lib.simulink.util.SimulinkUtils;
import org.conqat.lib.simulink.util.StateflowUtils;

@Check(id="cqse.maab.jc_0481", languages={ELanguage.SIMULINK}, phases={SimulinkDataDictionaryLoadingPhase.class, SimulinkFileReferencesPhase.class, SimulinkModelBlockIdListingPhase.class})
public class StateflowFloatingPointComparisonCheck
extends CheckImplementationBase {
    private static final FindingPropertyList RECOMMENDED_ACTION = FindingPropertyList.singleton((String)"Recommended Action", (String)"Replace the hard equality comparison by defining a margin error and using it for the comparison.");
    private static final Set<ETokenType> DISALLOWED_FLOAT_COMPARISON_TOKEN_TYPES = CollectionUtils.asHashSet((Object[])new ETokenType[]{ETokenType.EQEQ, ETokenType.NOTEQ});
    private static final Logger LOGGER = LogManager.getLogger();
    private static final String FINDING_MESSAGE_TEMPLATE = "Hard floating-point equality comparison for %s";

    public void execute() {
        SimulinkModel model = this.context.getSimulinkContext().getSimulinkModelForModelFile().orElse(null);
        if (model == null) {
            return;
        }
        List<SimulinkDataDictionary> dataDictionaries = new SimulinkCheckFileReferencesResolver(this.context).getSimulinkDataDictionariesForModel(model, this.context.accessPhaseResult(SimulinkDataDictionaryLoadingPhase.class));
        for (SimulinkBlock block : SimulinkUtils.listBlocksDepthFirst((SimulinkBlock)model, (boolean)false, (boolean)false)) {
            if (!(block instanceof StateflowBlock)) continue;
            StateflowBlock stateflowBlock = (StateflowBlock)block;
            StateflowChart chart = stateflowBlock.getChart();
            SimulinkResolvedDataTypes resolvedDataTypes = this.context.getSimulinkContext().getSimulinkOutputDataTypesForModelFile().orElse(null);
            if (chart == null || resolvedDataTypes == null) {
                return;
            }
            for (StateflowState state : StateflowUtils.listStatesDepthFirst((StateflowChart)chart, (boolean)false)) {
                this.checkStateflowState(chart, state, resolvedDataTypes, dataDictionaries);
            }
            for (StateflowTransition transition : StateflowUtils.getAllTransitions((StateflowChart)chart, (boolean)false)) {
                this.checkStateflowTransition(chart, transition, resolvedDataTypes, dataDictionaries);
            }
        }
    }

    private void checkStateflowState(StateflowChart chart, StateflowState state, SimulinkResolvedDataTypes resolvedDataTypes, List<SimulinkDataDictionary> dataDictionaries) {
        QualifiedNameLocation location = this.buildLocation().forStateflowNode((StateflowNodeBase)state);
        if (StateflowUtils.hasActionLanguageC((StateflowChart)chart)) {
            this.checkScriptForActionLanguageC(chart, StateflowUtils.extractStateActionsFromStateflowLabel((StateflowState)state), location);
        } else {
            for (StateflowStateAction action : StateflowCheckUtils.splitStateActionsFromStateLabel((StateflowState)state)) {
                for (MatlabActionAstNode problematicComparisonNode : this.extractHardFloatingComparisonFromMatlabScriptOfState(action.actionCode, state, resolvedDataTypes, dataDictionaries)) {
                    String message = String.format(FINDING_MESSAGE_TEMPLATE, MarkupUtils.formatAsSourceCode((String)TokenStreamTextUtils.concatTokenTexts((List)problematicComparisonNode.getTokens(), (String)" ")));
                    this.buildFinding(message, (ElementLocation)location).addFindingProperties(RECOMMENDED_ACTION).createAndStore();
                }
            }
        }
    }

    private void checkStateflowTransition(StateflowChart chart, StateflowTransition transition, SimulinkResolvedDataTypes resolvedDataTypes, List<SimulinkDataDictionary> dataDictionaries) {
        String script = transition.getLabel();
        if (script == null) {
            return;
        }
        QualifiedNameLocation location = this.buildLocation().forStateflowTransition(transition);
        if (StateflowUtils.hasActionLanguageC((StateflowChart)chart)) {
            this.checkScriptForActionLanguageC(chart, transition.getLabel(), location);
        } else {
            StateflowTransitionParts transitionParts = StateflowCheckUtils.splitTransitionLabel((StateflowTransition)transition);
            ArrayList<MatlabActionAstNode> problematicComparisons = new ArrayList<MatlabActionAstNode>();
            problematicComparisons.addAll(this.extractHardFloatingComparisonFromMatlabScriptsOfTransition(transitionParts.condition, transition, resolvedDataTypes, dataDictionaries));
            problematicComparisons.addAll(this.extractHardFloatingComparisonFromMatlabScriptsOfTransition(transitionParts.conditionAction, transition, resolvedDataTypes, dataDictionaries));
            problematicComparisons.addAll(this.extractHardFloatingComparisonFromMatlabScriptsOfTransition(transitionParts.transitionAction, transition, resolvedDataTypes, dataDictionaries));
            for (MatlabActionAstNode problematicComparisonNode : problematicComparisons) {
                String message = String.format(FINDING_MESSAGE_TEMPLATE, MarkupUtils.formatAsSourceCode((String)TokenStreamTextUtils.concatTokenTexts((List)problematicComparisonNode.getTokens(), (String)" ")));
                this.buildFinding(message, (ElementLocation)location).addFindingProperties(RECOMMENDED_ACTION).createAndStore();
            }
        }
    }

    private List<MatlabActionAstNode> extractHardFloatingComparisonFromMatlabScriptsOfTransition(List<IToken> tokens, StateflowTransition transition, SimulinkResolvedDataTypes resolvedDataTypes, List<SimulinkDataDictionary> dataDictionaries) {
        if (tokens.isEmpty()) {
            return Collections.emptyList();
        }
        try {
            MatlabActionTypeResolver typeResolver = MatlabActionTypeResolver.from(tokens, (StateflowTransition)transition, (SimulinkResolvedDataTypes)resolvedDataTypes, dataDictionaries);
            return StateflowFloatingPointComparisonCheck.extractHardFloatingComparisonFromMatlabScript(typeResolver);
        }
        catch (MatlabActionParserException e) {
            LOGGER.debug("Could not parse code in " + this.buildLocation().forStateflowTransition(transition).getQualifiedName(), (Throwable)e);
            return Collections.emptyList();
        }
    }

    private List<MatlabActionAstNode> extractHardFloatingComparisonFromMatlabScriptOfState(List<IToken> tokens, StateflowState state, SimulinkResolvedDataTypes resolvedDataTypes, List<SimulinkDataDictionary> dataDictionaries) {
        if (tokens.isEmpty()) {
            return Collections.emptyList();
        }
        try {
            MatlabActionTypeResolver typeResolver = MatlabActionTypeResolver.from(tokens, (StateflowState)state, (SimulinkResolvedDataTypes)resolvedDataTypes, dataDictionaries);
            return StateflowFloatingPointComparisonCheck.extractHardFloatingComparisonFromMatlabScript(typeResolver);
        }
        catch (MatlabActionParserException e) {
            LOGGER.debug("Could not parse code in " + this.buildLocation().forStateflowNode((StateflowNodeBase)state).getQualifiedName(), (Throwable)e);
            return Collections.emptyList();
        }
    }

    private static List<MatlabActionAstNode> extractHardFloatingComparisonFromMatlabScript(MatlabActionTypeResolver typeResolver) {
        ArrayList<MatlabActionAstNode> comparisonNodesWithDisallowedOperands = new ArrayList<MatlabActionAstNode>();
        for (MatlabActionAstNode comparisonNode : MatlabActionAstUtils.listComparisonNodes((MatlabActionAstNode)typeResolver.getRootNode())) {
            MatlabActionAstNode leftNode = (MatlabActionAstNode)comparisonNode.getChildren().get(0);
            MatlabActionAstNode rightNode = (MatlabActionAstNode)comparisonNode.getChildren().get(1);
            List operatorTokens = MatlabActionAstUtils.extractBinaryOperatorTokens((MatlabActionAstNode)comparisonNode);
            if (operatorTokens.isEmpty() || !DISALLOWED_FLOAT_COMPARISON_TOKEN_TYPES.contains(((IToken)operatorTokens.get(0)).getType()) || !StateflowFloatingPointComparisonCheck.hasFloatingPointType(leftNode, typeResolver) && !StateflowFloatingPointComparisonCheck.hasFloatingPointType(rightNode, typeResolver)) continue;
            comparisonNodesWithDisallowedOperands.add(comparisonNode);
        }
        return comparisonNodesWithDisallowedOperands;
    }

    private void checkScriptForActionLanguageC(StateflowChart chart, String code, QualifiedNameLocation findingLocation) {
        List<IToken> problematicComparisonTokens = this.extractTokensWithFloatingPointTypeUsedInHardComparisonFromC(code, chart);
        if (!problematicComparisonTokens.isEmpty()) {
            String message = String.format(FINDING_MESSAGE_TEMPLATE, MarkupUtils.formatAsSourceCode((String)TokenStreamTextUtils.concatTokenTexts(problematicComparisonTokens, (String)" ")));
            this.buildFinding(message, (ElementLocation)findingLocation).addFindingProperties(RECOMMENDED_ACTION).createAndStore();
        }
    }

    private List<IToken> extractTokensWithFloatingPointTypeUsedInHardComparisonFromC(String script, StateflowChart chart) {
        List tokens = ScannerUtils.getTokens((String)script, (ELanguage)ELanguage.CPP, (String)this.context.getUniformPath());
        for (ETokenType disallowedTokenType : DISALLOWED_FLOAT_COMPARISON_TOKEN_TYPES) {
            List disallowedTokenIndices = TokenStreamUtils.firstTokenOfTypeSequences((List)tokens, (int)0, (ETokenType[])new ETokenType[]{disallowedTokenType});
            Iterator iterator = disallowedTokenIndices.iterator();
            while (iterator.hasNext()) {
                List<IToken> comparisonTokens;
                int disallowedTokenIndex = (Integer)iterator.next();
                if (disallowedTokenIndex + 1 >= tokens.size() || disallowedTokenIndex - 1 < 0) continue;
                IToken previousToken = (IToken)tokens.get(disallowedTokenIndex - 1);
                IToken nextToken = (IToken)tokens.get(disallowedTokenIndex + 1);
                if (!StateflowFloatingPointComparisonCheck.isIdentifierOrLiteral(previousToken) || !StateflowFloatingPointComparisonCheck.isIdentifierOrLiteral(nextToken) || !StateflowFloatingPointComparisonCheck.identifiersContainFloatingPointTypes(comparisonTokens = tokens.subList(disallowedTokenIndex - 1, disallowedTokenIndex + 2), chart) && !TokenStreamUtils.contains(comparisonTokens, (ETokenType)ETokenType.FLOATING_POINT_LITERAL)) continue;
                return comparisonTokens;
            }
        }
        return Collections.emptyList();
    }

    private static boolean isIdentifierOrLiteral(IToken token) {
        return token.getType().isIdentifier() || token.getType().isLiteral();
    }

    private static boolean identifiersContainFloatingPointTypes(List<IToken> tokens, StateflowChart chart) {
        HashSet<String> identifierDataTypes = new HashSet<String>();
        for (IToken token : tokens) {
            Optional identifierDataType;
            if (token.getType() != ETokenType.IDENTIFIER || (identifierDataType = StateflowUtils.getDataTypeOfDataName((StateflowChart)chart, (String)token.getText())).isEmpty()) continue;
            identifierDataTypes.add((String)identifierDataType.get());
        }
        return identifierDataTypes.stream().anyMatch(SimulinkDataTypeUtils::isFloatingPointDataType);
    }

    private static boolean hasFloatingPointType(MatlabActionAstNode node, MatlabActionTypeResolver typeResolver) {
        boolean hasInferredFloatingPointType = SimulinkUtils.FLOATING_POINT_TYPES.contains(typeResolver.inferDataTypeOf(node));
        boolean isIntLiteral = node.getTokens().size() == 1 && ((IToken)node.getTokens().get(0)).getType() == ETokenType.INTEGER_LITERAL;
        return hasInferredFloatingPointType && !isIntLiteral;
    }
}

