/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.sqlscript;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.sqlscript.SqlStatementCheckBase;
import eu.cqse.check.sqlscript.sqlstatement.SqlQuery;
import eu.cqse.check.sqlscript.sqlstatement.SqlStatement;
import java.util.EnumSet;

@Check(id="cqse-non-trivial-sub-query", languages={ELanguage.SQLSCRIPT}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class NonTrivialSubQueryCheck
extends SqlStatementCheckBase {
    private static final EnumSet<ETokenType> NON_TRIVIAL_TOKENS = EnumSet.of(ETokenType.WHERE, ETokenType.JOIN, ETokenType.GROUP, ETokenType.HAVING, ETokenType.UNION);

    @Override
    protected void checkSqlStatement(SqlStatement statement) throws CheckException {
        for (SqlQuery subquery : NonTrivialSubQueryCheck.getQueryToCheck(statement).getSubqueries()) {
            if (!subquery.hasSubquery() && !subquery.containsAnyToken(NON_TRIVIAL_TOKENS)) continue;
            this.createFinding("Non-trivial subquery", subquery);
        }
    }

    private static SqlQuery getQueryToCheck(SqlStatement statement) {
        if (statement.isSubqueryTolerant() && statement.getQuery().getSubqueries().size() == 1) {
            return statement.getQuery().getSubqueries().get(0);
        }
        return statement.getQuery();
    }
}

