/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.framework.preprocessor;

import eu.cqse.check.framework.preprocessor.IPreprocessor;
import eu.cqse.check.framework.preprocessor.PreprocessorUtils;
import eu.cqse.check.framework.preprocessor.abap.AbapPreprocessor;
import eu.cqse.check.framework.preprocessor.c.CPreprocessor;
import eu.cqse.check.framework.preprocessor.c.ParsedMacroProvider;
import eu.cqse.check.framework.preprocessor.iec61131.Iec61131Preprocessor;
import eu.cqse.check.framework.preprocessor.swift.SwiftPreprocessor;
import eu.cqse.check.framework.scanner.ELanguage;
import java.util.EnumSet;
import java.util.Optional;
import java.util.Set;

public class PreprocessorFactory {
    public static final Set<ELanguage> C_PREPROCESSOR_LANGUAGES = EnumSet.of(ELanguage.CPP, ELanguage.CPP_MS_CLI, ELanguage.C, ELanguage.OBJECTIVE_C, ELanguage.OBJECTIVE_CPP);

    public static Optional<IPreprocessor> createLocalPreprocessor(ELanguage language) {
        if (!PreprocessorUtils.hasPreprocessor(language)) {
            return Optional.empty();
        }
        switch (language) {
            case ABAP: {
                return Optional.of(new AbapPreprocessor());
            }
            case CPP: 
            case CPP_MS_CLI: 
            case C: 
            case OBJECTIVE_C: 
            case OBJECTIVE_CPP: {
                return Optional.of(new CPreprocessor(new ParsedMacroProvider(), true, true));
            }
            case IEC61131: {
                return Optional.of(new Iec61131Preprocessor());
            }
            case SWIFT: {
                return Optional.of(SwiftPreprocessor.emptyConfigPreprocessor());
            }
        }
        return Optional.empty();
    }
}

