/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.framework.preprocessor.c;

import eu.cqse.check.framework.matcher.ITokenMatcher;
import eu.cqse.check.framework.preprocessor.c.CPreprocessingUtils;
import eu.cqse.check.framework.preprocessor.c.CPreprocessor;
import eu.cqse.check.framework.preprocessor.c.IncludeDirective;
import eu.cqse.check.framework.preprocessor.c.MacroDefinition;
import eu.cqse.check.framework.preprocessor.c.MacroInvocationPreprocessor;
import eu.cqse.check.framework.preprocessor.c.PreprocessorConditionalTokenReplacement;
import eu.cqse.check.framework.preprocessor.c.PreprocessorTokenReplacement;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.scanner.ScannerUtils;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.cache4j.ICache;
import org.conqat.lib.commons.cache4j.SynchronizedCache;
import org.conqat.lib.commons.cache4j.backend.ECachingStrategy;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.error.NeverThrownRuntimeException;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextFactory;
import org.mozilla.javascript.EcmaError;
import org.mozilla.javascript.EvaluatorException;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class IfDirectivePreprocessor {
    private static final ICache<String, Boolean, NeverThrownRuntimeException> EXPRESSION_CACHE = new SynchronizedCache("EXPRESSION_CACHE", IfDirectivePreprocessor::evaluateExpression, ECachingStrategy.LRU.getBackend(5000));
    private static final Map<ETokenType, String> ALTERNATIVE_TOKEN_TEXTS = CollectionUtils.asMap((Pair[])new Pair[]{Pair.createPair((Object)ETokenType.OROR, (Object)"||"), Pair.createPair((Object)ETokenType.ANDAND, (Object)"&&"), Pair.createPair((Object)ETokenType.NOT, (Object)"!"), Pair.createPair((Object)ETokenType.COMP, (Object)"~"), Pair.createPair((Object)ETokenType.NOTEQ, (Object)"!="), Pair.createPair((Object)ETokenType.AND, (Object)"&"), Pair.createPair((Object)ETokenType.OR, (Object)"|"), Pair.createPair((Object)ETokenType.XOR, (Object)"^"), Pair.createPair((Object)ETokenType.ANDEQ, (Object)"&="), Pair.createPair((Object)ETokenType.OREQ, (Object)"|="), Pair.createPair((Object)ETokenType.XOREQ, (Object)"^=")});
    private static final Pattern NUMBER_WITH_SIZE_OR_SIGNEDNESS_PATTERN = Pattern.compile("([0-9])[uUsSlL]{1,2}");
    public static final String HAS_INCLUDE_BUILTIN_FUNCTION = "__has_include";
    public static final String HAS_INCLUDE_NEXT_BUILTIN_FUNCTION = "__has_include_next";
    private static final Pattern NON_ZERO_PATTERN = Pattern.compile("[1-9a-fA-F]");

    public static boolean isIfDirective(IToken token) {
        return IfDirectivePreprocessor.isDirectiveWithNamePrefix(token, "if");
    }

    public static boolean isEndIfDirective(IToken token) {
        return IfDirectivePreprocessor.isDirectiveWithNamePrefix(token, "endif");
    }

    public static boolean isElifDirective(IToken token) {
        return IfDirectivePreprocessor.isDirectiveWithNamePrefix(token, "elif");
    }

    public static boolean isElseDirective(IToken token) {
        return IfDirectivePreprocessor.isDirectiveWithNamePrefix(token, "else");
    }

    public static boolean isConditionalDirective(IToken token) {
        return IfDirectivePreprocessor.isIfDirective(token) || IfDirectivePreprocessor.isElifDirective(token) || IfDirectivePreprocessor.isElseDirective(token) || IfDirectivePreprocessor.isEndIfDirective(token);
    }

    private static boolean isDirectiveWithNamePrefix(IToken token, String directiveNamePrefix) {
        String tokenText = token.getText();
        if (tokenText.charAt(0) != '#') {
            return false;
        }
        int directiveNameBegin = IfDirectivePreprocessor.skipWhitespaces(tokenText, 1);
        return tokenText.regionMatches(directiveNameBegin, directiveNamePrefix, 0, directiveNamePrefix.length());
    }

    private static int skipWhitespaces(String text, int startIndex) {
        int currentIndex;
        for (currentIndex = startIndex; currentIndex < text.length() && Character.isWhitespace(text.charAt(currentIndex)); ++currentIndex) {
        }
        return currentIndex;
    }

    public static PreprocessorTokenReplacement processIfDirective(List<IToken> tokens, int tokenIndex, ConditionalRegionStack conditionalRegionStack, CPreprocessor.FilePreprocessorContext context, CPreprocessor preprocessor, CPreprocessor.IncludedFilesContext includedFiles) throws CPreprocessor.PreprocessorException {
        IToken currentToken = tokens.get(tokenIndex);
        CPreprocessor.PreprocessorUsageInformation preprocessorUsageInformation = new CPreprocessor.PreprocessorUsageInformation();
        if (IfDirectivePreprocessor.isIfDirective(currentToken)) {
            if (IfDirectivePreprocessor.conditionIsTrue(IfDirectivePreprocessor.extractCondition(currentToken), context, preprocessor, preprocessorUsageInformation, includedFiles)) {
                conditionalRegionStack.pushConditionalRegion(currentToken, true);
                return IfDirectivePreprocessor.generateDirectiveRemovalReplacement(tokenIndex, preprocessorUsageInformation, null);
            }
            conditionalRegionStack.pushConditionalRegion(currentToken, false);
            int endIndex = IfDirectivePreprocessor.findIndexOfNextConditionalEnd(tokens, tokenIndex);
            if (endIndex < 0) {
                return PreprocessorTokenReplacement.createSingleTokenRemovalWithError("could not find if directive region end", tokenIndex, preprocessorUsageInformation);
            }
            return new PreprocessorTokenReplacement(Collections.emptyList(), tokenIndex, endIndex, preprocessorUsageInformation);
        }
        if (IfDirectivePreprocessor.isElifDirective(currentToken)) {
            if (conditionalRegionStack.isEmpty()) {
                return IfDirectivePreprocessor.generateUnbalancedIfDirectivesReplacement(tokenIndex, includedFiles, preprocessorUsageInformation);
            }
            Pair<IToken, Boolean> previousRegion = conditionalRegionStack.popConditionalRegion();
            if (((Boolean)previousRegion.getSecond()).booleanValue() || !IfDirectivePreprocessor.conditionIsTrue(IfDirectivePreprocessor.extractCondition(currentToken), context, preprocessor, preprocessorUsageInformation, includedFiles)) {
                conditionalRegionStack.pushConditionalRegion(currentToken, (Boolean)previousRegion.getSecond());
                return IfDirectivePreprocessor.generateRegionRemovalReplacement(tokens, tokenIndex, includedFiles, preprocessorUsageInformation, previousRegion);
            }
            conditionalRegionStack.pushConditionalRegion(currentToken, true);
            return IfDirectivePreprocessor.generateDirectiveRemovalReplacement(tokenIndex, preprocessorUsageInformation, previousRegion);
        }
        if (IfDirectivePreprocessor.isElseDirective(currentToken)) {
            if (conditionalRegionStack.isEmpty()) {
                return IfDirectivePreprocessor.generateUnbalancedIfDirectivesReplacement(tokenIndex, includedFiles, preprocessorUsageInformation);
            }
            Pair<IToken, Boolean> previousRegion = conditionalRegionStack.popConditionalRegion();
            if (((Boolean)previousRegion.getSecond()).booleanValue()) {
                conditionalRegionStack.pushConditionalRegion(currentToken, (Boolean)previousRegion.getSecond());
                return IfDirectivePreprocessor.generateRegionRemovalReplacement(tokens, tokenIndex, includedFiles, preprocessorUsageInformation, previousRegion);
            }
            conditionalRegionStack.pushConditionalRegion(currentToken, true);
            return IfDirectivePreprocessor.generateDirectiveRemovalReplacement(tokenIndex, preprocessorUsageInformation, previousRegion);
        }
        if (IfDirectivePreprocessor.isEndIfDirective(currentToken)) {
            if (conditionalRegionStack.isEmpty()) {
                return IfDirectivePreprocessor.generateUnbalancedIfDirectivesReplacement(tokenIndex, includedFiles, preprocessorUsageInformation);
            }
            Pair<IToken, Boolean> previousRegion = conditionalRegionStack.popConditionalRegion();
            return IfDirectivePreprocessor.generateDirectiveRemovalReplacement(tokenIndex, preprocessorUsageInformation, previousRegion);
        }
        CCSMAssert.fail((String)"should not be reachable");
        return null;
    }

    private static PreprocessorTokenReplacement generateUnbalancedIfDirectivesReplacement(int tokenIndex, CPreprocessor.IncludedFilesContext includedFiles, CPreprocessor.PreprocessorUsageInformation preprocessorUsageInformation) {
        return PreprocessorTokenReplacement.createSingleTokenRemovalWithError("unbalanced if directives", tokenIndex, preprocessorUsageInformation);
    }

    private static PreprocessorTokenReplacement generateDirectiveRemovalReplacement(int tokenIndex, CPreprocessor.PreprocessorUsageInformation preprocessorUsageInformation, Pair<IToken, Boolean> previousRegion) {
        if (previousRegion == null) {
            return new PreprocessorTokenReplacement(Collections.emptyList(), tokenIndex, tokenIndex + 1, preprocessorUsageInformation);
        }
        return new PreprocessorConditionalTokenReplacement((IToken)previousRegion.getFirst(), Collections.emptyList(), tokenIndex, tokenIndex + 1, preprocessorUsageInformation);
    }

    private static PreprocessorTokenReplacement generateRegionRemovalReplacement(List<IToken> tokens, int conditionalDirectiveTokenIndex, CPreprocessor.IncludedFilesContext includedFiles, CPreprocessor.PreprocessorUsageInformation preprocessorUsageInformation, Pair<IToken, Boolean> previousRegion) {
        int endIndex = IfDirectivePreprocessor.findIndexOfNextConditionalEnd(tokens, conditionalDirectiveTokenIndex);
        if (endIndex < 0) {
            return PreprocessorTokenReplacement.createSingleTokenRemovalWithError("could not find if directive region end", conditionalDirectiveTokenIndex, preprocessorUsageInformation);
        }
        return new PreprocessorConditionalTokenReplacement((IToken)previousRegion.getFirst(), Collections.emptyList(), conditionalDirectiveTokenIndex, endIndex, preprocessorUsageInformation);
    }

    private static int findIndexOfNextConditionalEnd(List<IToken> tokens, int conditionalTokenIndex) {
        int nesting = 0;
        for (int i = conditionalTokenIndex + 1; i < tokens.size(); ++i) {
            if (IfDirectivePreprocessor.isIfDirective(tokens.get(i))) {
                ++nesting;
            }
            boolean endif = IfDirectivePreprocessor.isEndIfDirective(tokens.get(i));
            if (nesting == 0 && (endif || IfDirectivePreprocessor.isElseDirective(tokens.get(i)) || IfDirectivePreprocessor.isElifDirective(tokens.get(i)))) {
                return i;
            }
            if (!endif || nesting <= 0) continue;
            --nesting;
        }
        return -1;
    }

    public static List<IToken> extractCondition(IToken token) {
        String content = token.getText().trim().substring(1);
        List<IToken> subTokens = ScannerUtils.getTokens(content, token.getLanguage(), token.getOriginId());
        if (subTokens.size() == 2 && subTokens.get(0).getText().equals("ifdef")) {
            return CPreprocessingUtils.scanMacroContent("defined(" + subTokens.get(1).getText() + ")", token.getLanguage());
        }
        if (subTokens.size() == 2 && subTokens.get(0).getText().equals("ifndef")) {
            return CPreprocessingUtils.scanMacroContent("!defined(" + subTokens.get(1).getText() + ")", token.getLanguage());
        }
        return subTokens.subList(1, subTokens.size());
    }

    static boolean conditionIsTrue(List<IToken> condition, CPreprocessor.FilePreprocessorContext context, CPreprocessor preprocessor, CPreprocessor.PreprocessorUsageInformation preprocessorUsageInformation, CPreprocessor.IncludedFilesContext includedFiles) throws CPreprocessor.PreprocessorException {
        IToken currentToken;
        int i;
        List processedCondition = IfDirectivePreprocessor.expandDefinedOperators(condition, context, preprocessorUsageInformation, includedFiles);
        processedCondition = IfDirectivePreprocessor.expandMacroCalls(processedCondition, context, preprocessor, preprocessorUsageInformation, includedFiles);
        for (i = 0; i < processedCondition.size(); ++i) {
            currentToken = processedCondition.get(i);
            if (!IfDirectivePreprocessor.tokenNameisBuiltinConditionFunction(currentToken)) continue;
            IfDirectivePreprocessor.replaceHasIncludeOrHasIncludeNextFunction(processedCondition, i, currentToken, context, preprocessor);
        }
        for (i = 0; i < processedCondition.size(); ++i) {
            currentToken = processedCondition.get(i);
            if (currentToken.getType() != ETokenType.IDENTIFIER) continue;
            processedCondition.set(i, currentToken.newToken(ETokenType.INTEGER_LITERAL, currentToken.getOffset(), currentToken.getLineNumber(), "0", currentToken.getOriginId()));
        }
        if (processedCondition.isEmpty()) {
            return false;
        }
        if (processedCondition.size() == 1 && processedCondition.get(0).getType() == ETokenType.INTEGER_LITERAL) {
            String numberString = ((IToken)processedCondition.get(0)).getText();
            if (numberString.equals("0")) {
                return false;
            }
            if (numberString.equals("1")) {
                return true;
            }
            if (numberString.startsWith("0b") || numberString.startsWith("0B") || numberString.startsWith("0x") || numberString.startsWith("0X")) {
                numberString = numberString.substring(2);
            }
            return NON_ZERO_PATTERN.matcher(numberString).find();
        }
        processedCondition = CollectionUtils.filter(processedCondition, token -> token.getType().getTokenClass() != ETokenType.ETokenClass.COMMENT);
        String expression = IfDirectivePreprocessor.concatToJavascriptExpression(processedCondition);
        return (Boolean)EXPRESSION_CACHE.obtain((Object)expression);
    }

    private static List<IToken> expandMacroCalls(List<IToken> unprocessedCondition, CPreprocessor.FilePreprocessorContext context, CPreprocessor preprocessor, CPreprocessor.PreprocessorUsageInformation preprocessorUsageInformation, CPreprocessor.IncludedFilesContext includedFiles) throws CPreprocessor.PreprocessorException {
        ArrayList<IToken> processedCondition = new ArrayList<IToken>();
        for (int i = 0; i < unprocessedCondition.size(); ++i) {
            IToken currentToken = unprocessedCondition.get(i);
            Optional<MacroDefinition> macro = context.findMacroDefinition(currentToken, includedFiles);
            if (macro.isPresent() && !IfDirectivePreprocessor.isBuiltinConditionFunctionCall(currentToken, macro.get())) {
                MacroInvocationPreprocessor macroInvocationPreprocessor = new MacroInvocationPreprocessor(preprocessor.getExpansionStepsLogger());
                PreprocessorTokenReplacement replacement = macroInvocationPreprocessor.expandTopLevelMacroInvocation(i, unprocessedCondition, macro.get(), context, includedFiles);
                if (replacement == null || replacement.countReplacedTokens() == 0) {
                    processedCondition.add(currentToken);
                    continue;
                }
                processedCondition.addAll(replacement.replacementTokens);
                preprocessorUsageInformation.addFrom(replacement.preprocessorUsageInformation);
                i = replacement.originalTokensEndIndex - 1;
                continue;
            }
            processedCondition.add(currentToken);
        }
        return processedCondition;
    }

    private static boolean isBuiltinConditionFunctionCall(IToken currentToken, MacroDefinition macro) {
        return IfDirectivePreprocessor.tokenNameisBuiltinConditionFunction(currentToken) && macro.macroDeclarationLocation.equals((Object)CPreprocessingUtils.LOCATION_FOR_INTERNAL_DEFAULT_DEFINES);
    }

    private static boolean tokenNameisBuiltinConditionFunction(IToken currentToken) {
        if (currentToken.getType() != ETokenType.IDENTIFIER) {
            return false;
        }
        return currentToken.getText().equals(HAS_INCLUDE_BUILTIN_FUNCTION) || currentToken.getText().equals(HAS_INCLUDE_NEXT_BUILTIN_FUNCTION);
    }

    private static void replaceHasIncludeOrHasIncludeNextFunction(List<IToken> processedCondition, int functionPosition, IToken currentToken, CPreprocessor.FilePreprocessorContext context, CPreprocessor preprocessor) {
        boolean isIncludeNext;
        IToken functionNameToken = processedCondition.get(functionPosition);
        if (functionNameToken.getText().equals(HAS_INCLUDE_BUILTIN_FUNCTION)) {
            isIncludeNext = false;
        } else if (functionNameToken.getText().equals(HAS_INCLUDE_NEXT_BUILTIN_FUNCTION)) {
            isIncludeNext = true;
        } else {
            return;
        }
        int includedNameStartIndex = functionPosition + 2;
        int includedNameEndIndex = IfDirectivePreprocessor.findFunctionRParenPosition(processedCondition, functionPosition);
        if (includedNameEndIndex == -1) {
            return;
        }
        List<IToken> functionArgument = processedCondition.subList(includedNameStartIndex, includedNameEndIndex);
        String includedName = CPreprocessor.extractIncludedNameWithoutMacroExpansion(functionArgument).orElse(null);
        if (includedName == null) {
            return;
        }
        IncludeDirective includeDirective = isIncludeNext ? IncludeDirective.createIncludeNextDirective(includedName) : IncludeDirective.createIncludeDirective(includedName);
        boolean canResolveInclude = preprocessor.resolveInclude(context.uniformPath, includeDirective).isPresent();
        if (canResolveInclude) {
            processedCondition.set(functionPosition, currentToken.newToken(ETokenType.INTEGER_LITERAL, currentToken.getOffset(), currentToken.getLineNumber(), "1", currentToken.getOriginId()));
        } else {
            processedCondition.set(functionPosition, currentToken.newToken(ETokenType.INTEGER_LITERAL, currentToken.getOffset(), currentToken.getLineNumber(), "0", currentToken.getOriginId()));
        }
        processedCondition.subList(functionPosition + 1, includedNameEndIndex + 1).clear();
    }

    private static int findFunctionRParenPosition(List<IToken> processedCondition, int functionPosition) {
        if (processedCondition.size() <= functionPosition + 2 || processedCondition.get(functionPosition + 1).getType() != ETokenType.LPAREN) {
            return -1;
        }
        return TokenStreamUtils.firstTokenMatching(processedCondition, functionPosition, (ITokenMatcher)ETokenType.RPAREN);
    }

    private static String concatToJavascriptExpression(List<IToken> conditionTokens) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < conditionTokens.size(); ++i) {
            IToken token;
            String tokenText;
            if (i > 0) {
                builder.append(" ");
            }
            if ((tokenText = ALTERNATIVE_TOKEN_TEXTS.get((token = conditionTokens.get(i)).getType())) == null) {
                tokenText = token.getText();
            }
            if (token.getType().isLiteral()) {
                tokenText = IfDirectivePreprocessor.stripNumberSuffixes(tokenText);
            }
            builder.append(tokenText);
        }
        return builder.toString();
    }

    private static String stripNumberSuffixes(String expression) {
        return NUMBER_WITH_SIZE_OR_SIGNEDNESS_PATTERN.matcher(expression).replaceAll("$1");
    }

    private static List<IToken> expandDefinedOperators(List<IToken> tokens, CPreprocessor.FilePreprocessorContext context, CPreprocessor.PreprocessorUsageInformation preprocessorUsageInformation, CPreprocessor.IncludedFilesContext includedFiles) {
        ArrayList<IToken> result = new ArrayList<IToken>();
        for (int i = 0; i < tokens.size(); ++i) {
            IToken token = tokens.get(i);
            if (token.getType() == ETokenType.IDENTIFIER && token.getText().equals("defined")) {
                String value;
                IToken macroToken;
                if (TokenStreamUtils.hasTokenTypeSequence(tokens, i + 1, ETokenType.LPAREN, ETokenType.IDENTIFIER, ETokenType.RPAREN)) {
                    macroToken = tokens.get(i + 2);
                    i += 3;
                } else if (TokenStreamUtils.hasTokenTypeSequence(tokens, i + 1, ETokenType.IDENTIFIER)) {
                    macroToken = tokens.get(i + 1);
                    ++i;
                } else {
                    return result;
                }
                Optional<MacroDefinition> macro = context.findMacroDefinition(macroToken, includedFiles);
                if (macro.isPresent()) {
                    value = "1";
                    preprocessorUsageInformation.addMacroDefinitionDependencyOn(macro.get());
                } else {
                    value = "0";
                }
                result.add(token.newToken(ETokenType.INTEGER_LITERAL, token.getOffset(), token.getLineNumber(), value, token.getOriginId()));
                continue;
            }
            result.add(token);
        }
        return result;
    }

    private static Boolean evaluateExpression(String expression) {
        try {
            Context context = ContextFactory.getGlobal().enterContext();
            ScriptableObject scope = context.initStandardObjects();
            Object result = context.evaluateString((Scriptable)scope, expression, "EvaluationScript", 1, null);
            if (result instanceof Boolean) {
                return (Boolean)result;
            }
            if (result instanceof Integer) {
                return 0 != (Integer)result;
            }
            if (result instanceof Double) {
                return 0 != (Integer)Context.jsToJava((Object)result, Integer.class);
            }
            return false;
        }
        catch (EcmaError | EvaluatorException e) {
            return false;
        }
    }

    static class ConditionalRegionStack {
        private final ArrayDeque<Pair<IToken, Boolean>> conditionalRegions = new ArrayDeque();

        ConditionalRegionStack() {
        }

        private void pushConditionalRegion(IToken currentToken, boolean currentOrPreviousRegionIsIncluded) {
            this.conditionalRegions.push((Pair<IToken, Boolean>)new Pair((Object)currentToken, (Object)currentOrPreviousRegionIsIncluded));
        }

        private Pair<IToken, Boolean> popConditionalRegion() {
            return this.conditionalRegions.pop();
        }

        public boolean isEmpty() {
            return this.conditionalRegions.isEmpty();
        }
    }
}

