/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.framework.shallowparser.framework;

import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.RecognizerBase;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.PairList;

public class ParserState<STATE extends Enum<STATE>> {
    public static final int MAXIMUM_NESTING_DEPTH = 240;
    private final PairList<Set<STATE>, RecognizerBase<STATE>> recognizers;
    private final Stack<ShallowEntity> entities = new Stack();
    private final Stack<Integer> currentMatchStart = new Stack();
    private final Stack<Integer> currentReferencePosition = new Stack();
    final List<ShallowEntity> result = new ArrayList<ShallowEntity>();
    private STATE forcedNextState = null;

    ParserState(PairList<Set<STATE>, RecognizerBase<STATE>> recognizers) {
        this.recognizers = recognizers;
    }

    public void setNode(ShallowEntity shallowEntity) {
        if (this.entities.isEmpty()) {
            this.result.add(shallowEntity);
        } else {
            this.entities.peek().addChild(shallowEntity);
        }
        this.entities.push(shallowEntity);
        this.forcedNextState = null;
    }

    public void endNode(boolean expectsContinuation) {
        CCSMAssert.isFalse((boolean)this.entities.isEmpty(), (String)"Must have setNode() before each endNode()!");
        this.entities.peek().setComplete(expectsContinuation);
    }

    public void setNodeName(String name) {
        CCSMAssert.isFalse((boolean)this.entities.isEmpty(), (String)"Must have setNode() before setNodeName()!");
        this.entities.peek().setName(name);
    }

    public String getCurrentEntityName() {
        CCSMAssert.isFalse((boolean)this.entities.isEmpty(), (String)"May not access entity name when no nodes have been created before!");
        return this.entities.peek().getName();
    }

    public EShallowEntityType getCurrentEntityType() {
        CCSMAssert.isFalse((boolean)this.entities.isEmpty(), (String)"May not access entity type when no nodes have been created before!");
        return this.entities.peek().getType();
    }

    public int parse(STATE state, List<IToken> tokens, int startOffset) {
        int resultOffset;
        int oldEntitiesSize = this.entities.size();
        if (this.entities.size() >= 240) {
            this.setNode(new ShallowEntity(EShallowEntityType.STATEMENT, "block", "code with nesting depth " + this.entities.size() + " is too deeply nested", tokens, startOffset, tokens.size(), false, false, Collections.emptyList()));
            resultOffset = tokens.size();
        } else {
            resultOffset = this.parseEntity(state, tokens, startOffset);
        }
        if (this.entities.size() > oldEntitiesSize) {
            int nextOffset;
            ShallowEntity newEntity = this.entities.pop();
            resultOffset = ParserState.ensureEntityContainsAllChildEntityTokens(newEntity, Math.max(newEntity.getStartTokenIndex() + 1, resultOffset));
            if (newEntity.isContinued() && resultOffset != -1 && (nextOffset = this.parse(this.getContinuationState(state), tokens, resultOffset)) != -1) {
                return nextOffset;
            }
        }
        return resultOffset;
    }

    private int parseEntity(STATE state, List<IToken> tokens, int startOffset) {
        int resultOffset = -1;
        for (int i = 0; i < this.recognizers.size(); ++i) {
            if (!((Set)this.recognizers.getFirst(i)).contains(state)) continue;
            this.currentMatchStart.push(startOffset);
            this.currentReferencePosition.push(startOffset);
            int match = ((RecognizerBase)this.recognizers.getSecond(i)).matches(this, tokens, startOffset);
            this.currentReferencePosition.pop();
            this.currentMatchStart.pop();
            if (match == -1) continue;
            resultOffset = match;
            break;
        }
        return resultOffset;
    }

    private static int ensureEntityContainsAllChildEntityTokens(ShallowEntity entity, int minEndOffset) {
        int correctedEndOffset = minEndOffset;
        for (ShallowEntity child : entity.getChildren()) {
            correctedEndOffset = Math.max(correctedEndOffset, child.getEndTokenIndex());
        }
        entity.setEndTokenIndex(correctedEndOffset);
        return correctedEndOffset;
    }

    private STATE getContinuationState(STATE state) {
        if (this.forcedNextState != null) {
            return this.forcedNextState;
        }
        return state;
    }

    public int getCurrentMatchStart() {
        return this.currentMatchStart.peek();
    }

    public int getCurrentReferencePosition() {
        return this.currentReferencePosition.peek();
    }

    public void markReferencePosition(int offset) {
        this.currentReferencePosition.pop();
        this.currentReferencePosition.push(offset);
    }

    public int getEntityStackSize() {
        return this.entities.size();
    }

    public void setForcedNextState(STATE forcedNextState) {
        this.forcedNextState = forcedNextState;
    }
}

