/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.framework.shallowparser.languages.cpp;

import eu.cqse.check.framework.matcher.ITokenMatcher;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.INameResolver;
import eu.cqse.check.framework.shallowparser.framework.RecognizerBase;
import eu.cqse.check.framework.shallowparser.framework.RecognizerUtils;
import eu.cqse.check.framework.shallowparser.languages.base.CStyleShallowParserBase;
import eu.cqse.check.framework.shallowparser.languages.base.EGenericParserStates;
import eu.cqse.check.framework.shallowparser.languages.cpp.CppLambdaRecognizer;
import eu.cqse.check.framework.shallowparser.languages.cpp.CppShallowParserAdditionalStatementRules;
import eu.cqse.check.framework.shallowparser.languages.cpp.CppShallowParserBasicBlockRules;
import eu.cqse.check.framework.shallowparser.languages.cpp.CppShallowParserCaseRules;
import eu.cqse.check.framework.shallowparser.languages.cpp.CppShallowParserClassElementRules;
import eu.cqse.check.framework.shallowparser.languages.cpp.CppShallowParserMetaRules;
import eu.cqse.check.framework.shallowparser.languages.cpp.CppShallowParserNamespaceRules;
import eu.cqse.check.framework.shallowparser.languages.cpp.CppShallowParserTypeRules;
import eu.cqse.check.framework.shallowparser.languages.cpp.CppSkipTemplateSpecificationRecognizer;
import eu.cqse.check.framework.shallowparser.languages.cpp.LikelihoodAttributeRecognizer;
import eu.cqse.check.framework.shallowparser.languages.objectivec.AppleBlockSyntaxRecognizer;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;

public class CppShallowParser
extends CStyleShallowParserBase {
    public static final String ANONYMOUS_TYPE_NAME = "<anonymous>";
    public static final ITokenMatcher VALID_IDENTIFIERS = ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.IDENTIFIER, ETokenType.WHERE, ETokenType.FINAL, ETokenType.TRY, ETokenType.GENERIC, ETokenType.ID});
    public static final ITokenMatcher PRIMITIVE_TYPES = ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.VOID, ETokenType.BYTE, ETokenType.INT, ETokenType.FLOAT, ETokenType.DOUBLE, ETokenType.CHAR, ETokenType.BOOL, ETokenType.BOOL_, ETokenType.WCHAR_T, ETokenType.CHAR8_T, ETokenType.CHAR16_T, ETokenType.CHAR32_T, ETokenType.DECIMAL32, ETokenType.DECIMAL64, ETokenType.DECIMAL128, ETokenType.LONG});
    private static final ITokenMatcher EXTENDED_TYPES = ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.COMPLEX, ETokenType.IMAGINARY});
    private static final ITokenMatcher PRIMITIVE_MODIFIERS = ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.LONG, ETokenType.SHORT, ETokenType.SIGNED, ETokenType.UNSIGNED});
    public static final ITokenMatcher TYPES_TOKENS = PRIMITIVE_TYPES.or(new ITokenMatcher[]{EXTENDED_TYPES, PRIMITIVE_MODIFIERS});
    public static final ITokenMatcher TYPE_KEYWORDS_MATCHER = ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.CLASS, ETokenType.STRUCT, ETokenType.UNION, ETokenType.ENUM});
    public static final ITokenMatcher ADDITIONAL_STATEMENT_START_TOKENS = ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.AUTO, ETokenType.NEW, ETokenType.DELETE, ETokenType.BREAK, ETokenType.CONTINUE, ETokenType.CO_RETURN, ETokenType.CO_AWAIT, ETokenType.CO_YIELD, ETokenType.RETURN, ETokenType.ASSERT, ETokenType.FINAL, ETokenType.GOTO, ETokenType.SUPER, ETokenType.THIS, ETokenType.THROW, ETokenType.MULT, ETokenType.LPAREN, ETokenType.PLUSPLUS, ETokenType.MINUSMINUS, ETokenType.SCOPE, ETokenType.OPERATOR});
    private static final ITokenMatcher LAMBDA_MODIFIERS = ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.CONSTEXPR, ETokenType.MUTABLE});
    private static final ITokenMatcher TYPE_SPECIFIER_WITH_PARENTHESIS = ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.ATOMIC, ETokenType.DECLTYPE, ETokenType.TYPEOF, ETokenType.TYPEOF_UNQUAL});
    protected static final ITokenMatcher BASE_TYPE_OR_IDENTIFIER = ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.AUTO, ETokenType.DECLTYPE, ETokenType.IDENTIFIER});
    public static final ITokenMatcher TYPE_OR_IDENTIFIER = BASE_TYPE_OR_IDENTIFIER.or(new ITokenMatcher[]{PRIMITIVE_TYPES});
    public static final ITokenMatcher METHOD_AND_TYPE_DECLARATION_MODIFIERS = ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.CONST, ETokenType.CONSTEXPR, ETokenType.STATIC, ETokenType.VIRTUAL, ETokenType.EXTERN, ETokenType.NEAR, ETokenType.FAR, ETokenType.ALIGNAS, ETokenType.MUTABLE, ETokenType.FRIEND, ETokenType.EXPLICIT, ETokenType.INLINE, ETokenType.NORETURN, ETokenType.THREAD_LOCAL, ETokenType.VOLATILE, ETokenType.BLOCK});
    public static final ITokenMatcher CPP_CLI_EVENT_MODIFIERS = ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.VIRTUAL, ETokenType.STATIC});

    public CppShallowParser() {
        new CppShallowParserNamespaceRules(this).contributeRules();
    }

    @Override
    protected void createMetaRules() {
        new CppShallowParserMetaRules(this).contributeRules();
        super.createMetaRules();
    }

    @Override
    protected void createClassElementsRules() {
        new CppShallowParserClassElementRules(this).contributeRules();
    }

    @Override
    protected void createBasicBlockRules() {
        new CppShallowParserBasicBlockRules(this).contributeRules();
        super.createBasicBlockRules();
    }

    @Override
    protected void endBlockRule(RecognizerBase<EGenericParserStates> blockRule, ITokenMatcher continuationTokens, boolean canBeFollowedByParentheses, boolean alwaysBraces) {
        if (canBeFollowedByParentheses) {
            blockRule = blockRule.skipNested(ETokenType.LPAREN, ETokenType.RPAREN, this.getSubExpressionRecognizer());
        }
        if (alwaysBraces) {
            blockRule = blockRule.skipBefore(new ITokenMatcher[]{ETokenType.LBRACE});
        }
        RecognizerBase<EGenericParserStates> likelihoodAttributeBlockRule = blockRule.sequence(new ITokenMatcher[]{ETokenType.LBRACK, ETokenType.LBRACK}).preCondition(new LikelihoodAttributeRecognizer()).skipAfter(new ITokenMatcher[]{ETokenType.RBRACK, ETokenType.RBRACK});
        this.endWithPossibleContinuation(likelihoodAttributeBlockRule.parseOnce(EGenericParserStates.IN_METHOD), continuationTokens);
        this.endWithPossibleContinuation(likelihoodAttributeBlockRule.sequence(new ITokenMatcher[]{ETokenType.LBRACE}).parseUntil(EGenericParserStates.IN_METHOD).sequence(new ITokenMatcher[]{ETokenType.RBRACE}), continuationTokens);
        this.endWithPossibleContinuation(blockRule.sequence(new ITokenMatcher[]{ETokenType.LBRACE}).parseUntil(EGenericParserStates.IN_METHOD).sequence(new ITokenMatcher[]{ETokenType.RBRACE}), continuationTokens);
        this.endWithPossibleContinuation(blockRule.parseOnce(EGenericParserStates.IN_METHOD), continuationTokens);
    }

    @Override
    public void endBasicBlockRule(RecognizerBase<EGenericParserStates> blockRule, ITokenMatcher continuationTokens, boolean canBeFollowedByParentheses, boolean alwaysBraces) {
        if (canBeFollowedByParentheses) {
            blockRule = blockRule.skipNested(ETokenType.LPAREN, ETokenType.RPAREN, this.getSubExpressionRecognizer());
        }
        if (alwaysBraces) {
            blockRule = blockRule.skipBefore(new ITokenMatcher[]{ETokenType.LBRACE});
        }
        RecognizerBase<EGenericParserStates> likelihoodAttributeBlockRule = blockRule.sequence(new ITokenMatcher[]{ETokenType.LBRACK, ETokenType.LBRACK}).preCondition(new LikelihoodAttributeRecognizer()).skipAfter(new ITokenMatcher[]{ETokenType.RBRACK, ETokenType.RBRACK});
        this.endWithPossibleContinuation(likelihoodAttributeBlockRule.optional(this.getOptionalTokensBeforeBlockBraces()).sequence(new ITokenMatcher[]{ETokenType.LBRACE}).parseUntil(EGenericParserStates.IN_METHOD).sequence(new ITokenMatcher[]{ETokenType.RBRACE}), continuationTokens);
        this.endWithPossibleContinuation(blockRule.optional(this.getOptionalTokensBeforeBlockBraces()).sequence(new ITokenMatcher[]{ETokenType.LBRACE}).parseUntil(EGenericParserStates.IN_METHOD).sequence(new ITokenMatcher[]{ETokenType.RBRACE}), continuationTokens);
        this.handlePragmasAroundBlock(blockRule, continuationTokens);
        this.endWithPossibleContinuation(likelihoodAttributeBlockRule.parseOnce(EGenericParserStates.IN_METHOD), continuationTokens);
        this.endWithPossibleContinuation(blockRule.parseOnce(EGenericParserStates.IN_METHOD), continuationTokens);
    }

    private void handlePragmasAroundBlock(RecognizerBase<EGenericParserStates> blockRule, ITokenMatcher continuationTokens) {
        RecognizerBase pragmaRecognizer = this.createRecognizer(start -> start.sequenceBefore(new ITokenMatcher[]{ETokenType.PRAGMA_DIRECTIVE}).parseOnce(EGenericParserStates.IN_METHOD));
        ITokenMatcher optionalTokensBeforeBlockBraces = this.getOptionalTokensBeforeBlockBraces();
        RecognizerBase<EGenericParserStates> pragmaBlockRule = blockRule.optional(optionalTokensBeforeBlockBraces).repeatedSubRecognizer(pragmaRecognizer);
        this.endWithPossibleContinuation(pragmaBlockRule.sequence(new ITokenMatcher[]{ETokenType.LBRACE}).parseUntil(EGenericParserStates.IN_METHOD).sequence(new ITokenMatcher[]{ETokenType.RBRACE}).repeatedSubRecognizer(pragmaRecognizer), continuationTokens);
        this.endWithPossibleContinuation(pragmaBlockRule.parseOnce(EGenericParserStates.IN_METHOD).repeatedSubRecognizer(pragmaRecognizer), continuationTokens);
    }

    @Override
    protected RecognizerBase<EGenericParserStates> getBlockRuleStart() {
        return super.getBlockRuleStart().repeatedSubRecognizer(CppShallowParser.createAnnotationSubrecognizer()).markStart();
    }

    @Override
    protected void createTypeRules() {
        this.createTypedefRules();
        new CppShallowParserTypeRules(this).contributeRules();
    }

    public static RecognizerBase<EGenericParserStates> createAnnotationSubrecognizer() {
        return RecognizerUtils.createRecognizer(start -> start.sequence(new ITokenMatcher[]{ETokenType.LBRACK, ETokenType.LBRACK}).skipAfter(new ITokenMatcher[]{ETokenType.RBRACK}).sequence(new ITokenMatcher[]{ETokenType.RBRACK}));
    }

    @Override
    public ITokenMatcher getIdentifierMatcher() {
        return VALID_IDENTIFIERS;
    }

    @Override
    public ITokenMatcher getTypeKeywordsMatcher() {
        return TYPE_KEYWORDS_MATCHER;
    }

    protected ITokenMatcher getPrimitiveTypes() {
        return PRIMITIVE_TYPES;
    }

    protected ITokenMatcher getTypeOrIdentifier() {
        return TYPE_OR_IDENTIFIER;
    }

    public ITokenMatcher getMethodAndTypeDeclarationModifiers() {
        return METHOD_AND_TYPE_DECLARATION_MODIFIERS;
    }

    @Override
    protected void createCaseRule() {
        new CppShallowParserCaseRules(this).contributeRules();
    }

    @Override
    protected void createSimpleStatementRule() {
        new CppShallowParserAdditionalStatementRules(this).contributeRules();
    }

    @Override
    protected void createRuleForSimpleStatementHavingStartTokens(ITokenMatcher statementStartTokens) {
        this.completeSimpleStatement(this.inState(new EGenericParserStates[]{EGenericParserStates.IN_METHOD}).repeatedSubRecognizer(CppShallowParser.createAnnotationSubrecognizer()).markStart().sequence(statementStartTokens));
    }

    @Override
    protected ITokenMatcher getSimpleBlockKeywordsWithParentheses() {
        return ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.WHILE, ETokenType.FOR, ETokenType.SWITCH});
    }

    @Override
    protected ITokenMatcher getSimpleBlockKeywordsWithoutParentheses() {
        return ETokenType.ELSE;
    }

    @Override
    public ITokenMatcher getStatementStartTokens() {
        return this.getIdentifierMatcher().or(new ITokenMatcher[]{ADDITIONAL_STATEMENT_START_TOKENS});
    }

    @Override
    public RecognizerBase<EGenericParserStates> typePattern(RecognizerBase<EGenericParserStates> currentState) {
        return currentState.repeatedSubRecognizer(CppShallowParser.createAnnotationSubrecognizer()).repeated(this.getMethodAndTypeDeclarationModifiers()).skipNested(ETokenType.LPAREN, ETokenType.RPAREN).optional(this.getTypeKeywordsMatcher().or(new ITokenMatcher[]{ETokenType.TYPENAME})).skipNested(ETokenType.LPAREN, ETokenType.RPAREN).repeatedSubRecognizer(this.createScopeRecognizer()).subRecognizer(CppShallowParser.createPrimitiveOrIdentifierMatcher(this.getPrimitiveTypes())).subRecognizer(new CppSkipTemplateSpecificationRecognizer(), 0, 1).skipWhile(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.MULT, ETokenType.AND, ETokenType.ANDAND, ETokenType.CONST, ETokenType.CONSTEXPR, ETokenType.XOR, ETokenType.VOLATILE})).skipNested(ETokenType.LBRACK, ETokenType.RBRACK).skipWhile(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.MULT, ETokenType.AND, ETokenType.ANDAND, ETokenType.CONST, ETokenType.CONSTEXPR, ETokenType.XOR, ETokenType.LBRACK, ETokenType.RBRACK, ETokenType.NEAR, ETokenType.FAR}));
    }

    public static RecognizerBase<EGenericParserStates> createPrimitiveOrIdentifierMatcher(ITokenMatcher primitiveTypes) {
        return RecognizerUtils.createRecognizer(start -> {
            start.sequence(new ITokenMatcher[]{TYPE_SPECIFIER_WITH_PARENTHESIS, ETokenType.LPAREN}).skipAfterWithNesting((ITokenMatcher)ETokenType.RPAREN, ETokenType.LPAREN, ETokenType.RPAREN);
            start.sequence(BASE_TYPE_OR_IDENTIFIER);
            start.sequence(primitiveTypes, EXTENDED_TYPES);
            start.optional(new ITokenMatcher[]{ETokenType.REGISTER}).repeated(PRIMITIVE_MODIFIERS).sequence(primitiveTypes);
            start.optional(new ITokenMatcher[]{ETokenType.REGISTER}).repeatedAtLeastOnce(PRIMITIVE_MODIFIERS);
            start.sequence(new ITokenMatcher[]{ETokenType.ID});
        });
    }

    @Override
    protected void createSubExpressionRules() {
        CppShallowParser.startLambdaRule(this.inState(new EGenericParserStates[]{EGenericParserStates.IN_EXPRESSION}), this.getTypeKeywordsMatcher(), this.getTypeOrIdentifier());
        this.inState(new EGenericParserStates[]{EGenericParserStates.IN_EXPRESSION}).sequence(new ITokenMatcher[]{ETokenType.XOR}).optionalSubRecognizer(this.inState(new EGenericParserStates[]{EGenericParserStates.IN_EXPRESSION}).repeatedSubRecognizer(this.createScopeRecognizer()).subRecognizer(CppShallowParser.createPrimitiveOrIdentifierMatcher(this.getPrimitiveTypes()))).skipAfterWithNesting((ITokenMatcher)ETokenType.LBRACE, ETokenType.LPAREN, ETokenType.RPAREN).createNode(EShallowEntityType.METHOD, "block expression").parseUntil(EGenericParserStates.IN_METHOD).sequence(new ITokenMatcher[]{ETokenType.RBRACE}).endNode();
    }

    public static void startLambdaRule(RecognizerBase<EGenericParserStates> startState, ITokenMatcher typeKeywords, ITokenMatcher typeOrIdentifier) {
        RecognizerBase<EGenericParserStates> lambdaAlternative = startState.skipNested(ETokenType.LBRACK, ETokenType.RBRACK).skipNested(ETokenType.LPAREN, ETokenType.RPAREN).repeated(LAMBDA_MODIFIERS).optional(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.NOEXCEPT, ETokenType.THROW})).skipNested(ETokenType.LPAREN, ETokenType.RPAREN);
        CppShallowParser.finishLambdaRule(lambdaAlternative.sequence(new ITokenMatcher[]{ETokenType.POINTERTO}).repeated(typeKeywords).optional(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.SIGNED, ETokenType.UNSIGNED})).optional(typeOrIdentifier).optional(new ITokenMatcher[]{ETokenType.MULT}).subRecognizer(new CppSkipTemplateSpecificationRecognizer(), 0, 1).skipNested(ETokenType.LPAREN, ETokenType.RPAREN));
        CppShallowParser.finishLambdaRule(lambdaAlternative);
    }

    private static void finishLambdaRule(RecognizerBase<EGenericParserStates> recognizer) {
        recognizer.sequence(new ITokenMatcher[]{ETokenType.LBRACE}).createNode(EShallowEntityType.METHOD, "lambda expression").parseUntil(EGenericParserStates.IN_METHOD).sequence(new ITokenMatcher[]{ETokenType.RBRACE}).endNode();
    }

    @Override
    public RecognizerBase<EGenericParserStates> getSubExpressionRecognizer() {
        return this.createRecognizer(start -> {
            start.subRecognizer(new AppleBlockSyntaxRecognizer());
            start.subRecognizer(new CppLambdaRecognizer(TYPE_OR_IDENTIFIER));
        });
    }

    @Override
    protected boolean isFilteredToken(IToken token, IToken previousToken) {
        return super.isFilteredToken(token, previousToken);
    }

    @Override
    protected List<IToken> filterTokens(List<IToken> tokens) {
        List<IToken> result = super.filterTokens(tokens);
        result = CppShallowParser.filterGCCAttributes(result);
        result = CppShallowParser.filterMicrosoftSpecificAttribute(result);
        return result;
    }

    public static List<IToken> filterMicrosoftSpecificAttribute(List<IToken> tokens) {
        return CppShallowParser.filterParserSpecificAttribute(tokens, token -> "__declspec".equals(token.getText()));
    }

    public static List<IToken> filterGCCAttributes(List<IToken> tokens) {
        return CppShallowParser.filterParserSpecificAttribute(tokens, token -> ETokenType.ATTRIBUTE == token.getType());
    }

    private static List<IToken> filterParserSpecificAttribute(List<IToken> tokens, Predicate<IToken> attributeMatcher) {
        ArrayList<IToken> result = new ArrayList<IToken>();
        boolean inAttribute = false;
        int openBraces = 0;
        for (IToken token : tokens) {
            if (attributeMatcher.test(token)) {
                inAttribute = true;
                continue;
            }
            if (inAttribute && token.getType() == ETokenType.LPAREN) {
                ++openBraces;
                continue;
            }
            if (inAttribute && token.getType() == ETokenType.RPAREN) {
                if (--openBraces != 0) continue;
                inAttribute = false;
                continue;
            }
            if (inAttribute) continue;
            result.add(token);
        }
        return result;
    }

    @Override
    protected void createDoWhileRule() {
        RecognizerBase likelihoodAttributeWithBrackRecognizer = this.inAnyState();
        likelihoodAttributeWithBrackRecognizer.sequence(new ITokenMatcher[]{ETokenType.LBRACK, ETokenType.LBRACK}).preCondition(new LikelihoodAttributeRecognizer()).skipAfter(new ITokenMatcher[]{ETokenType.RBRACK, ETokenType.RBRACK});
        RecognizerBase doWhileAlternative = this.inState(new EGenericParserStates[]{EGenericParserStates.IN_METHOD}).sequence(new ITokenMatcher[]{ETokenType.DO}).createNode(EShallowEntityType.STATEMENT, INameResolver.firstMatchedTokenText());
        doWhileAlternative.optionalSubRecognizer(likelihoodAttributeWithBrackRecognizer).sequence(new ITokenMatcher[]{ETokenType.LBRACE}).parseUntil(EGenericParserStates.IN_METHOD).sequence(new ITokenMatcher[]{ETokenType.RBRACE}).optionalSubRecognizer(likelihoodAttributeWithBrackRecognizer).sequence(new ITokenMatcher[]{ETokenType.WHILE}).skipNested(ETokenType.LPAREN, ETokenType.RPAREN, this.getSubExpressionRecognizer()).optional(new ITokenMatcher[]{ETokenType.SEMICOLON}).endNode();
        doWhileAlternative.parseOnce(EGenericParserStates.IN_METHOD).sequence(new ITokenMatcher[]{ETokenType.WHILE}).skipNested(ETokenType.LPAREN, ETokenType.RPAREN, this.getSubExpressionRecognizer()).optional(new ITokenMatcher[]{ETokenType.SEMICOLON}).endNode();
    }
}

