/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.framework.shallowparser.languages.python;

import eu.cqse.check.framework.matcher.ITokenMatcher;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.INameResolver;
import eu.cqse.check.framework.shallowparser.framework.ParserState;
import eu.cqse.check.framework.shallowparser.framework.RecognizerBase;
import eu.cqse.check.framework.shallowparser.framework.ShallowParserBase;
import eu.cqse.check.framework.shallowparser.languages.python.PythonAttributeRecognizer;
import eu.cqse.check.framework.shallowparser.languages.python.PythonSimpleStatementRecognizer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ListIterator;
import org.conqat.lib.commons.collections.CollectionUtils;

public class PythonShallowParser
extends ShallowParserBase<EPythonParserStates> {
    private static final ITokenMatcher VALID_IDENTIFIERS = ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.IDENTIFIER, ETokenType.MATCH, ETokenType.CASE});

    public PythonShallowParser() {
        super(EPythonParserStates.class, EPythonParserStates.ANY);
        this.createErrorRules();
        this.createImportRules();
        this.createDecoratorRules();
        this.createClassRules();
        this.createFunctionRules();
        this.createLambdaRule();
        this.createStatementRules();
    }

    private void createErrorRules() {
        this.inAnyState().sequence(new ITokenMatcher[]{ETokenType.INDENT}).createNode(EShallowEntityType.META, "Unmatched indent");
        this.inAnyState().sequence(new ITokenMatcher[]{ETokenType.DEDENT}).createNode(EShallowEntityType.META, "Unmatched dedent");
    }

    private void createImportRules() {
        this.inAnyState().sequence(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.IMPORT, ETokenType.FROM})).createNode(EShallowEntityType.META, INameResolver.firstMatchedTokenText()).skipAfter(new ITokenMatcher[]{ETokenType.EOL}).endNode();
    }

    private void createDecoratorRules() {
        this.inAnyState().sequence(new ITokenMatcher[]{ETokenType.AT, VALID_IDENTIFIERS}).repeated(new ITokenMatcher[]{ETokenType.DOT, VALID_IDENTIFIERS}).createNode(EShallowEntityType.META, "decorator", INameResolver.ofRange(1, -1)).skipNested(ETokenType.LPAREN, ETokenType.RPAREN, this.createLambdaSubRecognizer()).endNode();
    }

    private void createClassRules() {
        RecognizerBase<EPythonParserStates> classAlternative = this.inAnyState().sequence(new ITokenMatcher[]{ETokenType.CLASS, VALID_IDENTIFIERS}).skipNested(ETokenType.LPAREN, ETokenType.RPAREN).sequence(new ITokenMatcher[]{ETokenType.COLON}).createNode(EShallowEntityType.TYPE, "class", INameResolver.secondMatchedTokenText());
        PythonShallowParser.addBlockClosingAlternatives(classAlternative, EPythonParserStates.IN_CLASS);
    }

    private void createFunctionRules() {
        RecognizerBase<EPythonParserStates> functionAlternative = this.inAnyState().optional(new ITokenMatcher[]{ETokenType.ASYNC}).sequence(new ITokenMatcher[]{ETokenType.DEF, VALID_IDENTIFIERS}).createNode(EShallowEntityType.METHOD, "method", INameResolver.previousTokenText()).skipNested(ETokenType.LPAREN, ETokenType.RPAREN).skipAfterWithNesting((ITokenMatcher)ETokenType.COLON, Arrays.asList(ETokenType.LBRACK, ETokenType.LBRACE, ETokenType.LPAREN), Arrays.asList(ETokenType.RBRACK, ETokenType.RBRACE, ETokenType.RPAREN));
        PythonShallowParser.addBlockClosingAlternatives(functionAlternative, EPythonParserStates.ANY);
    }

    private void createStatementRules() {
        this.inAnyState().sequence(new ITokenMatcher[]{ETokenType.SEMICOLON}).createNode(EShallowEntityType.STATEMENT, "empty statement").endNode();
        RecognizerBase<EPythonParserStates> ifAlternative = this.inAnyState().optional(new ITokenMatcher[]{ETokenType.ASYNC}).sequence(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.IF, ETokenType.ELIF, ETokenType.ELSE, ETokenType.TRY, ETokenType.EXCEPT, ETokenType.FINALLY, ETokenType.WHILE, ETokenType.FOR, ETokenType.WITH})).createNode(EShallowEntityType.STATEMENT, INameResolver.previousTokenText()).skipAfterWithNesting((ITokenMatcher)ETokenType.COLON, Arrays.asList(ETokenType.LBRACK, ETokenType.LBRACE, ETokenType.LPAREN), Arrays.asList(ETokenType.RBRACK, ETokenType.RBRACE, ETokenType.RPAREN));
        PythonShallowParser.addBlockClosingAlternatives(ifAlternative, EPythonParserStates.ANY);
        RecognizerBase<EPythonParserStates> ifAlternativeValidIdentifiers = this.inAnyState().sequence(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.MATCH, ETokenType.CASE})).preCondition(new NotAMethodCallRecognizer()).preCondition(this.createRecognizer(start -> start.skipBefore(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.COLON, ETokenType.EOL})).sequence(new ITokenMatcher[]{ETokenType.COLON}))).createNode(EShallowEntityType.STATEMENT, INameResolver.firstMatchedTokenText()).skipAfterWithNesting((ITokenMatcher)ETokenType.COLON, Arrays.asList(ETokenType.LBRACK, ETokenType.LBRACE, ETokenType.LPAREN), Arrays.asList(ETokenType.RBRACK, ETokenType.RBRACE, ETokenType.RPAREN));
        PythonShallowParser.addBlockClosingAlternatives(ifAlternativeValidIdentifiers, EPythonParserStates.ANY);
        this.inAnyState().sequence(new ITokenMatcher[]{ETokenType.EOL});
        this.inState(new EPythonParserStates[]{EPythonParserStates.IN_CLASS}).sequenceBefore(VALID_IDENTIFIERS).subRecognizer(new PythonAttributeRecognizer(), 1, 1).endNode();
        this.inState(new EPythonParserStates[]{EPythonParserStates.ANY, EPythonParserStates.IN_CLASS}).sequenceBefore(ITokenMatcher.noneOfType((ETokenType[])new ETokenType[]{ETokenType.DEF, ETokenType.CLASS})).subRecognizer(new PythonSimpleStatementRecognizer(), 1, 1).endNode();
        this.inState(new EPythonParserStates[]{EPythonParserStates.IN_LAMBDA}).sequenceBefore(ITokenMatcher.noneOfType((ETokenType[])new ETokenType[]{ETokenType.DEF, ETokenType.CLASS})).subRecognizer(new PythonSimpleStatementRecognizer(true), 1, 1).endNode();
    }

    private void createLambdaRule() {
        this.inState(new EPythonParserStates[]{EPythonParserStates.ANY}).sequence(new ITokenMatcher[]{ETokenType.LAMBDA}).skipAfter(new ITokenMatcher[]{ETokenType.COLON}).createNode(EShallowEntityType.METHOD, "lambda").parseOnce(EPythonParserStates.IN_LAMBDA).sequenceBefore(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.RBRACK, ETokenType.RPAREN, ETokenType.DEDENT, ETokenType.EOL, ETokenType.COMMA, ETokenType.RBRACE})).endNode();
    }

    private RecognizerBase<EPythonParserStates> createLambdaSubRecognizer() {
        return this.createRecognizer(start -> start.sequenceBefore(new ITokenMatcher[]{ETokenType.LAMBDA}).parseOnce(EPythonParserStates.ANY));
    }

    private static void addBlockClosingAlternatives(RecognizerBase<EPythonParserStates> matchingAlternative, EPythonParserStates innerBlockState) {
        matchingAlternative.sequence(new ITokenMatcher[]{ETokenType.EOL, ETokenType.INDENT}).parseUntil(innerBlockState).sequence(new ITokenMatcher[]{ETokenType.DEDENT}).endNode();
        matchingAlternative.parseUntil(innerBlockState).sequence(new ITokenMatcher[]{ETokenType.EOL}).endNode();
    }

    @Override
    protected List<IToken> filterTokens(List<IToken> tokens) {
        tokens = super.filterTokens(tokens);
        tokens = PythonShallowParser.fixDedentPositioning(tokens);
        tokens = PythonShallowParser.collapseEol(tokens);
        return tokens;
    }

    private static List<IToken> fixDedentPositioning(List<IToken> tokens) {
        ArrayList<IToken> result = new ArrayList<IToken>(tokens);
        ListIterator iter = result.listIterator();
        while (iter.hasNext()) {
            IToken token = (IToken)iter.next();
            if (!ETokenType.DEDENT.matches(token)) continue;
            int dedentIndex = iter.previousIndex();
            int moveAfterIndex = dedentIndex - (int)result.subList(0, dedentIndex).reversed().stream().takeWhile(arg_0 -> ((ITokenMatcher)ETokenType.EOL.or(new ITokenMatcher[]{ETokenType.DEDENT})).matches(arg_0)).count();
            IToken moveAfterToken = (IToken)result.get(moveAfterIndex);
            List<IToken> tokensToBeMoved = result.subList(moveAfterIndex + 1, dedentIndex + 1);
            CollectionUtils.circularShiftRight(tokensToBeMoved);
            tokensToBeMoved.set(0, moveAfterToken.newToken(ETokenType.DEDENT, moveAfterToken.getOffset(), moveAfterToken.getLineNumber(), token.getText(), token.getOriginId()));
        }
        return result;
    }

    private static List<IToken> collapseEol(List<IToken> tokens) {
        return PythonShallowParser.filterTokens(tokens, (previousToken, token) -> previousToken != null && ETokenType.EOL.matches(previousToken) && ETokenType.EOL.matches(token));
    }

    public static enum EPythonParserStates {
        ANY,
        IN_CLASS,
        IN_LAMBDA;

    }

    private static class NotAMethodCallRecognizer
    extends RecognizerBase<EPythonParserStates> {
        private NotAMethodCallRecognizer() {
        }

        @Override
        protected int matchesLocally(ParserState<EPythonParserStates> parserState, List<IToken> tokens, int startOffset) {
            if (tokens.get(startOffset).getType() != ETokenType.LPAREN) {
                return startOffset;
            }
            if (startOffset < 1) {
                return -1;
            }
            int closingBrace = TokenStreamUtils.findMatchingClosingToken(tokens, startOffset + 1, ETokenType.LPAREN, ETokenType.RPAREN);
            if (closingBrace != -1 && tokens.size() > closingBrace + 1 && tokens.get(closingBrace + 1).getType() != ETokenType.COLON) {
                return -1;
            }
            return super.matchesLocally(parserState, tokens, startOffset);
        }
    }
}

