/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.framework.shallowparser.languages.tsql;

import eu.cqse.check.framework.matcher.ITokenMatcher;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.ShallowParserException;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.INameResolver;
import eu.cqse.check.framework.shallowparser.framework.RecognizerBase;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowParserBase;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import org.conqat.lib.commons.collections.CollectionUtils;

public class TsqlShallowParser
extends ShallowParserBase<ETsqlParserStates> {
    private static final ITokenMatcher META_RULE_START_TOKENS = ETokenType.USE;
    private static final ITokenMatcher DATABASE_ACTION_RULE_START_TOKENS = ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.BACKUP, ETokenType.CLOSE, ETokenType.DEALLOCATE, ETokenType.FETCH, ETokenType.OPEN, ETokenType.RESTORE, ETokenType.TRUNCATE});
    private static final ITokenMatcher BLOCK_RULE_START_TOKENS = ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.ELSE, ETokenType.IF, ETokenType.WHILE});
    private static final ITokenMatcher GENERAL_RULE_START_TOKENS = ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.ADD, ETokenType.BREAK, ETokenType.CHECKPOINT, ETokenType.COMMIT, ETokenType.CONTINUE, ETokenType.DELETE, ETokenType.DENY, ETokenType.DISABLE, ETokenType.ENABLE, ETokenType.EXEC, ETokenType.EXECUTE, ETokenType.GOTO, ETokenType.KILL, ETokenType.MERGE, ETokenType.MOVE, ETokenType.PRINT, ETokenType.RAISERROR, ETokenType.RECEIVE, ETokenType.RECONFIGURE, ETokenType.REVERT, ETokenType.REVOKE, ETokenType.ROLLBACK, ETokenType.SAVE, ETokenType.SEND, ETokenType.SET, ETokenType.SETUSER, ETokenType.SHUTDOWN, ETokenType.THROW, ETokenType.WAITFOR});
    private static final ITokenMatcher SPECIAL_RULE_START_TOKENS = ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.ALTER, ETokenType.BEGIN, ETokenType.BULK, ETokenType.CREATE, ETokenType.DECLARE, ETokenType.DROP, ETokenType.GO, ETokenType.GRANT, ETokenType.INSERT, ETokenType.RETURN, ETokenType.SELECT, ETokenType.UPDATE, ETokenType.WHEN});
    private static final ITokenMatcher END_TOKENS = META_RULE_START_TOKENS.or(new ITokenMatcher[]{DATABASE_ACTION_RULE_START_TOKENS, BLOCK_RULE_START_TOKENS, GENERAL_RULE_START_TOKENS, SPECIAL_RULE_START_TOKENS, ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.EOF, ETokenType.END, ETokenType.SEMICOLON, ETokenType.RPAREN})});
    private static final ITokenMatcher LITERALS = ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.BINARY_LITERAL, ETokenType.BOOLEAN_LITERAL, ETokenType.FLOATING_POINT_LITERAL, ETokenType.INTEGER_LITERAL, ETokenType.MONEY_LITERAL, ETokenType.STRING_LITERAL});
    private static final ITokenMatcher OPERATORS = ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.PLUS, ETokenType.MINUS, ETokenType.MULT, ETokenType.DIV, ETokenType.MOD, ETokenType.EQ, ETokenType.DOUBLE_COLON, ETokenType.AND, ETokenType.OR, ETokenType.XOR, ETokenType.GT, ETokenType.LT, ETokenType.GTEQ, ETokenType.LTEQ, ETokenType.NEQ, ETokenType.NLT, ETokenType.NGT});
    private static final ITokenMatcher SEARCH_CONDITION_TOKENS = OPERATORS.or(new ITokenMatcher[]{ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.IDENTIFIER, ETokenType.DOT, ETokenType.MATCH, ETokenType.ALL, ETokenType.SOME, ETokenType.ANY, ETokenType.EXISTS, ETokenType.IS, ETokenType.NULL, ETokenType.IN, ETokenType.CONTAINS, ETokenType.LIKE, ETokenType.BETWEEN})});

    public TsqlShallowParser() {
        super(ETsqlParserStates.class, ETsqlParserStates.STATEMENTS);
        this.createTopLevelRules();
    }

    @Override
    public List<ShallowEntity> parseTopLevelWithErrors(List<IToken> tokens) throws ShallowParserException {
        ArrayList<IToken> modifiedTokens = new ArrayList<IToken>(tokens);
        if (!tokens.isEmpty()) {
            modifiedTokens.add(TokenStreamUtils.createToken(Objects.requireNonNull((IToken)CollectionUtils.getLast(tokens)), "", ETokenType.EOF));
        }
        return super.parseTopLevelWithErrors(modifiedTokens);
    }

    private void createTopLevelRules() {
        this.createMetaRules();
        this.createGoRule();
        this.createDatabaseRules();
        this.createCreateOrAlterRules();
        this.createVariableRules();
        this.createCommonTableExpressionRules();
        this.createReturnRules();
        this.createBlockRules();
        this.createOtherStartRules();
    }

    private void createMetaRules() {
        TsqlShallowParser.endNodeWithNextStartToken(this.inState(new ETsqlParserStates[]{ETsqlParserStates.STATEMENTS}).sequence(META_RULE_START_TOKENS).createNode(EShallowEntityType.META, INameResolver.matchStartTokenTypeName()));
        this.inState(new ETsqlParserStates[]{ETsqlParserStates.STATEMENTS}).sequence(new ITokenMatcher[]{ETokenType.USER_COMMAND}).createNode(EShallowEntityType.META, "SQL cmd").endNode();
    }

    private void createGoRule() {
        this.inState(new ETsqlParserStates[]{ETsqlParserStates.STATEMENTS}).sequence(new ITokenMatcher[]{ETokenType.GO}).createNode(EShallowEntityType.STATEMENT, "go").optional(new ITokenMatcher[]{ETokenType.INTEGER_LITERAL}).optional(new ITokenMatcher[]{ETokenType.SEMICOLON}).endNode();
    }

    private void createDatabaseRules() {
        this.createDatabaseActionRules();
        this.createMergeRule();
        this.createDropRules();
        this.createSelectRule();
        this.createInsertRules();
        this.createDatabaseBeginAndEndRules();
        this.createDeclareRule();
        this.createUpdateRules();
        this.createGrantRule();
    }

    private void createDatabaseActionRules() {
        TsqlShallowParser.endNodeWithNextStartToken(this.inState(new ETsqlParserStates[]{ETsqlParserStates.STATEMENTS}).sequence(DATABASE_ACTION_RULE_START_TOKENS).createNode(EShallowEntityType.STATEMENT, INameResolver.matchStartTokenTypeName()));
    }

    private void createMergeRule() {
        RecognizerBase whenThenRecognizer = this.createRecognizer(start -> start.sequence(new ITokenMatcher[]{ETokenType.WHEN}).skipAfter(new ITokenMatcher[]{ETokenType.THEN}).parseOnce(ETsqlParserStates.STATEMENTS));
        RecognizerBase outputIntoRecognizer = this.createRecognizer(start -> start.sequence(new ITokenMatcher[]{ETokenType.OUTPUT}).skipAfterWithNesting((ITokenMatcher)ETokenType.INTO, ETokenType.LPAREN, ETokenType.RPAREN));
        TsqlShallowParser.endNodeWithNextStartToken(this.inState(new ETsqlParserStates[]{ETsqlParserStates.STATEMENTS}).sequence(new ITokenMatcher[]{ETokenType.MERGE}).createNode(EShallowEntityType.STATEMENT, "merge").skipAfter(new ITokenMatcher[]{ETokenType.ON}).repeated(SEARCH_CONDITION_TOKENS).repeatedSubRecognizer(whenThenRecognizer).optionalSubRecognizer(outputIntoRecognizer));
    }

    private void createDropRules() {
        ITokenMatcher dropTokens = ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.IDENTIFIER, ETokenType.KEY, ETokenType.GROUP, ETokenType.COLUMN, ETokenType.DATABASE, ETokenType.DEFAULT, ETokenType.EXTERNAL, ETokenType.FILE, ETokenType.TABLE, ETokenType.INDEX, ETokenType.FUNCTION, ETokenType.PROCEDURE, ETokenType.RULE, ETokenType.SCHEMA, ETokenType.STATISTICS, ETokenType.TRIGGER, ETokenType.USER, ETokenType.VIEW});
        TsqlShallowParser.endNodeWithNextStartToken(this.inState(new ETsqlParserStates[]{ETsqlParserStates.STATEMENTS}).sequence(new ITokenMatcher[]{ETokenType.DROP}).createNode(EShallowEntityType.STATEMENT, "drop").repeated(dropTokens).optional(new ITokenMatcher[]{ETokenType.IF, ETokenType.EXISTS}));
    }

    private void createSelectRule() {
        this.inState(new ETsqlParserStates[]{ETsqlParserStates.STATEMENTS}).sequence(new ITokenMatcher[]{ETokenType.SELECT}).createNode(EShallowEntityType.STATEMENT, "select").skipBeforeWithNesting(END_TOKENS, Arrays.asList(ETokenType.LPAREN, ETokenType.CASE, ETokenType.UNION, ETokenType.INTERSECT, ETokenType.EXCEPT), Arrays.asList(ETokenType.RPAREN, ETokenType.END, ETokenType.SELECT, ETokenType.SELECT, ETokenType.SELECT)).optional(new ITokenMatcher[]{ETokenType.SEMICOLON}).endNode();
    }

    private void createInsertRules() {
        ITokenMatcher insertTokensToSkip = ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.INTO, ETokenType.OUTPUT, ETokenType.TOP, ETokenType.IDENTIFIER, ETokenType.INTEGER_LITERAL, ETokenType.LPAREN, ETokenType.RPAREN, ETokenType.DOT, ETokenType.COMMA, ETokenType.WITH});
        RecognizerBase fromInsertTo = this.inState(new ETsqlParserStates[]{ETsqlParserStates.STATEMENTS}).sequence(new ITokenMatcher[]{ETokenType.INSERT}).skipWhile(insertTokensToSkip);
        TsqlShallowParser.createInsertStatement(fromInsertTo.optional(new ITokenMatcher[]{ETokenType.DEFAULT}).sequence(new ITokenMatcher[]{ETokenType.VALUES}));
        TsqlShallowParser.createInsertStatement(fromInsertTo.sequence(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.EXEC, ETokenType.EXECUTE})));
        TsqlShallowParser.createInsertStatement(fromInsertTo.sequence(new ITokenMatcher[]{ETokenType.SELECT}));
        RecognizerBase withSubRecognizer = this.createRecognizer(start -> start.sequence(new ITokenMatcher[]{ETokenType.WITH, ETokenType.LPAREN}).skipAfterWithNesting((ITokenMatcher)ETokenType.RPAREN, ETokenType.LPAREN, ETokenType.RPAREN));
        TsqlShallowParser.endNodeWithNextStartToken(this.inState(new ETsqlParserStates[]{ETsqlParserStates.STATEMENTS}).sequence(new ITokenMatcher[]{ETokenType.BULK, ETokenType.INSERT}).createNode(EShallowEntityType.STATEMENT, "bulk insert").skipAfter(new ITokenMatcher[]{ETokenType.FROM}).sequence(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.STRING_LITERAL, ETokenType.IDENTIFIER})).optionalSubRecognizer(withSubRecognizer));
    }

    private static void createInsertStatement(RecognizerBase<ETsqlParserStates> recognizerBase) {
        TsqlShallowParser.endNodeWithNextStartToken(recognizerBase.createNode(EShallowEntityType.STATEMENT, "insert"));
    }

    private void createDatabaseBeginAndEndRules() {
        for (ETokenType token : EnumSet.of(ETokenType.TRAN, ETokenType.TRANSACTION)) {
            TsqlShallowParser.endNodeWithNextStartToken(this.inState(new ETsqlParserStates[]{ETsqlParserStates.STATEMENTS}).sequence(new ITokenMatcher[]{ETokenType.BEGIN}).optional(new ITokenMatcher[]{ETokenType.DISTRIBUTED}).sequence(new ITokenMatcher[]{token}).createNode(EShallowEntityType.STATEMENT, "begin " + token.name().toLowerCase()));
        }
        TsqlShallowParser.endNodeWithNextStartToken(this.inState(new ETsqlParserStates[]{ETsqlParserStates.STATEMENTS}).sequence(new ITokenMatcher[]{ETokenType.BEGIN, ETokenType.DIALOG}).createNode(EShallowEntityType.STATEMENT, "begin", INameResolver.secondMatchedTokenText()));
        TsqlShallowParser.endNodeWithNextStartToken(this.inState(new ETsqlParserStates[]{ETsqlParserStates.STATEMENTS}).sequence(new ITokenMatcher[]{ETokenType.BEGIN, ETokenType.CONVERSATION}).createNode(EShallowEntityType.STATEMENT, "begin", INameResolver.secondMatchedTokenText()));
        TsqlShallowParser.endNodeWithNextStartToken(this.inState(new ETsqlParserStates[]{ETsqlParserStates.STATEMENTS}).sequence(new ITokenMatcher[]{ETokenType.END, ETokenType.CONVERSATION, ETokenType.IDENTIFIER}).createNode(EShallowEntityType.STATEMENT, "end", INameResolver.secondMatchedTokenText()).optional(new ITokenMatcher[]{ETokenType.WITH, ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.ERROR, ETokenType.CLEANUP})}));
    }

    private void createDeclareRule() {
        TsqlShallowParser.endNodeWithNextStartToken(this.inState(new ETsqlParserStates[]{ETsqlParserStates.STATEMENTS}).sequence(new ITokenMatcher[]{ETokenType.DECLARE}).skipWhile(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.IDENTIFIER, ETokenType.STRING_LITERAL, ETokenType.INSENSITIVE, ETokenType.SCROLL, ETokenType.DOT})).sequence(new ITokenMatcher[]{ETokenType.CURSOR}).createNode(EShallowEntityType.STATEMENT, "declare cursor").skipAfter(new ITokenMatcher[]{ETokenType.FOR}).parseOnce(ETsqlParserStates.STATEMENTS));
    }

    private void createUpdateRules() {
        TsqlShallowParser.endNodeWithNextStartToken(this.inState(new ETsqlParserStates[]{ETsqlParserStates.STATEMENTS}).sequence(new ITokenMatcher[]{ETokenType.UPDATE, ETokenType.STATISTICS}).createNode(EShallowEntityType.STATEMENT, "update", INameResolver.secondMatchedTokenText()));
        TsqlShallowParser.endNodeWithNextStartToken(this.inState(new ETsqlParserStates[]{ETsqlParserStates.STATEMENTS}).sequence(new ITokenMatcher[]{ETokenType.UPDATE}).createNode(EShallowEntityType.STATEMENT, "update").skipAfterWithNesting((ITokenMatcher)ETokenType.SET, Arrays.asList(ETokenType.LPAREN, ETokenType.CASE), Arrays.asList(ETokenType.RPAREN, ETokenType.END)));
    }

    private void createGrantRule() {
        TsqlShallowParser.endNodeWithNextStartToken(this.inState(new ETsqlParserStates[]{ETsqlParserStates.STATEMENTS}).sequence(new ITokenMatcher[]{ETokenType.GRANT}).skipAfter(new ITokenMatcher[]{ETokenType.TO}).sequence(new ITokenMatcher[]{ETokenType.IDENTIFIER}).repeated(new ITokenMatcher[]{ETokenType.COMMA, ETokenType.TEXT}).optional(new ITokenMatcher[]{ETokenType.WITH, ETokenType.GRANT, ETokenType.OPTION}).createNode(EShallowEntityType.STATEMENT, "grant", INameResolver.secondMatchedTokenText()));
    }

    private void createCreateOrAlterRules() {
        this.createProcedureRule();
        this.createFunctionRule();
        this.createSetRules();
        this.createViewRule();
        this.createTriggerRule();
        this.createGeneralCreateAlterRules();
    }

    private void createProcedureRule() {
        this.startCreateAlterRule().sequence(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.PROC, ETokenType.PROCEDURE})).createNode(EShallowEntityType.METHOD, INameResolver.concat(INameResolver.firstMatchedTokenText(), INameResolver.ofString("procedure"))).skipAfterWithNesting((ITokenMatcher)ETokenType.AS, ETokenType.LPAREN, ETokenType.RPAREN).parseUntil(ETsqlParserStates.STATEMENTS).sequenceBefore(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.GO, ETokenType.EOF})).optional(new ITokenMatcher[]{ETokenType.EOF}).endNode();
    }

    private void createFunctionRule() {
        this.startCreateAlterRule().sequence(new ITokenMatcher[]{ETokenType.FUNCTION}).createNode(EShallowEntityType.METHOD, INameResolver.concat(INameResolver.firstMatchedTokenText(), INameResolver.ofString("function"))).skipBefore(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.RETURN, ETokenType.BEGIN})).parseOnce(ETsqlParserStates.STATEMENTS).endNode();
    }

    private void createSetRules() {
        EnumSet<ETokenType> optionalSet = EnumSet.of(ETokenType.DATABASE, ETokenType.EXTERNAL, ETokenType.INDEX, ETokenType.TABLE);
        for (ETokenType setToken : optionalSet) {
            TsqlShallowParser.endNodeWithNextStartToken(this.startCreateAlterRule().sequence(new ITokenMatcher[]{setToken}).skipWhile(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.IDENTIFIER, ETokenType.DOT, ETokenType.AUTHORIZATION, ETokenType.STRING_LITERAL, ETokenType.CONFIGURATION})).sequence(new ITokenMatcher[]{ETokenType.SET}).createNode(EShallowEntityType.STATEMENT, INameResolver.firstMatchedTokenText()));
        }
    }

    private void createViewRule() {
        this.startCreateAlterRule().sequence(new ITokenMatcher[]{ETokenType.VIEW}).createNode(EShallowEntityType.STATEMENT, INameResolver.concat(INameResolver.firstMatchedTokenText(), INameResolver.ofString("view"))).skipBefore(new ITokenMatcher[]{ETokenType.SELECT}).parseOnce(ETsqlParserStates.STATEMENTS).endNode();
    }

    private void createTriggerRule() {
        this.startCreateAlterRule().sequence(new ITokenMatcher[]{ETokenType.TRIGGER}).createNode(EShallowEntityType.STATEMENT, INameResolver.concat(INameResolver.firstMatchedTokenText(), INameResolver.ofString("trigger"))).skipAfterWithNesting((ITokenMatcher)ETokenType.AS, Arrays.asList(ETokenType.LPAREN, ETokenType.EXECUTE), Arrays.asList(ETokenType.RPAREN, ETokenType.AS)).parseUntil(ETsqlParserStates.STATEMENTS).sequenceBefore(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.GO, ETokenType.EOF})).optional(new ITokenMatcher[]{ETokenType.EOF}).endNode();
    }

    private void createGeneralCreateAlterRules() {
        this.createAddConstraintExceptionRule();
        TsqlShallowParser.endNodeWithNextStartToken(this.startCreateAlterRule().createNode(EShallowEntityType.STATEMENT, INameResolver.firstMatchedTokenText()));
    }

    private void createAddConstraintExceptionRule() {
        ITokenMatcher notEndTokens = END_TOKENS.or(new ITokenMatcher[]{ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.ON, ETokenType.ADD, ETokenType.DEFAULT})}).except(new ITokenMatcher[]{ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.RPAREN, ETokenType.RBRACE, ETokenType.WITH})}).negated();
        List<RecognizerBase> constraintExceptionRecognizers = Arrays.asList(this.createRecognizer(start -> start.sequence(new ITokenMatcher[]{ETokenType.ON}).sequence(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.DELETE, ETokenType.INSERT, ETokenType.UPDATE}))), this.createRecognizer(start -> start.sequence(new ITokenMatcher[]{ETokenType.DEFAULT})));
        for (RecognizerBase constraintExceptionRecognizer : constraintExceptionRecognizers) {
            TsqlShallowParser.endNodeWithNextStartToken(this.startCreateAlterRule().skipWhile(notEndTokens).sequence(new ITokenMatcher[]{ETokenType.ADD, ETokenType.CONSTRAINT}).skipWhile(notEndTokens).optionalSubRecognizer(constraintExceptionRecognizer).createNode(EShallowEntityType.STATEMENT, INameResolver.firstMatchedTokenText()));
        }
        TsqlShallowParser.endNodeWithNextStartToken(this.startCreateAlterRule().skipWhile(notEndTokens).sequence(new ITokenMatcher[]{ETokenType.ADD, ETokenType.DEFAULT}).createNode(EShallowEntityType.STATEMENT, INameResolver.firstMatchedTokenText()));
        TsqlShallowParser.endNodeWithNextStartToken(this.startCreateAlterRule().skipWhile(notEndTokens).sequence(new ITokenMatcher[]{ETokenType.DROP, ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.COLUMN, ETokenType.CONSTRAINT})}).optional(new ITokenMatcher[]{ETokenType.IF, ETokenType.EXISTS}).createNode(EShallowEntityType.STATEMENT, INameResolver.firstMatchedTokenText()));
    }

    private void createVariableRules() {
        TsqlShallowParser.endNodeWithNextStartToken(this.inState(new ETsqlParserStates[]{ETsqlParserStates.STATEMENTS}).sequence(new ITokenMatcher[]{ETokenType.DECLARE}).createNode(EShallowEntityType.STATEMENT, "declare"));
    }

    private void createCommonTableExpressionRules() {
        RecognizerBase columnList = this.createRecognizer(start -> start.sequence(new ITokenMatcher[]{ETokenType.LPAREN}).skipAfterWithNesting((ITokenMatcher)ETokenType.RPAREN, ETokenType.LPAREN, ETokenType.RPAREN));
        RecognizerBase cteRecognizer = this.createRecognizer(start -> start.sequence(new ITokenMatcher[]{ETokenType.IDENTIFIER}).optionalSubRecognizer(columnList).sequence(new ITokenMatcher[]{ETokenType.AS, ETokenType.LPAREN}).parseOnce(ETsqlParserStates.STATEMENTS).sequence(new ITokenMatcher[]{ETokenType.RPAREN}));
        RecognizerBase cteListRecognizer = this.createRecognizer(start -> start.sequence(new ITokenMatcher[]{ETokenType.COMMA}).subRecognizer(cteRecognizer));
        TsqlShallowParser.endNodeWithNextStartToken(this.inState(new ETsqlParserStates[]{ETsqlParserStates.STATEMENTS}).sequence(new ITokenMatcher[]{ETokenType.WITH}).createNode(EShallowEntityType.STATEMENT, "common table expression").subRecognizer(cteRecognizer).repeatedSubRecognizer(cteListRecognizer));
    }

    private void createReturnRules() {
        RecognizerBase<ETsqlParserStates> returnStatement = this.inState(new ETsqlParserStates[]{ETsqlParserStates.STATEMENTS}).sequence(new ITokenMatcher[]{ETokenType.RETURN}).createNode(EShallowEntityType.STATEMENT, "return");
        TsqlShallowParser.endNodeWithNextStartToken(returnStatement.sequence(LITERALS));
        TsqlShallowParser.endNodeWithNextStartToken(returnStatement.parseOnce(ETsqlParserStates.STATEMENTS));
        TsqlShallowParser.endNodeWithNextStartToken(returnStatement);
    }

    private void createBlockRules() {
        TsqlShallowParser.endNodeWithNextStartToken(this.inState(new ETsqlParserStates[]{ETsqlParserStates.STATEMENTS}).sequence(BLOCK_RULE_START_TOKENS).createNode(EShallowEntityType.STATEMENT, INameResolver.matchStartTokenTypeName()).skipBeforeWithNesting(END_TOKENS.except(new ITokenMatcher[]{ETokenType.UPDATE}), Arrays.asList(ETokenType.LPAREN, ETokenType.CASE), Arrays.asList(ETokenType.RPAREN, ETokenType.END)).parseOnce(ETsqlParserStates.STATEMENTS));
        this.inState(new ETsqlParserStates[]{ETsqlParserStates.STATEMENTS}).sequence(new ITokenMatcher[]{ETokenType.BEGIN, ETokenType.TRY}).createNode(EShallowEntityType.STATEMENT, "try").parseUntil(ETsqlParserStates.STATEMENTS).sequence(new ITokenMatcher[]{ETokenType.END, ETokenType.TRY}).endNode();
        this.inState(new ETsqlParserStates[]{ETsqlParserStates.STATEMENTS}).sequence(new ITokenMatcher[]{ETokenType.BEGIN, ETokenType.CATCH}).createNode(EShallowEntityType.STATEMENT, "catch").parseUntil(ETsqlParserStates.STATEMENTS).sequence(new ITokenMatcher[]{ETokenType.END, ETokenType.CATCH}).optional(new ITokenMatcher[]{ETokenType.SEMICOLON}).endNode();
        this.inState(new ETsqlParserStates[]{ETsqlParserStates.STATEMENTS}).sequence(new ITokenMatcher[]{ETokenType.BEGIN}).createNode(EShallowEntityType.STATEMENT, "block").parseUntil(ETsqlParserStates.STATEMENTS).sequence(new ITokenMatcher[]{ETokenType.END}).endNode();
    }

    private void createOtherStartRules() {
        TsqlShallowParser.endNodeWithNextStartToken(this.inState(new ETsqlParserStates[]{ETsqlParserStates.STATEMENTS}).sequence(GENERAL_RULE_START_TOKENS).createNode(EShallowEntityType.STATEMENT, INameResolver.matchStartTokenTypeName()));
    }

    private RecognizerBase<ETsqlParserStates> startCreateAlterRule() {
        ITokenMatcher createOrAlter = ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.CREATE, ETokenType.ALTER});
        return this.inState(new ETsqlParserStates[]{ETsqlParserStates.STATEMENTS}).sequence(createOrAlter).optional(new ITokenMatcher[]{ETokenType.OR, createOrAlter});
    }

    private static void endNodeWithNextStartToken(RecognizerBase<ETsqlParserStates> node) {
        node.skipBeforeWithNesting(END_TOKENS, Arrays.asList(ETokenType.LPAREN, ETokenType.CASE), Arrays.asList(ETokenType.RPAREN, ETokenType.END)).optional(new ITokenMatcher[]{ETokenType.SEMICOLON}).endNode();
    }

    public static enum ETsqlParserStates {
        STATEMENTS;

    }
}

