/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.framework.util;

import eu.cqse.check.framework.matcher.ITokenMatcher;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamTextUtils;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.languages.cs.CsShallowParser;
import eu.cqse.check.framework.util.CLikeLanguageFeatureParserBase;
import eu.cqse.check.framework.util.tokens.TokenPattern;
import eu.cqse.check.framework.util.tokens.TokenPatternMatch;
import eu.cqse.check.framework.util.variable.CSVariableUseExtractor;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.UnmodifiableList;

public class CsLanguageFeatureParser
extends CLikeLanguageFeatureParserBase {
    private static final Set<ETokenType> IN_OUT_KEYWORDS = CollectionUtils.asUnmodifiable(EnumSet.of(ETokenType.IN, ETokenType.OUT));
    private static final ITokenMatcher ACCESS_KEYWORDS = ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.BASE, ETokenType.THIS});
    private static final ITokenMatcher ADDITIONAL_TYPE_TOKENS = ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.IDENTIFIER, ETokenType.VAR, ETokenType.STRING, ETokenType.OBJECT});
    private static final ITokenMatcher PRIMITIVE_TYPE_TOKENS = ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.BOOL, ETokenType.CHAR, ETokenType.BYTE, ETokenType.SBYTE, ETokenType.SHORT, ETokenType.INT, ETokenType.LONG, ETokenType.USHORT, ETokenType.UINT, ETokenType.ULONG, ETokenType.FLOAT, ETokenType.DOUBLE, ETokenType.DECIMAL, ETokenType.VOID, ETokenType.QUESTION});
    private static final ITokenMatcher VARIABLE_DECLARATION_MODIFIERS = ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.PUBLIC, ETokenType.PRIVATE, ETokenType.INTERNAL, ETokenType.PROTECTED, ETokenType.CONST, ETokenType.READONLY, ETokenType.STATIC, ETokenType.VOLATILE, ETokenType.NEW});
    private static final String EVENT_ARGS_SUFFIX = "EventArgs";
    private static final int ACCESS_KEYWORD_GROUP_INDEX = 0;
    private static final TokenPattern ACCESS_CONSTRUCTORS_IN_CONSTRUCTOR_PATTERN = new TokenPattern().sequence(ETokenType.IDENTIFIER, new TokenPattern().skipNested(ETokenType.LPAREN, ETokenType.RPAREN, false), ETokenType.COLON).sequence(new TokenPattern().alternative(ACCESS_KEYWORDS)).skipNested(ETokenType.LPAREN, ETokenType.RPAREN, false).group(0);
    private static final Set<String> GENERIC_EXCEPTION_NAMES = CollectionUtils.asHashSet((Object[])new String[]{"Exception", "ApplicationException", "SystemException"});

    CsLanguageFeatureParser() {
        super(ELanguage.CS, CsShallowParser.VALID_IDENTIFIERS, PRIMITIVE_TYPE_TOKENS, ADDITIONAL_TYPE_TOKENS, ETokenType.DOT, ".", new CSVariableUseExtractor(ETokenType.DOT, CsShallowParser.VALID_IDENTIFIERS), ETokenType.COMMA);
    }

    @Override
    public String getImportName(ShallowEntity entity) {
        CCSMAssert.isTrue((boolean)this.isImport(entity), (String)"entity.getType() must be equal to EShallowEntityType.META and entity.getSubtype() must be equal to SubTypeNames.USING");
        UnmodifiableList tokens = entity.ownStartTokens();
        if (TokenStreamUtils.containsAll((List<IToken>)tokens, ETokenType.EQ)) {
            return null;
        }
        int lastIdentifierIndex = TokenStreamUtils.lastTokenMatching((List<IToken>)tokens, CsShallowParser.VALID_IDENTIFIERS);
        if (lastIdentifierIndex == -1) {
            return null;
        }
        return TokenStreamTextUtils.concatTokenTexts(tokens.subList(1, lastIdentifierIndex + 1));
    }

    @Override
    public boolean isImport(ShallowEntity entity) {
        return entity.getType().equals((Object)EShallowEntityType.META) && entity.getSubtype().equals("using");
    }

    public boolean isEventHandler(ShallowEntity method) {
        CCSMAssert.isTrue((method.getType() == EShallowEntityType.METHOD ? 1 : 0) != 0, (String)"method.getType() must be \"METHOD\"");
        if (!this.hasVoidReturnType(method)) {
            return false;
        }
        List<List<IToken>> parameterTokens = this.getSplitParameterTokens(method);
        if (parameterTokens.size() != 2) {
            return false;
        }
        List<IToken> firstParameter = parameterTokens.get(0);
        List<IToken> secondParameter = parameterTokens.get(1);
        if (!TokenStreamUtils.hasTypes(firstParameter, ETokenType.OBJECT, ETokenType.IDENTIFIER)) {
            return false;
        }
        String secondType = (String)this.getModifiersAndTypeFromTokens(secondParameter).getSecond();
        return secondType.endsWith(EVENT_ARGS_SUFFIX);
    }

    public boolean isPartial(ShallowEntity entity) {
        return TokenStreamUtils.firstTokenMatching((List<IToken>)entity.ownStartTokens(), (ITokenMatcher)ETokenType.PARTIAL) != -1;
    }

    public List<IToken> getConstructorCallParameterTokens(ShallowEntity constructor) {
        TokenPatternMatch match = ACCESS_CONSTRUCTORS_IN_CONSTRUCTOR_PATTERN.findFirstMatch((List<IToken>)constructor.includedTokens());
        if (match == null) {
            return CollectionUtils.emptyList();
        }
        return TokenStreamUtils.tokensBetweenWithNesting(match.groupTokens(0), ETokenType.LPAREN, ETokenType.RPAREN);
    }

    @Override
    public boolean containsVariableLengthArgumentListIndicator(List<IToken> tokens) {
        return TokenStreamUtils.containsAny(tokens, ETokenType.PARAMS, ETokenType.THIS, ETokenType.EQ);
    }

    @Override
    protected List<IToken> filterGenericTokens(List<IToken> genericTokens) {
        return CollectionUtils.filter(genericTokens, token -> !IN_OUT_KEYWORDS.contains(token.getType()));
    }

    public List<String> getParentNames(ShallowEntity type) {
        CCSMAssert.isTrue((type.getType() == EShallowEntityType.TYPE ? 1 : 0) != 0, (String)"type.getType() must be \"TYPE\"");
        List<IToken> inheritanceTokens = TokenStreamUtils.tokensBetween((List<IToken>)type.ownStartTokens(), ETokenType.COLON, ETokenType.LBRACE);
        if (inheritanceTokens.isEmpty()) {
            return CollectionUtils.emptyList();
        }
        List<List<IToken>> splitInheritanceTokens = TokenStreamUtils.splitWithNesting(inheritanceTokens, ETokenType.COMMA, ETokenType.LT, ETokenType.GT);
        return TokenStreamTextUtils.concatAllTokenTexts(splitInheritanceTokens);
    }

    public List<IToken> getVariableNamesFromForLikeTokens(List<IToken> forLikeTokens, ETokenType endToken) {
        List<IToken> variableDeclarationTokens = this.getVariableTokensFromForLikeTokens(forLikeTokens, endToken);
        return this.getVariableDeclarationNamesFromTokens(variableDeclarationTokens);
    }

    public List<IToken> getVariableDeclarationNamesFromTokens(List<IToken> variableDeclarationTokens) {
        IToken token2;
        IToken token1;
        ArrayList<IToken> variableNames = new ArrayList<IToken>();
        int offset = 0;
        while (!variableDeclarationTokens.isEmpty() && VARIABLE_DECLARATION_MODIFIERS.matches(variableDeclarationTokens.get(offset))) {
            ++offset;
        }
        if (variableDeclarationTokens.size() >= 2 + offset && this.isVariableDeclaration(token1 = variableDeclarationTokens.get(offset), token2 = variableDeclarationTokens.get(1 + offset))) {
            variableNames.add(token2);
            CsLanguageFeatureParser.addAdditionalVariableNameTokens(variableDeclarationTokens, offset, variableNames);
        }
        return variableNames;
    }

    private static void addAdditionalVariableNameTokens(List<IToken> variableDeclarationTokens, int offset, List<IToken> variableNames) {
        int parenthesisNesting = 0;
        for (int i = 2 + offset; i < variableDeclarationTokens.size(); ++i) {
            IToken token = variableDeclarationTokens.get(i);
            ETokenType tokenType = token.getType();
            if (tokenType == ETokenType.LPAREN) {
                ++parenthesisNesting;
                continue;
            }
            if (tokenType == ETokenType.RPAREN) {
                --parenthesisNesting;
                continue;
            }
            if (tokenType != ETokenType.IDENTIFIER || parenthesisNesting != 0 || variableDeclarationTokens.get(i - 1).getType() != ETokenType.COMMA) continue;
            variableNames.add(token);
        }
    }

    private boolean isVariableDeclaration(IToken token1, IToken token2) {
        return this.isTypeToken(token1) && this.isValidIdentifier(token2);
    }

    public boolean isGenericExceptionClass(String className) {
        return GENERIC_EXCEPTION_NAMES.contains(className);
    }

    public Optional<String> getNamespace(List<ShallowEntity> shallowEntities) {
        return shallowEntities.stream().filter(entity -> entity.getType() == EShallowEntityType.MODULE && entity.getSubtype().equals("namespace")).map(ShallowEntity::getName).findFirst();
    }

    public TokenPattern classExtendsPattern() {
        return new TokenPattern().sequence(ETokenType.CLASS, ETokenType.IDENTIFIER).skipNested(ETokenType.LT, ETokenType.GT, true).sequence(ETokenType.COLON);
    }
}

