/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.assessment;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import org.conqat.lib.commons.js_export.ExportToTypeScript;
import org.conqat.lib.commons.test.IndexValueClass;

@ExportToTypeScript
@IndexValueClass(containedInBackup=true)
public enum ETrafficLightColor {
    RED("#dd513a", "#dd513a", "Red"),
    ORANGE("#ff9966", "#5a908c", "Orange"),
    YELLOW("#fde725", "#fde725", "Yellow"),
    GREEN("#44bf70", "#77afd8", "Green"),
    BASELINE("#dfeaf4", "#cddeef", "Baseline"),
    UNKNOWN("#666666", "#666666", "");

    private final String displayText = this.name().charAt(0) + this.name().substring(1).toLowerCase();
    private final String assessmentDisplayName;
    private final String hexValue;
    private final Color color;
    private final String colorBlindHexValue;
    private final Color colorBlindColor;

    private ETrafficLightColor(String hexValue, String colorBlindHexValue, String assessmentDisplayName) {
        this.assessmentDisplayName = assessmentDisplayName;
        this.hexValue = hexValue;
        this.color = Color.decode(hexValue);
        this.colorBlindHexValue = colorBlindHexValue;
        this.colorBlindColor = Color.decode(colorBlindHexValue);
    }

    public String getDisplayText() {
        return this.displayText;
    }

    public String getAssessmentDisplayName() {
        return this.assessmentDisplayName;
    }

    public String getHexValue() {
        return this.hexValue;
    }

    public String getColorBlindHexValue() {
        return this.colorBlindHexValue;
    }

    public Color getColor(boolean colorBlindModeEnabled) {
        if (colorBlindModeEnabled) {
            return this.colorBlindColor;
        }
        return this.color;
    }

    public static ETrafficLightColor getDominantColor(ETrafficLightColor color1, ETrafficLightColor color2) {
        if (color2.ordinal() < color1.ordinal()) {
            return color2;
        }
        return color1;
    }

    public static List<ETrafficLightColor> getTrafficLightColors() {
        ArrayList<ETrafficLightColor> trafficLights = new ArrayList<ETrafficLightColor>();
        trafficLights.add(RED);
        trafficLights.add(YELLOW);
        trafficLights.add(GREEN);
        return trafficLights;
    }
}

