/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.cache4j;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.conqat.lib.commons.cache4j.BasicCache;
import org.conqat.lib.commons.cache4j.ICache;
import org.conqat.lib.commons.cache4j.backend.ICacheBackend;
import org.conqat.lib.commons.factory.IParameterizedFactory;

public class ThreadLocalCache<K, V, X extends Exception>
implements ICache<K, V, X> {
    private final String name;
    private final IParameterizedFactory<V, K, X> factory;
    private final ICacheBackend<K, V> backend;
    private final List<BasicCache<K, V, X>> subCaches = Collections.synchronizedList(new ArrayList());
    private final ThreadLocal<BasicCache<K, V, X>> localCaches = new ThreadLocal<BasicCache<K, V, X>>(){

        @Override
        protected BasicCache<K, V, X> initialValue() {
            BasicCache cache = new BasicCache(ThreadLocalCache.this.name + ":" + Thread.currentThread().getId(), ThreadLocalCache.this.factory, ThreadLocalCache.this.backend.newInstance());
            ThreadLocalCache.this.subCaches.add(cache);
            return cache;
        }
    };

    public ThreadLocalCache(String name, IParameterizedFactory<V, K, X> factory, ICacheBackend<K, V> backend) {
        this.name = name;
        this.factory = factory;
        this.backend = backend;
    }

    @Override
    public V obtain(K parameter) throws X {
        return this.localCaches.get().obtain(parameter);
    }

    @Override
    public void clear(boolean allThreads) {
        if (allThreads) {
            for (BasicCache<K, V, X> cache : this.subCaches) {
                cache.clear(false);
            }
        } else {
            this.localCaches.get().clear(false);
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getHits() {
        int result = 0;
        for (BasicCache<K, V, X> cache : this.subCaches) {
            result += cache.getHits();
        }
        return result;
    }

    @Override
    public int getMisses() {
        int result = 0;
        for (BasicCache<K, V, X> cache : this.subCaches) {
            result += cache.getMisses();
        }
        return result;
    }

    @Override
    public long getMissCostMillis() {
        long result = 0L;
        for (BasicCache<K, V, X> cache : this.subCaches) {
            result += cache.getMissCostMillis();
        }
        return result;
    }
}

