/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.collections;

import java.util.Collection;
import java.util.Collections;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.function.IntFunction;
import java.util.stream.Stream;
import org.conqat.lib.commons.collections.UnmodifiableCollection;
import org.conqat.lib.commons.collections.UnmodifiableIterator;
import org.jspecify.annotations.NonNull;

final class UnmodifiableCollectionImpl<E>
implements UnmodifiableCollection<E> {
    private static final long serialVersionUID = 1L;
    private final Collection<E> collection;

    public UnmodifiableCollectionImpl(Collection<E> collection) {
        this.collection = Collections.unmodifiableCollection(collection);
    }

    @Override
    public @NonNull UnmodifiableIterator<E> iterator() {
        return UnmodifiableIterator.of(this.collection.iterator());
    }

    @Override
    public int size() {
        return this.collection.size();
    }

    @Override
    public boolean isEmpty() {
        return this.collection.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.collection.contains(o);
    }

    @Override
    public Object @NonNull [] toArray() {
        return this.collection.toArray();
    }

    @Override
    public <T> T @NonNull [] toArray(T @NonNull [] a) {
        return this.collection.toArray(a);
    }

    @Override
    public boolean containsAll(@NonNull Collection<?> c) {
        return this.collection.containsAll(c);
    }

    @Override
    public <T> T[] toArray(IntFunction<T[]> generator) {
        return this.collection.toArray(generator);
    }

    @Override
    public Spliterator<E> spliterator() {
        return this.collection.spliterator();
    }

    @Override
    public Stream<E> stream() {
        return this.collection.stream();
    }

    @Override
    public Stream<E> parallelStream() {
        return this.collection.parallelStream();
    }

    @Override
    public void forEach(Consumer<? super E> action) {
        this.collection.forEach(action);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof UnmodifiableCollectionImpl) {
            UnmodifiableCollectionImpl that = (UnmodifiableCollectionImpl)o;
            return this.collection.equals(that.collection);
        }
        return this.collection.equals(o);
    }

    @Override
    public int hashCode() {
        return this.collection.hashCode();
    }

    public String toString() {
        return this.collection.toString();
    }
}

